/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.IJavaScriptProject;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.internal.core.CompilationUnit;
import org.ccdt.jsdt.internal.core.JavaElementDelta;
import org.ccdt.jsdt.internal.core.JavaModelManager;
import org.ccdt.jsdt.internal.core.JavaModelOperation;
import org.ccdt.jsdt.internal.core.JavaProject;

public class DiscardWorkingCopyOperation
extends JavaModelOperation {
    public DiscardWorkingCopyOperation(IJavaScriptElement iJavaScriptElement) {
        super(new IJavaScriptElement[]{iJavaScriptElement});
    }

    @Override
    protected void executeOperation() throws JavaScriptModelException {
        CompilationUnit compilationUnit = this.getWorkingCopy();
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        int n2 = javaModelManager.discardPerWorkingCopyInfo(compilationUnit);
        if (n2 == 0) {
            IJavaScriptProject iJavaScriptProject = compilationUnit.getJavaScriptProject();
            if (" ".equals(iJavaScriptProject.getElementName())) {
                javaModelManager.removePerProjectInfo((JavaProject)iJavaScriptProject);
                javaModelManager.containerRemove(iJavaScriptProject);
            }
            if (!compilationUnit.isPrimary()) {
                JavaElementDelta javaElementDelta = new JavaElementDelta(this.getJavaModel());
                javaElementDelta.removed(compilationUnit);
                this.addDelta(javaElementDelta);
                this.removeReconcileDelta(compilationUnit);
            } else if (compilationUnit.getResource().isAccessible()) {
                JavaElementDelta javaElementDelta = new JavaElementDelta(this.getJavaModel());
                javaElementDelta.changed(compilationUnit, 65536);
                this.addDelta(javaElementDelta);
            } else {
                JavaElementDelta javaElementDelta = new JavaElementDelta(this.getJavaModel());
                javaElementDelta.removed(compilationUnit, 65536);
                this.addDelta(javaElementDelta);
            }
        }
    }

    protected CompilationUnit getWorkingCopy() {
        return (CompilationUnit)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

