/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import java.util.Iterator;
import org.ccdt.jsdt.core.Flags;
import org.ccdt.jsdt.core.IImportDeclaration;
import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.IJavaScriptModelStatus;
import org.ccdt.jsdt.core.IJavaScriptProject;
import org.ccdt.jsdt.core.IJavaScriptUnit;
import org.ccdt.jsdt.core.IType;
import org.ccdt.jsdt.core.JavaScriptConventions;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.core.compiler.CharOperation;
import org.ccdt.jsdt.core.dom.AST;
import org.ccdt.jsdt.core.dom.ASTNode;
import org.ccdt.jsdt.core.dom.ImportDeclaration;
import org.ccdt.jsdt.core.dom.JavaScriptUnit;
import org.ccdt.jsdt.core.dom.Name;
import org.ccdt.jsdt.core.dom.StructuralPropertyDescriptor;
import org.ccdt.jsdt.core.dom.rewrite.ASTRewrite;
import org.ccdt.jsdt.internal.core.CreateElementInCUOperation;
import org.ccdt.jsdt.internal.core.JavaModelStatus;
import org.ccdt.jsdt.internal.core.util.Messages;
import org.eclipse.jface.text.IDocument;

public class CreateImportOperation
extends CreateElementInCUOperation {
    protected String importName;
    protected int flags;

    public CreateImportOperation(String string, IJavaScriptUnit iJavaScriptUnit, int n2) {
        super(iJavaScriptUnit);
        this.importName = string;
        this.flags = n2;
    }

    @Override
    protected StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode aSTNode) {
        return JavaScriptUnit.IMPORTS_PROPERTY;
    }

    @Override
    protected ASTNode generateElementAST(ASTRewrite aSTRewrite, IDocument iDocument, IJavaScriptUnit iJavaScriptUnit) throws JavaScriptModelException {
        Object object;
        Iterator iterator = this.cuAST.imports().iterator();
        boolean bl2 = this.importName.endsWith(".*");
        String string = this.importName;
        if (bl2) {
            string = this.importName.substring(0, this.importName.length() - 2);
        }
        while (iterator.hasNext()) {
            object = (ImportDeclaration)iterator.next();
            if (!string.equals(((ImportDeclaration)object).getName().getFullyQualifiedName()) || bl2 != ((ImportDeclaration)object).isOnDemand() || Flags.isStatic(this.flags) != ((ImportDeclaration)object).isStatic()) continue;
            this.creationOccurred = false;
            return null;
        }
        object = this.cuAST.getAST();
        ImportDeclaration importDeclaration = ((AST)object).newImportDeclaration();
        importDeclaration.setStatic(Flags.isStatic(this.flags));
        char[][] cArray = CharOperation.splitOn('.', string.toCharArray(), 0, string.length());
        int n2 = cArray.length;
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = String.valueOf(cArray[n3]);
            ++n3;
        }
        Name name = ((AST)object).newName(stringArray);
        importDeclaration.setName(name);
        if (bl2) {
            importDeclaration.setOnDemand(true);
        }
        return importDeclaration;
    }

    @Override
    protected IJavaScriptElement generateResultHandle() {
        return this.getCompilationUnit().getImport(this.importName);
    }

    @Override
    public String getMainTaskName() {
        return Messages.operation_createImportsProgress;
    }

    @Override
    protected void initializeDefaultPosition() {
        try {
            IJavaScriptUnit iJavaScriptUnit = this.getCompilationUnit();
            IImportDeclaration[] iImportDeclarationArray = iJavaScriptUnit.getImports();
            if (iImportDeclarationArray.length > 0) {
                this.createAfter(iImportDeclarationArray[iImportDeclarationArray.length - 1]);
                return;
            }
            IType[] iTypeArray = iJavaScriptUnit.getTypes();
            if (iTypeArray.length > 0) {
                this.createBefore(iTypeArray[0]);
                return;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
    }

    @Override
    public IJavaScriptModelStatus verify() {
        IJavaScriptModelStatus iJavaScriptModelStatus = super.verify();
        if (!iJavaScriptModelStatus.isOK()) {
            return iJavaScriptModelStatus;
        }
        IJavaScriptProject iJavaScriptProject = this.getParentElement().getJavaScriptProject();
        if (JavaScriptConventions.validateImportDeclaration(this.importName, iJavaScriptProject.getOption("org.ccdt.jsdt.core.compiler.source", true), iJavaScriptProject.getOption("org.ccdt.jsdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, this.importName);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

