/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.ccdt.jsdt.core.IBuffer;
import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.IJavaScriptModelStatus;
import org.ccdt.jsdt.core.IJavaScriptProject;
import org.ccdt.jsdt.core.IJavaScriptUnit;
import org.ccdt.jsdt.core.IPackageFragment;
import org.ccdt.jsdt.core.JavaScriptConventions;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.internal.core.JavaElementDelta;
import org.ccdt.jsdt.internal.core.JavaModelOperation;
import org.ccdt.jsdt.internal.core.JavaModelStatus;
import org.ccdt.jsdt.internal.core.util.Messages;
import org.ccdt.jsdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class CreateCompilationUnitOperation
extends JavaModelOperation {
    protected String fName;
    protected String fSource = null;

    public CreateCompilationUnitOperation(IPackageFragment iPackageFragment, String string, String string2, boolean bl2) {
        super(null, new IJavaScriptElement[]{iPackageFragment}, bl2);
        this.fName = string;
        this.fSource = string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void executeOperation() throws JavaScriptModelException {
        try {
            this.beginTask(Messages.operation_createUnitProgress, 2);
            JavaElementDelta javaElementDelta = this.newJavaElementDelta();
            IJavaScriptUnit iJavaScriptUnit = this.getCompilationUnit();
            IPackageFragment iPackageFragment = (IPackageFragment)this.getParentElement();
            IContainer iContainer = (IContainer)iPackageFragment.getResource();
            this.worked(1);
            IFile iFile = iContainer.getFile((IPath)new Path(this.fName));
            if (iFile.exists()) {
                if (!this.force) throw new JavaScriptModelException(new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, iFile.getFullPath().toString())));
                IBuffer iBuffer = iJavaScriptUnit.getBuffer();
                if (iBuffer == null) {
                    return;
                }
                iBuffer.setContents(this.fSource);
                iJavaScriptUnit.save((IProgressMonitor)new NullProgressMonitor(), false);
                this.resultElements = new IJavaScriptElement[]{iJavaScriptUnit};
                if (!Util.isExcluded(iJavaScriptUnit) && iJavaScriptUnit.getParent().exists()) {
                    int n2 = 0;
                    while (n2 < this.resultElements.length) {
                        javaElementDelta.changed(this.resultElements[n2], 1);
                        ++n2;
                    }
                    this.addDelta(javaElementDelta);
                }
            } else {
                try {
                    String string = null;
                    try {
                        string = iContainer.getDefaultCharset();
                    }
                    catch (CoreException coreException) {}
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string == null ? this.fSource.getBytes() : this.fSource.getBytes(string));
                    this.createFile(iContainer, iJavaScriptUnit.getElementName(), byteArrayInputStream, this.force);
                    this.resultElements = new IJavaScriptElement[]{iJavaScriptUnit};
                    if (!Util.isExcluded(iJavaScriptUnit) && iJavaScriptUnit.getParent().exists()) {
                        int n3 = 0;
                        while (n3 < this.resultElements.length) {
                            javaElementDelta.added(this.resultElements[n3]);
                            ++n3;
                        }
                        this.addDelta(javaElementDelta);
                    }
                }
                catch (IOException iOException) {
                    throw new JavaScriptModelException(iOException, 985);
                }
            }
            this.worked(1);
            return;
        }
        finally {
            this.done();
        }
    }

    protected IJavaScriptUnit getCompilationUnit() {
        return ((IPackageFragment)this.getParentElement()).getJavaScriptUnit(this.fName);
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        IResource iResource = this.getCompilationUnit().getResource();
        IWorkspace iWorkspace = iResource.getWorkspace();
        if (iResource.exists()) {
            return iWorkspace.getRuleFactory().modifyRule(iResource);
        }
        return iWorkspace.getRuleFactory().createRule(iResource);
    }

    @Override
    public IJavaScriptModelStatus verify() {
        if (this.getParentElement() == null) {
            return new JavaModelStatus(968);
        }
        IJavaScriptProject iJavaScriptProject = this.getParentElement().getJavaScriptProject();
        if (JavaScriptConventions.validateCompilationUnitName(this.fName, iJavaScriptProject.getOption("org.ccdt.jsdt.core.compiler.source", true), iJavaScriptProject.getOption("org.ccdt.jsdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, this.fName);
        }
        if (this.fSource == null) {
            return new JavaModelStatus(984);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

