/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.ccdt.jsdt.core.IBuffer;
import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.IJavaScriptModelStatus;
import org.ccdt.jsdt.core.IJavaScriptProject;
import org.ccdt.jsdt.core.IJavaScriptUnit;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.internal.core.CompilationUnit;
import org.ccdt.jsdt.internal.core.JavaElementDeltaBuilder;
import org.ccdt.jsdt.internal.core.JavaModelOperation;
import org.ccdt.jsdt.internal.core.JavaModelStatus;
import org.ccdt.jsdt.internal.core.PackageFragmentRoot;
import org.ccdt.jsdt.internal.core.util.Messages;
import org.ccdt.jsdt.internal.core.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class CommitWorkingCopyOperation
extends JavaModelOperation {
    public CommitWorkingCopyOperation(IJavaScriptUnit iJavaScriptUnit, boolean bl2) {
        super(new IJavaScriptElement[]{iJavaScriptUnit}, bl2);
    }

    @Override
    protected void executeOperation() throws JavaScriptModelException {
        try {
            this.beginTask(Messages.workingCopy_commit, 2);
            CompilationUnit compilationUnit = this.getCompilationUnit();
            if (" ".equals(compilationUnit.getJavaScriptProject().getElementName())) {
                compilationUnit.getBuffer().save(this.progressMonitor, this.force);
                return;
            }
            IJavaScriptUnit iJavaScriptUnit = compilationUnit.getPrimary();
            boolean bl2 = compilationUnit.isPrimary();
            JavaElementDeltaBuilder javaElementDeltaBuilder = null;
            PackageFragmentRoot packageFragmentRoot = (PackageFragmentRoot)compilationUnit.getAncestor(3);
            boolean bl3 = !Util.isExcluded(compilationUnit);
            IFile iFile = (IFile)compilationUnit.getResource();
            IJavaScriptProject iJavaScriptProject = packageFragmentRoot.getJavaScriptProject();
            if (bl2 || packageFragmentRoot.validateOnClasspath().isOK() && bl3 && iFile.isAccessible() && Util.isValidCompilationUnitName(compilationUnit.getElementName(), iJavaScriptProject.getOption("org.ccdt.jsdt.core.compiler.source", true), iJavaScriptProject.getOption("org.ccdt.jsdt.core.compiler.compliance", true))) {
                if (!bl2 && !iJavaScriptUnit.isOpen()) {
                    iJavaScriptUnit.open(null);
                }
                if (!(!bl3 || bl2 && compilationUnit.isConsistent())) {
                    javaElementDeltaBuilder = new JavaElementDeltaBuilder(iJavaScriptUnit);
                }
                IBuffer iBuffer = iJavaScriptUnit.getBuffer();
                if (!bl2) {
                    if (iBuffer == null) {
                        return;
                    }
                    char[] cArray = iBuffer.getCharacters();
                    boolean bl4 = false;
                    try {
                        IBuffer iBuffer2 = compilationUnit.getBuffer();
                        if (iBuffer2 == null) {
                            return;
                        }
                        iBuffer.setContents(iBuffer2.getCharacters());
                        iBuffer.save(this.progressMonitor, this.force);
                        iJavaScriptUnit.makeConsistent(this);
                        bl4 = true;
                    }
                    finally {
                        if (!bl4) {
                            iBuffer.setContents(cArray);
                        }
                    }
                } else {
                    iBuffer.save(this.progressMonitor, this.force);
                    iJavaScriptUnit.makeConsistent(this);
                }
            } else {
                String string = null;
                try {
                    string = iFile.getCharset();
                }
                catch (CoreException coreException) {}
                String string2 = compilationUnit.getSource();
                if (string2 == null) {
                    return;
                }
                try {
                    byte[] byArray = string == null ? string2.getBytes() : string2.getBytes(string);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    if (iFile.exists()) {
                        iFile.setContents((InputStream)byteArrayInputStream, this.force ? 3 : 2, null);
                    } else {
                        iFile.create((InputStream)byteArrayInputStream, this.force, this.progressMonitor);
                    }
                }
                catch (CoreException coreException) {
                    throw new JavaScriptModelException(coreException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new JavaScriptModelException(unsupportedEncodingException, 985);
                }
            }
            CommitWorkingCopyOperation.setAttribute("hasModifiedResource", "true");
            compilationUnit.updateTimeStamp((CompilationUnit)iJavaScriptUnit);
            compilationUnit.makeConsistent(this);
            this.worked(1);
            if (javaElementDeltaBuilder != null) {
                javaElementDeltaBuilder.buildDeltas();
                if (javaElementDeltaBuilder.delta != null) {
                    this.addDelta(javaElementDeltaBuilder.delta);
                }
            }
            this.worked(1);
        }
        finally {
            this.done();
        }
    }

    protected CompilationUnit getCompilationUnit() {
        return (CompilationUnit)this.getElementToProcess();
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        IResource iResource = this.getElementToProcess().getResource();
        if (iResource == null) {
            return null;
        }
        IWorkspace iWorkspace = iResource.getWorkspace();
        if (iResource.exists()) {
            return iWorkspace.getRuleFactory().modifyRule(iResource);
        }
        return iWorkspace.getRuleFactory().createRule(iResource);
    }

    @Override
    public IJavaScriptModelStatus verify() {
        CompilationUnit compilationUnit = this.getCompilationUnit();
        if (!compilationUnit.isWorkingCopy()) {
            return new JavaModelStatus(967, compilationUnit);
        }
        if (compilationUnit.hasResourceChanged() && !this.force) {
            return new JavaModelStatus(981);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

