/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.internal.core.ClasspathChange;
import org.ccdt.jsdt.internal.core.ClasspathValidation;
import org.ccdt.jsdt.internal.core.DeltaProcessingState;
import org.ccdt.jsdt.internal.core.DeltaProcessor;
import org.ccdt.jsdt.internal.core.JavaElementDelta;
import org.ccdt.jsdt.internal.core.JavaModelManager;
import org.ccdt.jsdt.internal.core.JavaModelOperation;
import org.ccdt.jsdt.internal.core.JavaProject;
import org.ccdt.jsdt.internal.core.ProjectReferenceChange;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class ChangeClasspathOperation
extends JavaModelOperation {
    protected boolean canChangeResources;

    public ChangeClasspathOperation(IJavaScriptElement[] iJavaScriptElementArray, boolean bl2) {
        super(iJavaScriptElementArray);
        this.canChangeResources = bl2;
    }

    @Override
    protected boolean canModifyRoots() {
        return true;
    }

    protected void classpathChanged(JavaProject javaProject) throws JavaScriptModelException {
        DeltaProcessingState deltaProcessingState = JavaModelManager.getJavaModelManager().deltaState;
        DeltaProcessor deltaProcessor = deltaProcessingState.getDeltaProcessor();
        ClasspathChange classpathChange = (ClasspathChange)deltaProcessor.classpathChanges.get(javaProject.getProject());
        if (this.canChangeResources) {
            if (this.isTopLevelOperation() && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
                new ClasspathValidation(javaProject).validate();
            }
            new ProjectReferenceChange(javaProject, classpathChange.d).updateProjectReferencesIfNecessary();
        } else {
            JavaElementDelta javaElementDelta = new JavaElementDelta(this.getJavaModel());
            int n2 = classpathChange.generateDelta(javaElementDelta);
            if ((n2 & ClasspathChange.HAS_DELTA) != 0) {
                this.addDelta(javaElementDelta);
                classpathChange.requestIndexing();
                deltaProcessingState.addClasspathValidation(javaProject);
            }
            if ((n2 & ClasspathChange.HAS_PROJECT_CHANGE) != 0) {
                deltaProcessingState.addProjectReferenceChange(javaProject, classpathChange.d);
            }
        }
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return !this.canChangeResources;
    }
}

