/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.ccdt.jsdt.core.BufferChangedEvent;
import org.ccdt.jsdt.core.IBuffer;
import org.ccdt.jsdt.core.IBufferChangedListener;
import org.ccdt.jsdt.core.IOpenable;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.internal.core.Buffer$1;
import org.ccdt.jsdt.internal.core.JavaElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentDescription;

public class Buffer
implements IBuffer {
    protected IFile file;
    protected int flags;
    protected char[] contents;
    protected ArrayList changeListeners;
    protected IOpenable owner;
    protected int gapStart = -1;
    protected int gapEnd = -1;
    protected Object lock = new Object();
    protected static final int F_HAS_UNSAVED_CHANGES = 1;
    protected static final int F_IS_READ_ONLY = 2;
    protected static final int F_IS_CLOSED = 4;

    protected Buffer(IFile iFile, IOpenable iOpenable, boolean bl2) {
        this.file = iFile;
        this.owner = iOpenable;
        if (iFile == null) {
            this.setReadOnly(bl2);
        }
    }

    @Override
    public synchronized void addBufferChangedListener(IBufferChangedListener iBufferChangedListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList(5);
        }
        if (!this.changeListeners.contains(iBufferChangedListener)) {
            this.changeListeners.add(iBufferChangedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(char[] cArray) {
        if (!this.isReadOnly()) {
            if (cArray == null || cArray.length == 0) {
                return;
            }
            int n2 = this.getLength();
            Object object = this.lock;
            synchronized (object) {
                if (this.contents == null) {
                    return;
                }
                this.moveAndResizeGap(n2, cArray.length);
                System.arraycopy(cArray, 0, this.contents, n2, cArray.length);
                this.gapStart += cArray.length;
                this.flags |= 1;
            }
            this.notifyChanged(new BufferChangedEvent(this, n2, 0, new String(cArray)));
        }
    }

    @Override
    public void append(String string) {
        if (string == null) {
            return;
        }
        this.append(string.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        BufferChangedEvent bufferChangedEvent = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            bufferChangedEvent = new BufferChangedEvent(this, 0, 0, null);
            this.contents = null;
            this.flags |= 4;
        }
        this.notifyChanged(bufferChangedEvent);
        object = this;
        synchronized (object) {
            this.changeListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getChar(int n2) {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (this.contents != null) break block5;
                return '\u0000';
            }
            if (n2 < this.gapStart) {
                return this.contents[n2];
            }
            int n3 = this.gapEnd - this.gapStart;
            return this.contents[n2 + n3];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] getCharacters() {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (this.contents != null) break block5;
                return null;
            }
            if (this.gapStart < 0) {
                return this.contents;
            }
            int n2 = this.contents.length;
            char[] cArray = new char[n2 - this.gapEnd + this.gapStart];
            System.arraycopy(this.contents, 0, cArray, 0, this.gapStart);
            System.arraycopy(this.contents, this.gapEnd, cArray, this.gapStart, n2 - this.gapEnd);
            return cArray;
        }
    }

    @Override
    public String getContents() {
        char[] cArray = this.getCharacters();
        if (cArray == null) {
            return null;
        }
        return new String(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLength() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.contents != null) break block4;
                return -1;
            }
            int n2 = this.gapEnd - this.gapStart;
            return this.contents.length - n2;
        }
    }

    @Override
    public IOpenable getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getText(int n2, int n3) {
        Object object = this.lock;
        synchronized (object) {
            block6: {
                if (this.contents != null) break block6;
                return "";
            }
            if (n2 + n3 < this.gapStart) {
                return new String(this.contents, n2, n3);
            }
            if (this.gapStart < n2) {
                int n4 = this.gapEnd - this.gapStart;
                return new String(this.contents, n2 + n4, n3);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.contents, n2, this.gapStart - n2);
            stringBuffer.append(this.contents, this.gapEnd, n2 + n3 - this.gapStart);
            return stringBuffer.toString();
        }
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.file;
    }

    @Override
    public boolean hasUnsavedChanges() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isClosed() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isReadOnly() {
        return (this.flags & 2) != 0;
    }

    protected void moveAndResizeGap(int n2, int n3) {
        char[] cArray = null;
        int n4 = this.gapEnd - this.gapStart;
        if (n3 < 0) {
            if (n4 > 0) {
                cArray = new char[this.contents.length - n4];
                System.arraycopy(this.contents, 0, cArray, 0, this.gapStart);
                System.arraycopy(this.contents, this.gapEnd, cArray, this.gapStart, cArray.length - this.gapStart);
                this.contents = cArray;
            }
            this.gapStart = this.gapEnd = n2;
            return;
        }
        cArray = new char[this.contents.length + (n3 - n4)];
        int n5 = n2;
        int n6 = n5 + n3;
        if (n4 == 0) {
            System.arraycopy(this.contents, 0, cArray, 0, n5);
            System.arraycopy(this.contents, n5, cArray, n6, cArray.length - n6);
        } else if (n5 < this.gapStart) {
            int n7 = this.gapStart - n5;
            System.arraycopy(this.contents, 0, cArray, 0, n5);
            System.arraycopy(this.contents, n5, cArray, n6, n7);
            System.arraycopy(this.contents, this.gapEnd, cArray, n6 + n7, this.contents.length - this.gapEnd);
        } else {
            int n8 = n5 - this.gapStart;
            System.arraycopy(this.contents, 0, cArray, 0, this.gapStart);
            System.arraycopy(this.contents, this.gapEnd, cArray, this.gapStart, n8);
            System.arraycopy(this.contents, this.gapEnd + n8, cArray, n6, cArray.length - n6);
        }
        this.contents = cArray;
        this.gapStart = n5;
        this.gapEnd = n6;
    }

    protected void notifyChanged(BufferChangedEvent bufferChangedEvent) {
        ArrayList arrayList = this.changeListeners;
        if (arrayList != null) {
            int n2 = 0;
            int n3 = arrayList.size();
            while (n2 < n3) {
                IBufferChangedListener iBufferChangedListener = (IBufferChangedListener)arrayList.get(n2);
                SafeRunner.run((ISafeRunnable)new Buffer$1(this, iBufferChangedListener, bufferChangedEvent));
                ++n2;
            }
        }
    }

    @Override
    public synchronized void removeBufferChangedListener(IBufferChangedListener iBufferChangedListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(iBufferChangedListener);
            if (this.changeListeners.size() == 0) {
                this.changeListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(int n2, int n3, char[] cArray) {
        if (!this.isReadOnly()) {
            int n4 = cArray == null ? 0 : cArray.length;
            Object object = this.lock;
            synchronized (object) {
                if (this.contents == null) {
                    return;
                }
                this.moveAndResizeGap(n2 + n3, n4 - n3);
                int n5 = Math.min(n4, n3);
                if (n5 > 0) {
                    System.arraycopy(cArray, 0, this.contents, n2, n5);
                }
                if (n3 > n4) {
                    this.gapStart -= n3 - n4;
                } else if (n4 > n3) {
                    this.gapStart += n4 - n3;
                    System.arraycopy(cArray, 0, this.contents, n2, n4);
                }
                this.flags |= 1;
            }
            object = null;
            if (n4 > 0) {
                object = new String(cArray);
            }
            this.notifyChanged(new BufferChangedEvent(this, n2, n3, (String)object));
        }
    }

    @Override
    public void replace(int n2, int n3, String string) {
        this.replace(n2, n3, string == null ? null : string.toCharArray());
    }

    @Override
    public void save(IProgressMonitor iProgressMonitor, boolean bl2) throws JavaScriptModelException {
        if (this.isReadOnly() || this.file == null) {
            return;
        }
        if (!this.hasUnsavedChanges()) {
            return;
        }
        try {
            ByteArrayInputStream byteArrayInputStream;
            byte[] byArray;
            String string = this.getContents();
            if (string == null) {
                return;
            }
            String string2 = null;
            try {
                string2 = this.file.getCharset();
            }
            catch (CoreException coreException) {}
            byte[] byArray2 = byArray = string2 == null ? string.getBytes() : string.getBytes(string2);
            if (string2 != null && string2.equals("UTF-8") && (byteArrayInputStream = this.file.getContentDescription()) != null && byteArrayInputStream.getProperty(IContentDescription.BYTE_ORDER_MARK) != null) {
                int n2 = IContentDescription.BOM_UTF_8.length;
                byte[] byArray3 = new byte[byArray.length + n2];
                System.arraycopy(IContentDescription.BOM_UTF_8, 0, byArray3, 0, n2);
                System.arraycopy(byArray, 0, byArray3, n2, byArray.length);
                byArray = byArray3;
            }
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (this.file.exists()) {
                this.file.setContents((InputStream)byteArrayInputStream, bl2 ? 3 : 2, null);
            } else {
                this.file.create((InputStream)byteArrayInputStream, bl2, null);
            }
        }
        catch (IOException iOException) {
            throw new JavaScriptModelException(iOException, 985);
        }
        catch (CoreException coreException) {
            throw new JavaScriptModelException(coreException);
        }
        this.flags &= 0xFFFFFFFE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContents(char[] cArray) {
        if (this.contents == null) {
            Object object = this.lock;
            synchronized (object) {
                this.contents = cArray;
                this.flags &= 0xFFFFFFFE;
            }
            return;
        }
        if (!this.isReadOnly()) {
            String string = null;
            if (cArray != null) {
                string = new String(cArray);
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.contents == null) {
                    return;
                }
                this.contents = cArray;
                this.flags |= 1;
                this.gapStart = -1;
                this.gapEnd = -1;
            }
            object = new BufferChangedEvent(this, 0, this.getLength(), string);
            this.notifyChanged((BufferChangedEvent)object);
        }
    }

    @Override
    public void setContents(String string) {
        this.setContents(string.toCharArray());
    }

    protected void setReadOnly(boolean bl2) {
        this.flags = bl2 ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Owner: " + ((JavaElement)((Object)this.owner)).toStringWithAncestors());
        stringBuffer.append("\nHas unsaved changes: " + this.hasUnsavedChanges());
        stringBuffer.append("\nIs readonly: " + this.isReadOnly());
        stringBuffer.append("\nIs closed: " + this.isClosed());
        stringBuffer.append("\nContents:\n");
        char[] cArray = this.getCharacters();
        if (cArray == null) {
            stringBuffer.append("<null>");
        } else {
            int n2 = cArray.length;
            int n3 = 0;
            while (n3 < n2) {
                char c2 = cArray[n3];
                switch (c2) {
                    case '\n': {
                        stringBuffer.append("\\n\n");
                        break;
                    }
                    case '\r': {
                        if (n3 < n2 - 1 && this.contents[n3 + 1] == '\n') {
                            stringBuffer.append("\\r\\n\n");
                            ++n3;
                            break;
                        }
                        stringBuffer.append("\\r\n");
                        break;
                    }
                    default: {
                        stringBuffer.append(c2);
                    }
                }
                ++n3;
            }
        }
        return stringBuffer.toString();
    }
}

