/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import java.io.File;
import java.io.IOException;
import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.IJavaScriptProject;
import org.ccdt.jsdt.core.LibrarySuperType;
import org.ccdt.jsdt.core.compiler.CharOperation;
import org.ccdt.jsdt.internal.compiler.env.ICompilationUnit;
import org.ccdt.jsdt.internal.compiler.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class BasicCompilationUnit
implements ICompilationUnit {
    protected char[] contents;
    protected char[] fileName;
    protected char[][] packageName;
    protected char[] mainTypeName;
    protected String encoding;
    protected LibrarySuperType superType;

    public BasicCompilationUnit(char[] cArray, char[][] cArray2, String string) {
        this.contents = cArray;
        this.fileName = string.toCharArray();
        this.packageName = cArray2;
    }

    public BasicCompilationUnit(char[] cArray, char[][] cArray2, String string, String string2) {
        this(cArray, cArray2, string);
        this.encoding = string2;
    }

    public BasicCompilationUnit(char[] cArray, char[][] cArray2, String string, IJavaScriptElement iJavaScriptElement) {
        this(cArray, cArray2, string);
        if (iJavaScriptElement instanceof ICompilationUnit) {
            this.superType = ((ICompilationUnit)((Object)iJavaScriptElement)).getCommonSuperType();
        }
        this.a(iJavaScriptElement);
    }

    public BasicCompilationUnit(char[] cArray, char[][] cArray2, String string, IJavaScriptElement iJavaScriptElement, String string2) {
        this(cArray, cArray2, string);
        this.a(iJavaScriptElement);
        if (string2 != null) {
            this.mainTypeName = string2.toCharArray();
        }
    }

    private void a(IJavaScriptElement iJavaScriptElement) {
        if (iJavaScriptElement != null) {
            try {
                IJavaScriptProject iJavaScriptProject = iJavaScriptElement.getJavaScriptProject();
                switch (iJavaScriptElement.getElementType()) {
                    case 5: {
                        IFile iFile = (IFile)iJavaScriptElement.getResource();
                        if (iFile != null) {
                            this.encoding = iFile.getCharset();
                            break;
                        }
                    }
                    default: {
                        IProject iProject = (IProject)iJavaScriptProject.getResource();
                        if (iProject != null) {
                            this.encoding = iProject.getDefaultCharset();
                        }
                        break;
                    }
                }
            }
            catch (CoreException coreException) {
                this.encoding = null;
            }
        } else {
            this.encoding = null;
        }
    }

    @Override
    public char[] getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            return Util.getFileCharContent(new File(new String(this.fileName)), this.encoding);
        }
        catch (IOException iOException) {
            return CharOperation.NO_CHAR;
        }
    }

    @Override
    public char[] getFileName() {
        return this.fileName;
    }

    @Override
    public char[] getMainTypeName() {
        if (this.mainTypeName == null) {
            int n2;
            int n3;
            int n4 = CharOperation.lastIndexOf('/', this.fileName) + 1;
            if (n4 == 0 || n4 < CharOperation.lastIndexOf('\\', this.fileName)) {
                n4 = CharOperation.lastIndexOf('\\', this.fileName) + 1;
            }
            if ((n3 = CharOperation.indexOf('|', this.fileName) + 1) > n4) {
                n4 = n3;
            }
            if (!((n2 = CharOperation.lastIndexOf('$', this.fileName)) != -1 && Util.isClassFileName(this.fileName) || (n2 = CharOperation.lastIndexOf('.', this.fileName)) != -1)) {
                n2 = this.fileName.length;
            }
            this.mainTypeName = CharOperation.subarray(this.fileName, n4, n2);
        }
        return this.mainTypeName;
    }

    @Override
    public char[][] getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return "JavaScriptUnit: " + new String(this.fileName);
    }

    @Override
    public LibrarySuperType getCommonSuperType() {
        return this.superType;
    }

    @Override
    public String getInferenceID() {
        return null;
    }
}

