/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.ccdt.jsdt.core.a.ae;
import org.ccdt.jsdt.core.a.ai;
import org.ccdt.jsdt.core.a.bj;
import org.ccdt.jsdt.core.a.ce;
import org.ccdt.jsdt.core.a.cm;
import org.ccdt.jsdt.core.compiler.CharOperation;
import org.ccdt.jsdt.internal.compiler.ast.ArrayReference;
import org.ccdt.jsdt.internal.compiler.util.SuffixConstants;
import org.ccdt.jsdt.internal.compiler.util.Util$1;
import org.ccdt.jsdt.internal.compiler.util.Util$Displayable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class Util
implements SuffixConstants {
    public static final String UTF_8 = "UTF-8";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String EMPTY_STRING = new String(CharOperation.NO_CHAR);
    public static final int[] EMPTY_INT_ARRAY = new int[0];

    public static char[] bytesToChar(byte[] byArray, String string) throws IOException {
        return Util.getInputStreamAsCharArray(new ByteArrayInputStream(byArray), byArray.length, string);
    }

    public static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block7: {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                byArray = Util.getInputStreamAsByteArray(fileInputStream, (int)file.length());
                if (fileInputStream == null) break block7;
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static char[] getFileCharContent(File file, String string) throws IOException {
        char[] cArray;
        block7: {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                cArray = Util.getInputStreamAsCharArray(fileInputStream, (int)file.length(), string);
                if (fileInputStream == null) break block7;
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return cArray;
    }

    public static byte[] getInputStreamAsByteArray(InputStream inputStream, int n2) throws IOException {
        byte[] byArray;
        if (n2 == -1) {
            byArray = new byte[]{};
            int n3 = 0;
            int n4 = -1;
            do {
                int n5;
                if (n3 + (n5 = Math.max(inputStream.available(), 8192)) > byArray.length) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[n3 + n5];
                    System.arraycopy(byArray2, 0, byArray, 0, n3);
                }
                if ((n4 = inputStream.read(byArray, n3, n5)) <= 0) continue;
                n3 += n4;
            } while (n4 != -1);
            if (n3 < byArray.length) {
                byte[] byArray3 = byArray;
                byArray = new byte[n3];
                System.arraycopy(byArray3, 0, byArray, 0, n3);
            }
        } else {
            byArray = new byte[n2];
            int n6 = 0;
            int n7 = 0;
            while (n7 != -1 && n6 != n2) {
                n7 = inputStream.read(byArray, n6 += n7, n2 - n6);
            }
        }
        return byArray;
    }

    public static char[] getInputStreamAsCharArray(InputStream inputStream, int n2, String string) throws IOException {
        int n3;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        int n4 = 0;
        char[] cArray = n2 == -1 ? CharOperation.NO_CHAR : new char[n2];
        while (true) {
            int n5;
            if (n4 < n2) {
                n3 = n2 - n4;
            } else {
                n5 = inputStreamReader.read();
                if (n5 < 0) break;
                n3 = Math.max(inputStream.available(), 8192);
                if (n4 + 1 + n3 > cArray.length) {
                    char[] cArray2 = cArray;
                    cArray = new char[n4 + 1 + n3];
                    System.arraycopy(cArray2, 0, cArray, 0, n4);
                }
                cArray[n4++] = (char)n5;
            }
            n5 = inputStreamReader.read(cArray, n4, n3);
            if (n5 < 0) break;
            n4 += n5;
        }
        n3 = 0;
        if (n4 > 0 && UTF_8.equals(string) && cArray[0] == '\ufeff') {
            --n4;
            n3 = 1;
        }
        if (n4 < cArray.length) {
            char[] cArray3 = cArray;
            cArray = new char[n4];
            System.arraycopy(cArray3, n3, cArray, 0, n4);
        }
        return cArray;
    }

    public static int getLineNumber(int n2, int[] nArray, int n3, int n4) {
        if (nArray == null) {
            return 1;
        }
        if (n4 == -1) {
            return 1;
        }
        int n5 = n3;
        while (n3 <= n4) {
            n5 = n3 + (n4 - n3) / 2;
            int n6 = nArray[n5];
            if (n2 < n6) {
                n4 = n5 - 1;
                continue;
            }
            if (n2 > n6) {
                n3 = n5 + 1;
                continue;
            }
            return n5 + 1;
        }
        if (n2 < nArray[n5]) {
            return n5 + 1;
        }
        return n5 + 2;
    }

    public static byte[] getZipEntryByteContent(ZipEntry zipEntry, ZipFile zipFile) throws IOException {
        byte[] byArray;
        block8: {
            InputStream inputStream = null;
            try {
                inputStream = zipFile.getInputStream(zipEntry);
                if (inputStream == null) {
                    throw new IOException("Invalid zip entry name : " + zipEntry.getName());
                }
                byArray = Util.getInputStreamAsByteArray(inputStream, (int)zipEntry.getSize());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static final boolean isArchiveFileName(String string) {
        int n2;
        char c2;
        int n3;
        int n4;
        int n5 = string == null ? 0 : string.length();
        if (n5 == (n4 = SUFFIX_ZIP.length)) {
            n3 = 0;
            while (n3 < n4) {
                c2 = string.charAt(n5 - n3 - 1);
                if (c2 != SUFFIX_zip[n2 = n4 - n3 - 1] && c2 != SUFFIX_ZIP[n2]) break;
                ++n3;
            }
        }
        if (n5 < (n4 = SUFFIX_JAR.length)) {
            return false;
        }
        n3 = 0;
        while (n3 < n4) {
            c2 = string.charAt(n5 - n3 - 1);
            if (c2 != SUFFIX_jar[n2 = n4 - n3 - 1] && c2 != SUFFIX_JAR[n2]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static final boolean isClassFileName(char[] cArray) {
        int n2;
        int n3 = cArray == null ? 0 : cArray.length;
        if (n3 < (n2 = SUFFIX_JAVA.length)) {
            return false;
        }
        int n4 = 0;
        int n5 = n3 - n2;
        while (n4 < n2) {
            char c2 = cArray[n5 + n4];
            if (c2 != SUFFIX_java[n4] && c2 != SUFFIX_JAVA[n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static final boolean isClassFileName(String string) {
        int n2;
        int n3 = string == null ? 0 : string.length();
        if (n3 < (n2 = SUFFIX_JAVA.length)) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            char c2 = string.charAt(n3 - n4 - 1);
            if (c2 != SUFFIX_java[n5 = n2 - n4 - 1] && c2 != SUFFIX_JAVA[n5]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static final boolean isExcluded(char[] cArray, char[][] cArray2, char[][] cArray3, boolean bl2) {
        int n2;
        int n3;
        block9: {
            if (cArray2 == null && cArray3 == null) {
                return false;
            }
            if (cArray2 != null) {
                n3 = 0;
                n2 = cArray2.length;
                while (n3 < n2) {
                    int n4;
                    int n5;
                    char[] cArray4;
                    char[] cArray5 = cArray4 = cArray2[n3];
                    if (bl2 && (n5 = CharOperation.lastIndexOf('/', cArray4)) != -1 && n5 != cArray4.length - 1 && ((n4 = CharOperation.indexOf('*', cArray4, n5)) == -1 || n4 >= cArray4.length - 1 || cArray4[n4 + 1] != '*')) {
                        cArray5 = CharOperation.subarray(cArray4, 0, n5);
                    }
                    if (!Util.pathMatch(cArray, cArray5)) {
                        ++n3;
                        continue;
                    }
                    break block9;
                }
                return true;
            }
        }
        if (bl2) {
            cArray = CharOperation.concat(cArray, new char[]{'*'}, '/');
        }
        if (cArray3 != null) {
            n3 = 0;
            n2 = cArray3.length;
            while (n3 < n2) {
                if (Util.pathMatch(cArray, cArray3[n3])) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public static final boolean isJavaFileName(char[] cArray) {
        int n2;
        int n3 = cArray == null ? 0 : cArray.length;
        if (n3 < (n2 = SUFFIX_JAVA.length)) {
            return false;
        }
        int n4 = 0;
        int n5 = n3 - n2;
        while (n4 < n2) {
            char c2 = cArray[n5 + n4];
            if (c2 != SUFFIX_java[n4] && c2 != SUFFIX_JAVA[n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static final boolean isJavaFileName(String string) {
        int n2;
        int n3 = string == null ? 0 : string.length();
        if (n3 < (n2 = SUFFIX_JAVA.length)) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            char c2 = string.charAt(n3 - n4 - 1);
            if (c2 != SUFFIX_java[n5 = n2 - n4 - 1] && c2 != SUFFIX_JAVA[n5]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static final int searchColumnNumber(int[] nArray, int n2, int n3) {
        switch (n2) {
            case 1: {
                return n3 + 1;
            }
            case 2: {
                return n3 - nArray[0];
            }
        }
        int n4 = n2 - 2;
        int n5 = nArray.length;
        if (n4 >= n5) {
            return n3 - nArray[n5 - 1];
        }
        return n3 - nArray[n4];
    }

    public static Boolean toBoolean(boolean bl2) {
        if (bl2) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String toString(Object[] objectArray) {
        return Util.toString(objectArray, new Util$1());
    }

    public static String toString(Object[] objectArray, Util$Displayable util$Displayable) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(util$Displayable.displayString(objectArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final char[] getTypeName(ae ae2) {
        ae ae3 = ae2;
        char[] cArray = null;
        while (ae3 != null) {
            if (ae3 instanceof ai) {
                cArray = cArray == null ? ((ai)ae3).getToken() : CharOperation.concatWith(new char[][]{((ai)ae3).getToken(), cArray}, '.');
                ae3 = ((ai)ae3).getReceiver();
                continue;
            }
            if (ae3 instanceof ce) {
                cArray = cArray == null ? ((ce)ae3).getToken() : CharOperation.concatWith(new char[][]{((ce)ae3).getToken(), cArray}, '.');
                ae3 = null;
                continue;
            }
            if (ae3 instanceof ArrayReference) {
                ArrayReference arrayReference = (ArrayReference)ae3;
                if (arrayReference.position instanceof bj) {
                    cArray = cArray == null ? ((bj)((Object)arrayReference.position)).source() : CharOperation.concatWith(new char[][]{((bj)((Object)arrayReference.position)).source(), cArray}, '.');
                    ae3 = arrayReference.receiver;
                    continue;
                }
                ae3 = null;
                cArray = null;
                continue;
            }
            if (ae3 instanceof cm) {
                ae3 = null;
                cArray = null;
                continue;
            }
            ae3 = null;
            cArray = null;
        }
        return cArray;
    }

    public static boolean pathMatch(char[] cArray, char[] cArray2) {
        Path path = new Path(new String(cArray));
        Path path2 = new Path(new String(cArray2));
        IPath iPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        boolean bl2 = iPath.isPrefixOf((IPath)path);
        boolean bl3 = iPath.isPrefixOf((IPath)path2);
        if (!bl2 && bl3 || bl2 && !bl3) {
            boolean bl4;
            if (!bl2) {
                bl4 = path.hasTrailingSeparator();
                path = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path).getLocation();
                if (bl4) {
                    path = path.addTrailingSeparator();
                }
            }
            if (!bl3) {
                bl4 = path2.hasTrailingSeparator();
                path2 = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path2).getLocation();
                if (bl4) {
                    path2 = path2.addTrailingSeparator();
                }
            }
        }
        path = path.makeAbsolute();
        path2 = path2.makeAbsolute();
        return CharOperation.pathMatch(path2.toPortableString().toCharArray(), path.toPortableString().toCharArray(), true, '/');
    }
}

