/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.util;

public final class SimpleSet
implements Cloneable {
    public Object[] values;
    public int elementSize;
    public int threshold;

    public SimpleSet() {
        this(13);
    }

    public SimpleSet(int n2) {
        if (n2 < 3) {
            n2 = 3;
        }
        this.elementSize = 0;
        this.threshold = n2 + 1;
        this.values = new Object[2 * n2 + 1];
    }

    public Object add(Object object) {
        Object object2;
        int n2 = this.values.length;
        int n3 = (object.hashCode() & Integer.MAX_VALUE) % n2;
        while ((object2 = this.values[n3]) != null) {
            if (object2.equals(object)) {
                this.values[n3] = object;
                return this.values[n3];
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        this.values[n3] = object;
        if (++this.elementSize > this.threshold) {
            this.a();
        }
        return object;
    }

    public Object addIfNotIncluded(Object object) {
        Object object2;
        int n2 = this.values.length;
        int n3 = (object.hashCode() & Integer.MAX_VALUE) % n2;
        while ((object2 = this.values[n3]) != null) {
            if (object2.equals(object)) {
                return null;
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        this.values[n3] = object;
        if (++this.elementSize > this.threshold) {
            this.a();
        }
        return object;
    }

    public void asArray(Object[] objectArray) {
        if (this.elementSize != objectArray.length) {
            throw new IllegalArgumentException();
        }
        int n2 = this.elementSize;
        int n3 = 0;
        int n4 = this.values.length;
        while (n3 < n4 && n2 > 0) {
            if (this.values[n3] != null) {
                objectArray[--n2] = this.values[n3];
            }
            ++n3;
        }
    }

    public void clear() {
        int n2 = this.values.length;
        while (--n2 >= 0) {
            this.values[n2] = null;
        }
        this.elementSize = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleSet simpleSet = (SimpleSet)super.clone();
        simpleSet.elementSize = this.elementSize;
        simpleSet.threshold = this.threshold;
        int n2 = this.values.length;
        simpleSet.values = new Object[n2];
        System.arraycopy(this.values, 0, simpleSet.values, 0, n2);
        return simpleSet;
    }

    public boolean includes(Object object) {
        Object object2;
        int n2 = this.values.length;
        int n3 = (object.hashCode() & Integer.MAX_VALUE) % n2;
        while ((object2 = this.values[n3]) != null) {
            if (object2.equals(object)) {
                return true;
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        return false;
    }

    public Object remove(Object object) {
        Object object2;
        int n2 = this.values.length;
        int n3 = (object.hashCode() & Integer.MAX_VALUE) % n2;
        while ((object2 = this.values[n3]) != null) {
            if (object2.equals(object)) {
                --this.elementSize;
                Object object3 = this.values[n3];
                this.values[n3] = null;
                if (this.values[n3 + 1 == n2 ? 0 : n3 + 1] != null) {
                    this.a();
                }
                return object3;
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        return null;
    }

    private void a() {
        SimpleSet simpleSet = new SimpleSet(this.elementSize * 2);
        int n2 = this.values.length;
        while (--n2 >= 0) {
            Object object = this.values[n2];
            if (object == null) continue;
            simpleSet.add(object);
        }
        this.values = simpleSet.values;
        this.elementSize = simpleSet.elementSize;
        this.threshold = simpleSet.threshold;
    }

    public String toString() {
        String string = "";
        int n2 = 0;
        int n3 = this.values.length;
        while (n2 < n3) {
            Object object = this.values[n2];
            if (object != null) {
                string = String.valueOf(string) + object.toString() + "\n";
            }
            ++n2;
        }
        return string;
    }
}

