/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.parser;

import org.ccdt.jsdt.core.UnimplementedException;
import org.ccdt.jsdt.internal.compiler.ast.ASTNode;
import org.ccdt.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.Assignment;
import org.ccdt.jsdt.internal.compiler.ast.Block;
import org.ccdt.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.FieldDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.FunctionExpression;
import org.ccdt.jsdt.internal.compiler.ast.ImportReference;
import org.ccdt.jsdt.internal.compiler.ast.LocalDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.ProgramElement;
import org.ccdt.jsdt.internal.compiler.ast.Statement;
import org.ccdt.jsdt.internal.compiler.ast.TypeDeclaration;
import org.ccdt.jsdt.internal.compiler.parser.Parser;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredBlock;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredElement;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredField;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredLocalVariable;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredMethod;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredStatement;

public class RecoveredUnit
extends RecoveredElement {
    public CompilationUnitDeclaration unitDeclaration;
    public RecoveredElement[] statements;
    public int statementCount;

    public RecoveredUnit(CompilationUnitDeclaration compilationUnitDeclaration, int n2, Parser parser) {
        super(null, n2, parser);
        this.unitDeclaration = compilationUnitDeclaration;
    }

    @Override
    public RecoveredElement add(AbstractMethodDeclaration abstractMethodDeclaration, int n2) {
        RecoveredMethod recoveredMethod = new RecoveredMethod(abstractMethodDeclaration, this, n2, this.recoveringParser);
        this.a(recoveredMethod);
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (abstractMethodDeclaration.declarationSourceEnd == 0) {
            return recoveredMethod;
        }
        return this;
    }

    @Override
    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n2) {
        RecoveredField recoveredField = new RecoveredField(fieldDeclaration, this, n2);
        this.a(recoveredField);
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (fieldDeclaration.declarationSourceEnd == 0) {
            return recoveredField;
        }
        return this;
    }

    @Override
    public RecoveredElement add(LocalDeclaration localDeclaration, int n2) {
        RecoveredLocalVariable recoveredLocalVariable = new RecoveredLocalVariable(localDeclaration, (RecoveredElement)this, n2);
        this.a(recoveredLocalVariable);
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (localDeclaration.declarationSourceEnd == 0) {
            return recoveredLocalVariable;
        }
        return this;
    }

    @Override
    public RecoveredElement add(ImportReference importReference, int n2) {
        return this;
    }

    @Override
    public RecoveredElement add(TypeDeclaration typeDeclaration, int n2) {
        return this;
    }

    private void a(RecoveredElement recoveredElement) {
        if (this.statements == null) {
            this.statements = new RecoveredElement[5];
            this.statementCount = 0;
        } else if (this.statementCount == this.statements.length) {
            this.statements = new RecoveredElement[2 * this.statementCount];
            System.arraycopy(this.statements, 0, this.statements, 0, this.statementCount);
        }
        this.statements[this.statementCount++] = recoveredElement;
    }

    @Override
    public ASTNode parseTree() {
        return this.unitDeclaration;
    }

    @Override
    public int sourceEnd() {
        return this.unitDeclaration.sourceEnd;
    }

    @Override
    public String toString(int n2) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n2));
        stringBuffer.append("Recovered unit: [\n");
        this.unitDeclaration.print(n2 + 1, stringBuffer);
        stringBuffer.append(this.tabString(n2 + 1));
        stringBuffer.append("]");
        if (this.statements != null) {
            int n3 = 0;
            while (n3 < this.statementCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.statements[n3].toString(n2 + 1));
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    public CompilationUnitDeclaration updatedCompilationUnitDeclaration() {
        int n2;
        int n3 = n2 = this.unitDeclaration.sourceEnd > 0 ? this.unitDeclaration.sourceEnd : this.parser().scanner.eofPosition;
        if (this.statementCount > 0) {
            int n4 = this.unitDeclaration.statements == null ? 0 : this.unitDeclaration.statements.length;
            ProgramElement[] programElementArray = new ProgramElement[n4 + this.statementCount];
            if (n4 > 0) {
                System.arraycopy(this.unitDeclaration.statements, 0, programElementArray, 0, n4);
            }
            ASTNode aSTNode = this.statements[this.statementCount - 1].parseTree();
            if (aSTNode.sourceEnd == 0) {
                aSTNode.sourceEnd = n2;
                if (aSTNode instanceof Assignment) {
                    Assignment assignment = (Assignment)aSTNode;
                    if (assignment.expression instanceof FunctionExpression) {
                        FunctionExpression functionExpression = (FunctionExpression)assignment.expression;
                        functionExpression.sourceEnd = aSTNode.sourceEnd;
                        functionExpression.methodDeclaration.bodyEnd = functionExpression.methodDeclaration.sourceEnd = aSTNode.sourceEnd;
                    }
                }
            }
            if (aSTNode instanceof AbstractMethodDeclaration && ((AbstractMethodDeclaration)aSTNode).bodyEnd <= 0) {
                ((AbstractMethodDeclaration)aSTNode).bodyEnd = this.unitDeclaration.sourceEnd;
            }
            int n5 = n4;
            int n6 = 0;
            while (n6 < this.statementCount) {
                ProgramElement programElement = this.statements[n6].updatedASTNode();
                if (programElement != null && programElement.sourceEnd <= 0) {
                    programElement.sourceEnd = this.unitDeclaration.sourceEnd;
                }
                if (programElement instanceof AbstractMethodDeclaration && ((AbstractMethodDeclaration)programElement).bodyEnd <= 0) {
                    ((AbstractMethodDeclaration)programElement).bodyEnd = this.unitDeclaration.sourceEnd;
                } else if (programElement instanceof AbstractVariableDeclaration && ((AbstractVariableDeclaration)programElement).declarationSourceEnd <= 0) {
                    ((AbstractVariableDeclaration)programElement).declarationSourceEnd = this.unitDeclaration.sourceEnd;
                }
                programElementArray[n5++] = programElement;
                ++n6;
            }
            this.unitDeclaration.statements = programElementArray;
        } else if (this.unitDeclaration.statements == null) {
            this.unitDeclaration.statements = new ProgramElement[0];
        }
        return this.unitDeclaration;
    }

    @Override
    public RecoveredElement add(Block block, int n2) {
        RecoveredBlock recoveredBlock = new RecoveredBlock(block, (RecoveredElement)this, n2);
        if (this.parser().statementRecoveryActivated) {
            this.addBlockStatement(recoveredBlock);
        }
        this.a(recoveredBlock);
        if (block.sourceEnd == 0) {
            return recoveredBlock;
        }
        return this;
    }

    @Override
    public RecoveredElement add(Statement statement, int n2) {
        RecoveredStatement recoveredStatement = new RecoveredStatement(statement, this, n2);
        this.a(recoveredStatement);
        if (statement.sourceEnd == 0) {
            return recoveredStatement;
        }
        return this;
    }

    @Override
    public void updateParseTree() {
        this.updatedCompilationUnitDeclaration();
    }

    @Override
    public void updateSourceEndIfNecessary(int n2, int n3) {
        if (this.unitDeclaration.sourceEnd == 0) {
            this.unitDeclaration.sourceEnd = n3;
        }
    }

    @Override
    public ProgramElement updatedASTNode() {
        throw new UnimplementedException();
    }

    @Override
    public void updateFromParserState() {
        int cfr_ignored_0 = this.parser().astPtr;
    }
}

