/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.parser;

import org.ccdt.jsdt.internal.compiler.ast.ASTNode;
import org.ccdt.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.Block;
import org.ccdt.jsdt.internal.compiler.ast.FieldDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.Initializer;
import org.ccdt.jsdt.internal.compiler.ast.Statement;
import org.ccdt.jsdt.internal.compiler.ast.TypeDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.TypeReference;
import org.ccdt.jsdt.internal.compiler.lookup.TypeIds;
import org.ccdt.jsdt.internal.compiler.parser.Parser;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredElement;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredField;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredInitializer;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredMethod;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredStatement;
import org.ccdt.jsdt.internal.compiler.parser.TerminalTokens;

public class RecoveredType
extends RecoveredStatement
implements TerminalTokens {
    public TypeDeclaration typeDeclaration;
    public RecoveredType[] memberTypes;
    public int memberTypeCount;
    public RecoveredField[] fields;
    public int fieldCount;
    public RecoveredMethod[] methods;
    public int methodCount;
    public boolean preserveContent = false;
    public int bodyEnd;
    public int pendingTypeParametersStart;

    public RecoveredType(TypeDeclaration typeDeclaration, RecoveredElement recoveredElement, int n2) {
        super(typeDeclaration, recoveredElement, n2);
        this.typeDeclaration = typeDeclaration;
        if (typeDeclaration.allocation != null && typeDeclaration.allocation.type == null) {
            this.foundOpeningBrace = true;
        } else {
            boolean bl2 = this.foundOpeningBrace = !this.bodyStartsAtHeaderEnd();
        }
        if (this.foundOpeningBrace) {
            ++this.bracketBalance;
        }
        this.preserveContent = this.parser().methodRecoveryActivated || this.parser().statementRecoveryActivated;
    }

    @Override
    public RecoveredElement add(AbstractMethodDeclaration abstractMethodDeclaration, int n2) {
        if (this.typeDeclaration.declarationSourceEnd != 0 && abstractMethodDeclaration.declarationSourceStart > this.typeDeclaration.declarationSourceEnd) {
            return this.parent.add(abstractMethodDeclaration, n2);
        }
        if (this.methods == null) {
            this.methods = new RecoveredMethod[5];
            this.methodCount = 0;
        } else if (this.methodCount == this.methods.length) {
            this.methods = new RecoveredMethod[2 * this.methodCount];
            System.arraycopy(this.methods, 0, this.methods, 0, this.methodCount);
        }
        RecoveredMethod recoveredMethod = new RecoveredMethod(abstractMethodDeclaration, this, n2, this.recoveringParser);
        this.methods[this.methodCount++] = recoveredMethod;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (abstractMethodDeclaration.declarationSourceEnd == 0) {
            return recoveredMethod;
        }
        return this;
    }

    @Override
    public RecoveredElement add(Block block, int n2) {
        int n3 = 0;
        if (this.parser().recoveredStaticInitializerStart != 0) {
            n3 = 8;
        }
        return this.add(new Initializer(block, n3), n2);
    }

    @Override
    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n2) {
        RecoveredField recoveredField;
        if (this.typeDeclaration.declarationSourceEnd != 0 && fieldDeclaration.declarationSourceStart > this.typeDeclaration.declarationSourceEnd) {
            return this.parent.add(fieldDeclaration, n2);
        }
        if (this.fields == null) {
            this.fields = new RecoveredField[5];
            this.fieldCount = 0;
        } else if (this.fieldCount == this.fields.length) {
            this.fields = new RecoveredField[2 * this.fieldCount];
            System.arraycopy(this.fields, 0, this.fields, 0, this.fieldCount);
        }
        switch (fieldDeclaration.getKind()) {
            case 1: {
                recoveredField = new RecoveredField(fieldDeclaration, this, n2);
                break;
            }
            case 2: {
                recoveredField = new RecoveredInitializer(fieldDeclaration, this, n2);
                break;
            }
            default: {
                return this;
            }
        }
        this.fields[this.fieldCount++] = recoveredField;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (fieldDeclaration.declarationSourceEnd == 0) {
            return recoveredField;
        }
        return this;
    }

    @Override
    public RecoveredElement add(TypeDeclaration typeDeclaration, int n2) {
        if (this.typeDeclaration.declarationSourceEnd != 0 && typeDeclaration.declarationSourceStart > this.typeDeclaration.declarationSourceEnd) {
            return this.parent.add(typeDeclaration, n2);
        }
        if ((typeDeclaration.bits & 0x200) != 0) {
            if (this.methodCount > 0) {
                RecoveredMethod recoveredMethod = this.methods[this.methodCount - 1];
                recoveredMethod.methodDeclaration.bodyEnd = 0;
                recoveredMethod.methodDeclaration.declarationSourceEnd = 0;
                recoveredMethod.bracketBalance = recoveredMethod.bracketBalance + 1;
                return recoveredMethod.add(typeDeclaration, n2);
            }
            return this;
        }
        if (this.memberTypes == null) {
            this.memberTypes = new RecoveredType[5];
            this.memberTypeCount = 0;
        } else if (this.memberTypeCount == this.memberTypes.length) {
            this.memberTypes = new RecoveredType[2 * this.memberTypeCount];
            System.arraycopy(this.memberTypes, 0, this.memberTypes, 0, this.memberTypeCount);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n2);
        this.memberTypes[this.memberTypeCount++] = recoveredType;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (typeDeclaration.declarationSourceEnd == 0) {
            return recoveredType;
        }
        return this;
    }

    public int bodyEnd() {
        if (this.bodyEnd == 0) {
            return this.typeDeclaration.declarationSourceEnd;
        }
        return this.bodyEnd;
    }

    public boolean bodyStartsAtHeaderEnd() {
        if (this.typeDeclaration.superclass == null) {
            return this.typeDeclaration.bodyStart == this.typeDeclaration.sourceEnd + 1;
        }
        return this.typeDeclaration.bodyStart == this.typeDeclaration.superclass.sourceEnd + 1;
    }

    @Override
    public RecoveredType enclosingType() {
        RecoveredElement recoveredElement = this.parent;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredType) {
                return (RecoveredType)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public char[] name() {
        return this.typeDeclaration.name;
    }

    @Override
    public ASTNode parseTree() {
        return this.typeDeclaration;
    }

    @Override
    public int sourceEnd() {
        return this.typeDeclaration.declarationSourceEnd;
    }

    @Override
    public String toString(int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n2));
        stringBuffer.append("Recovered type:\n");
        if ((this.typeDeclaration.bits & 0x200) != 0) {
            stringBuffer.append(this.tabString(n2));
            stringBuffer.append(" ");
        }
        this.typeDeclaration.print(n2 + 1, stringBuffer);
        if (this.memberTypes != null) {
            n3 = 0;
            while (n3 < this.memberTypeCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.memberTypes[n3].toString(n2 + 1));
                ++n3;
            }
        }
        if (this.fields != null) {
            n3 = 0;
            while (n3 < this.fieldCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.fields[n3].toString(n2 + 1));
                ++n3;
            }
        }
        if (this.methods != null) {
            n3 = 0;
            while (n3 < this.methodCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.methods[n3].toString(n2 + 1));
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void updateBodyStart(int n2) {
        this.foundOpeningBrace = true;
        this.typeDeclaration.bodyStart = n2;
    }

    @Override
    public Statement updatedStatement() {
        if ((this.typeDeclaration.bits & 0x200) != 0 && !this.preserveContent) {
            return null;
        }
        TypeDeclaration typeDeclaration = this.updatedTypeDeclaration();
        if ((typeDeclaration.bits & 0x200) != 0) {
            return typeDeclaration.allocation;
        }
        return typeDeclaration;
    }

    public TypeDeclaration updatedTypeDeclaration() {
        int n2;
        AbstractMethodDeclaration[] abstractMethodDeclarationArray;
        int n3;
        Statement[] statementArray;
        int n4;
        int n5 = this.typeDeclaration.bodyStart;
        if (this.memberTypeCount > 0) {
            n4 = this.typeDeclaration.memberTypes == null ? 0 : this.typeDeclaration.memberTypes.length;
            statementArray = new TypeDeclaration[n4 + this.memberTypeCount];
            if (n4 > 0) {
                System.arraycopy(this.typeDeclaration.memberTypes, 0, statementArray, 0, n4);
            }
            if (this.memberTypes[this.memberTypeCount - 1].typeDeclaration.declarationSourceEnd == 0) {
                this.memberTypes[this.memberTypeCount - 1].typeDeclaration.declarationSourceEnd = n3 = this.bodyEnd();
                this.memberTypes[this.memberTypeCount - 1].typeDeclaration.bodyEnd = n3;
            }
            n3 = 0;
            while (n3 < this.memberTypeCount) {
                statementArray[n4 + n3] = this.memberTypes[n3].updatedTypeDeclaration();
                ++n3;
            }
            this.typeDeclaration.memberTypes = statementArray;
            if (((TypeDeclaration)statementArray[statementArray.length - 1]).declarationSourceEnd > n5) {
                n5 = ((TypeDeclaration)statementArray[statementArray.length - 1]).declarationSourceEnd;
            }
        }
        if (this.fieldCount > 0) {
            n4 = this.typeDeclaration.fields == null ? 0 : this.typeDeclaration.fields.length;
            statementArray = new FieldDeclaration[n4 + this.fieldCount];
            if (n4 > 0) {
                System.arraycopy(this.typeDeclaration.fields, 0, statementArray, 0, n4);
            }
            if (this.fields[this.fieldCount - 1].fieldDeclaration.declarationSourceEnd == 0) {
                this.fields[this.fieldCount - 1].fieldDeclaration.declarationSourceEnd = n3 = this.bodyEnd();
                this.fields[this.fieldCount - 1].fieldDeclaration.declarationEnd = n3;
            }
            n3 = 0;
            while (n3 < this.fieldCount) {
                statementArray[n4 + n3] = this.fields[n3].updatedFieldDeclaration();
                ++n3;
            }
            this.typeDeclaration.fields = statementArray;
            if (((FieldDeclaration)statementArray[statementArray.length - 1]).declarationSourceEnd > n5) {
                n5 = ((FieldDeclaration)statementArray[statementArray.length - 1]).declarationSourceEnd;
            }
        }
        n4 = this.typeDeclaration.methods == null ? 0 : this.typeDeclaration.methods.length;
        boolean bl2 = false;
        n3 = 0;
        boolean bl3 = false;
        int n6 = -1;
        if (this.methodCount > 0) {
            AbstractMethodDeclaration abstractMethodDeclaration;
            abstractMethodDeclarationArray = new AbstractMethodDeclaration[n4 + this.methodCount];
            n2 = 0;
            while (n2 < n4) {
                abstractMethodDeclaration = this.typeDeclaration.methods[n2];
                if (abstractMethodDeclaration.isDefaultConstructor()) {
                    n6 = n2;
                }
                if (abstractMethodDeclaration.isAbstract()) {
                    bl3 = true;
                }
                abstractMethodDeclarationArray[n2] = abstractMethodDeclaration;
                ++n2;
            }
            if (this.methods[this.methodCount - 1].methodDeclaration.declarationSourceEnd == 0) {
                this.methods[this.methodCount - 1].methodDeclaration.declarationSourceEnd = n2 = this.bodyEnd();
                this.methods[this.methodCount - 1].methodDeclaration.bodyEnd = n2;
            }
            n2 = 0;
            while (n2 < this.methodCount) {
                abstractMethodDeclaration = this.methods[n2].updatedMethodDeclaration();
                if (abstractMethodDeclaration.isConstructor()) {
                    n3 = 1;
                }
                if (abstractMethodDeclaration.isAbstract()) {
                    bl3 = true;
                }
                abstractMethodDeclarationArray[n4 + n2] = abstractMethodDeclaration;
                ++n2;
            }
            this.typeDeclaration.methods = abstractMethodDeclarationArray;
            if (abstractMethodDeclarationArray[abstractMethodDeclarationArray.length - 1].declarationSourceEnd > n5) {
                n5 = abstractMethodDeclarationArray[abstractMethodDeclarationArray.length - 1].declarationSourceEnd;
            }
            if (bl3) {
                this.typeDeclaration.bits |= 0x800;
            }
            bl2 = this.typeDeclaration.checkConstructors(this.parser());
        } else {
            int n7 = 0;
            while (n7 < n4) {
                if (this.typeDeclaration.methods[n7].isConstructor()) {
                    bl2 = true;
                }
                ++n7;
            }
        }
        if (this.typeDeclaration.needClassInitMethod()) {
            boolean bl4 = false;
            n2 = 0;
            while (n2 < n4) {
                if (this.typeDeclaration.methods[n2].isClinit()) {
                    bl4 = true;
                    break;
                }
                ++n2;
            }
            if (!bl4) {
                this.typeDeclaration.addClinit();
            }
        }
        if (n6 >= 0 && n3 != 0) {
            abstractMethodDeclarationArray = new AbstractMethodDeclaration[this.typeDeclaration.methods.length - 1];
            if (n6 != 0) {
                System.arraycopy(this.typeDeclaration.methods, 0, abstractMethodDeclarationArray, 0, n6);
            }
            if (n6 != this.typeDeclaration.methods.length - 1) {
                System.arraycopy(this.typeDeclaration.methods, n6 + 1, abstractMethodDeclarationArray, n6, this.typeDeclaration.methods.length - n6 - 1);
            }
            this.typeDeclaration.methods = abstractMethodDeclarationArray;
        } else if (!bl2) {
            boolean bl5 = false;
            RecoveredElement recoveredElement = this.parent;
            while (recoveredElement != null) {
                if (recoveredElement instanceof RecoveredField) {
                    bl5 = true;
                    break;
                }
                recoveredElement = recoveredElement.parent;
            }
            this.typeDeclaration.createDefaultConstructor(!this.parser().diet || bl5, true);
        }
        if (this.parent instanceof RecoveredType) {
            this.typeDeclaration.bits |= 0x400;
        } else if (this.parent instanceof RecoveredMethod) {
            this.typeDeclaration.bits |= 0x100;
        }
        if (this.typeDeclaration.declarationSourceEnd == 0) {
            this.typeDeclaration.declarationSourceEnd = n5;
            this.typeDeclaration.bodyEnd = n5;
        }
        return this.typeDeclaration;
    }

    @Override
    public void updateFromParserState() {
        if (this.bodyStartsAtHeaderEnd() && this.typeDeclaration.allocation == null) {
            Parser parser = this.parser();
            if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                boolean bl2;
                int n2 = parser.astLengthStack[parser.astLengthPtr];
                int n3 = parser.astPtr - n2;
                boolean bl3 = bl2 = n3 >= 0;
                if (bl2) {
                    if (!(parser.astStack[n3] instanceof TypeDeclaration)) {
                        bl2 = false;
                    }
                    int n4 = 1;
                    int n5 = n2 + 1;
                    while (n4 < n5) {
                        if (!(parser.astStack[n3 + n4] instanceof TypeReference)) {
                            bl2 = false;
                        }
                        ++n4;
                    }
                }
            }
        }
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int n2, int n3) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(n2, n3);
            this.bodyEnd = n2 - 1;
            return this.parent;
        }
        return this;
    }

    @Override
    public RecoveredElement updateOnOpeningBrace(int n2, int n3) {
        TypeIds typeIds;
        if (this.bracketBalance == 0) {
            typeIds = this.parser();
            switch (typeIds.lastIgnoredToken) {
                case -1: 
                case 5: 
                case 7: 
                case 16: 
                case 97: 
                case 101: {
                    if (typeIds.recoveredStaticInitializerStart == 0) break;
                }
                default: {
                    this.foundOpeningBrace = true;
                    this.bracketBalance = 1;
                }
            }
        }
        if (this.bracketBalance == 1) {
            Initializer initializer;
            typeIds = new Block(0);
            Parser parser = this.parser();
            ((Block)typeIds).sourceStart = parser.scanner.startPosition;
            if (parser.recoveredStaticInitializerStart == 0) {
                initializer = new Initializer((Block)typeIds, 0);
            } else {
                initializer = new Initializer((Block)typeIds, 8);
                initializer.declarationSourceStart = parser.recoveredStaticInitializerStart;
            }
            initializer.bodyStart = parser.scanner.currentPosition;
            return this.add(initializer, 1);
        }
        return super.updateOnOpeningBrace(n2, n3);
    }

    @Override
    public void updateParseTree() {
        this.updatedTypeDeclaration();
    }

    @Override
    public void updateSourceEndIfNecessary(int n2, int n3) {
        if (this.typeDeclaration.declarationSourceEnd == 0) {
            this.bodyEnd = 0;
            this.typeDeclaration.declarationSourceEnd = n3;
            this.typeDeclaration.bodyEnd = n3;
        }
    }
}

