/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.parser;

import org.ccdt.jsdt.internal.compiler.ast.ASTNode;
import org.ccdt.jsdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.ccdt.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.FieldDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.ProgramElement;
import org.ccdt.jsdt.internal.compiler.ast.Statement;
import org.ccdt.jsdt.internal.compiler.ast.TypeDeclaration;
import org.ccdt.jsdt.internal.compiler.parser.Parser;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredElement;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredType;

public class RecoveredField
extends RecoveredElement {
    public FieldDeclaration fieldDeclaration;
    boolean a;
    public RecoveredType[] anonymousTypes;
    public int anonymousTypeCount;

    public RecoveredField(FieldDeclaration fieldDeclaration, RecoveredElement recoveredElement, int n2) {
        this(fieldDeclaration, recoveredElement, n2, null);
    }

    public RecoveredField(FieldDeclaration fieldDeclaration, RecoveredElement recoveredElement, int n2, Parser parser) {
        super(recoveredElement, n2, parser);
        this.fieldDeclaration = fieldDeclaration;
        this.a = fieldDeclaration.initialization != null;
    }

    @Override
    public RecoveredElement add(Statement statement, int n2) {
        if (this.a || !(statement instanceof Expression)) {
            return super.add(statement, n2);
        }
        this.a = true;
        this.fieldDeclaration.initialization = (Expression)statement;
        this.fieldDeclaration.declarationSourceEnd = statement.sourceEnd;
        this.fieldDeclaration.declarationEnd = statement.sourceEnd;
        return this;
    }

    @Override
    public RecoveredElement add(TypeDeclaration typeDeclaration, int n2) {
        if (this.a || (typeDeclaration.bits & 0x200) == 0 || this.fieldDeclaration.declarationSourceEnd != 0 && typeDeclaration.sourceStart > this.fieldDeclaration.declarationSourceEnd) {
            return super.add(typeDeclaration, n2);
        }
        if (this.anonymousTypes == null) {
            this.anonymousTypes = new RecoveredType[5];
            this.anonymousTypeCount = 0;
        } else if (this.anonymousTypeCount == this.anonymousTypes.length) {
            this.anonymousTypes = new RecoveredType[2 * this.anonymousTypeCount];
            System.arraycopy(this.anonymousTypes, 0, this.anonymousTypes, 0, this.anonymousTypeCount);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n2);
        this.anonymousTypes[this.anonymousTypeCount++] = recoveredType;
        return recoveredType;
    }

    @Override
    public ASTNode parseTree() {
        return this.fieldDeclaration;
    }

    @Override
    public int sourceEnd() {
        return this.fieldDeclaration.declarationSourceEnd;
    }

    @Override
    public String toString(int n2) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n2));
        stringBuffer.append("Recovered field:\n");
        this.fieldDeclaration.print(n2 + 1, stringBuffer);
        if (this.anonymousTypes != null) {
            int n3 = 0;
            while (n3 < this.anonymousTypeCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.anonymousTypes[n3].toString(n2 + 1));
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    public FieldDeclaration updatedFieldDeclaration() {
        if (this.anonymousTypes != null && this.fieldDeclaration.initialization == null) {
            int n2 = 0;
            while (n2 < this.anonymousTypeCount) {
                RecoveredType recoveredType = this.anonymousTypes[n2];
                TypeDeclaration typeDeclaration = recoveredType.typeDeclaration;
                if (typeDeclaration.declarationSourceEnd == 0) {
                    typeDeclaration.declarationSourceEnd = this.fieldDeclaration.declarationSourceEnd;
                    typeDeclaration.bodyEnd = this.fieldDeclaration.declarationSourceEnd;
                }
                if (recoveredType.preserveContent) {
                    TypeDeclaration typeDeclaration2 = recoveredType.updatedTypeDeclaration();
                    this.fieldDeclaration.initialization = typeDeclaration2.allocation;
                    if (this.fieldDeclaration.declarationSourceEnd == 0) {
                        int n3;
                        this.fieldDeclaration.declarationSourceEnd = n3 = typeDeclaration2.declarationSourceEnd;
                        this.fieldDeclaration.declarationEnd = n3;
                    }
                }
                ++n2;
            }
            if (this.anonymousTypeCount > 0) {
                this.fieldDeclaration.bits |= 2;
            }
        }
        return this.fieldDeclaration;
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int n2, int n3) {
        if (this.bracketBalance > 0) {
            --this.bracketBalance;
            if (this.bracketBalance == 0) {
                this.a = true;
            }
            return this;
        }
        if (this.bracketBalance == 0) {
            this.a = true;
            this.updateSourceEndIfNecessary(n3 - 1);
        }
        if (this.parent != null) {
            return this.parent.updateOnClosingBrace(n2, n3);
        }
        return this;
    }

    @Override
    public RecoveredElement updateOnOpeningBrace(int n2, int n3) {
        if (this.fieldDeclaration.declarationSourceEnd == 0 && (this.fieldDeclaration.type instanceof ArrayTypeReference || this.fieldDeclaration.type instanceof ArrayQualifiedTypeReference) && !this.a) {
            ++this.bracketBalance;
            return null;
        }
        this.updateSourceEndIfNecessary(n2 - 1, n3 - 1);
        return this.parent.updateOnOpeningBrace(n2, n3);
    }

    @Override
    public void updateParseTree() {
        this.updatedFieldDeclaration();
    }

    @Override
    public void updateSourceEndIfNecessary(int n2, int n3) {
        if (this.fieldDeclaration.declarationSourceEnd == 0) {
            this.fieldDeclaration.declarationSourceEnd = n3;
            this.fieldDeclaration.declarationEnd = n3;
        }
    }

    @Override
    public ProgramElement updatedASTNode() {
        return this.updatedFieldDeclaration();
    }
}

