/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.parser;

import org.ccdt.jsdt.internal.compiler.ast.ASTNode;
import org.ccdt.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.Block;
import org.ccdt.jsdt.internal.compiler.ast.FieldDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.ImportReference;
import org.ccdt.jsdt.internal.compiler.ast.LocalDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.ProgramElement;
import org.ccdt.jsdt.internal.compiler.ast.Statement;
import org.ccdt.jsdt.internal.compiler.ast.TypeDeclaration;
import org.ccdt.jsdt.internal.compiler.parser.Parser;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredBlock;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredInitializer;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredMethod;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredType;
import org.ccdt.jsdt.internal.compiler.parser.Scanner;
import org.ccdt.jsdt.internal.compiler.util.Util;

public abstract class RecoveredElement {
    public RecoveredElement parent;
    public int bracketBalance;
    public boolean foundOpeningBrace;
    protected Parser recoveringParser;

    public RecoveredElement(RecoveredElement recoveredElement, int n2) {
        this(recoveredElement, n2, null);
    }

    public RecoveredElement(RecoveredElement recoveredElement, int n2, Parser parser) {
        this.parent = recoveredElement;
        this.bracketBalance = n2;
        this.recoveringParser = parser;
    }

    public abstract ProgramElement updatedASTNode();

    public RecoveredElement add(AbstractMethodDeclaration abstractMethodDeclaration, int n2) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(abstractMethodDeclaration.declarationSourceStart - 1));
        return this.parent.add(abstractMethodDeclaration, n2);
    }

    public RecoveredElement add(Block block, int n2) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(block.sourceStart - 1));
        return this.parent.add(block, n2);
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n2) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
        return this.parent.add(fieldDeclaration, n2);
    }

    public RecoveredElement add(ImportReference importReference, int n2) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(importReference.declarationSourceStart - 1));
        return this.parent.add(importReference, n2);
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int n2) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(localDeclaration.declarationSourceStart - 1));
        return this.parent.add(localDeclaration, n2);
    }

    public RecoveredElement add(Statement statement, int n2) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(statement.sourceStart - 1));
        return this.parent.add(statement, n2);
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n2) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(typeDeclaration.declarationSourceStart - 1));
        return this.parent.add(typeDeclaration, n2);
    }

    protected void addBlockStatement(RecoveredBlock recoveredBlock) {
        Block block = recoveredBlock.blockDeclaration;
        if (block.statements != null) {
            Statement[] statementArray = block.statements;
            int n2 = 0;
            while (n2 < statementArray.length) {
                recoveredBlock.add(statementArray[n2], 0);
                ++n2;
            }
        }
    }

    public int depth() {
        int n2 = 0;
        RecoveredElement recoveredElement = this;
        while ((recoveredElement = recoveredElement.parent) != null) {
            ++n2;
        }
        return n2;
    }

    public RecoveredInitializer enclosingInitializer() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredInitializer) {
                return (RecoveredInitializer)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public RecoveredMethod enclosingMethod() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredMethod) {
                return (RecoveredMethod)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public RecoveredType enclosingType() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredType) {
                return (RecoveredType)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public Parser parser() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement.recoveringParser != null) {
                return recoveredElement.recoveringParser;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public ASTNode parseTree() {
        return null;
    }

    public void preserveEnclosingBlocks() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredBlock) {
                ((RecoveredBlock)recoveredElement).preserveContent = true;
            }
            if (recoveredElement instanceof RecoveredType) {
                ((RecoveredType)recoveredElement).preserveContent = true;
            }
            recoveredElement = recoveredElement.parent;
        }
    }

    public int previousAvailableLineEnd(int n2) {
        Parser parser = this.parser();
        if (parser == null) {
            return n2;
        }
        Scanner scanner = parser.scanner;
        if (scanner.lineEnds == null) {
            return n2;
        }
        int n3 = Util.getLineNumber(n2, scanner.lineEnds, 0, scanner.linePtr);
        if (n3 < 2) {
            return n2;
        }
        int n4 = scanner.lineEnds[n3 - 2];
        char[] cArray = scanner.source;
        int n5 = n4 + 1;
        while (n5 < n2) {
            if (cArray[n5] != ' ' && cArray[n5] != '\t') {
                return n2;
            }
            ++n5;
        }
        return n4;
    }

    public int sourceEnd() {
        return 0;
    }

    protected String tabString(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2;
        while (n3 > 0) {
            stringBuffer.append("  ");
            --n3;
        }
        return stringBuffer.toString();
    }

    public RecoveredElement topElement() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement.parent != null) {
            recoveredElement = recoveredElement.parent;
        }
        return recoveredElement;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n2) {
        return super.toString();
    }

    public RecoveredType type() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredType) {
                return (RecoveredType)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public void updateBodyStart(int n2) {
        this.foundOpeningBrace = true;
    }

    public void updateFromParserState() {
    }

    public RecoveredElement updateOnClosingBrace(int n2, int n3) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(n2, n3);
            return this.parent;
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int n2, int n3) {
        if (this.bracketBalance++ == 0) {
            this.updateBodyStart(n3 + 1);
            return this;
        }
        return null;
    }

    public void updateParseTree() {
    }

    public void updateSourceEndIfNecessary(int n2, int n3) {
    }

    public void updateSourceEndIfNecessary(int n2) {
        this.updateSourceEndIfNecessary(n2 + 1, n2);
    }
}

