/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.parser;

import org.ccdt.jsdt.core.UnimplementedException;
import org.ccdt.jsdt.internal.compiler.ast.ASTNode;
import org.ccdt.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.Argument;
import org.ccdt.jsdt.internal.compiler.ast.Block;
import org.ccdt.jsdt.internal.compiler.ast.FieldDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.LocalDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.ProgramElement;
import org.ccdt.jsdt.internal.compiler.ast.Statement;
import org.ccdt.jsdt.internal.compiler.ast.TypeDeclaration;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredElement;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredInitializer;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredLocalVariable;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredMethod;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredStatement;
import org.ccdt.jsdt.internal.compiler.parser.RecoveredType;
import org.ccdt.jsdt.internal.compiler.parser.TerminalTokens;

public class RecoveredBlock
extends RecoveredStatement
implements TerminalTokens {
    public Block blockDeclaration;
    public RecoveredStatement[] statements;
    public int statementCount;
    public boolean preserveContent = false;
    public RecoveredLocalVariable pendingArgument;

    public RecoveredBlock(Block block, RecoveredElement recoveredElement, int n2) {
        super(block, recoveredElement, n2);
        this.blockDeclaration = block;
        this.foundOpeningBrace = true;
        this.preserveContent = this.parser().methodRecoveryActivated || this.parser().statementRecoveryActivated;
    }

    @Override
    public RecoveredElement add(AbstractMethodDeclaration abstractMethodDeclaration, int n2) {
        if (this.parent != null && this.parent instanceof RecoveredMethod) {
            RecoveredMethod recoveredMethod = (RecoveredMethod)this.parent;
            if (recoveredMethod.methodBody == this && recoveredMethod.parent == null) {
                return this;
            }
        }
        return super.add(abstractMethodDeclaration, n2);
    }

    @Override
    public RecoveredElement add(Block block, int n2) {
        if (this.blockDeclaration.sourceEnd != 0 && block.sourceStart > this.blockDeclaration.sourceEnd) {
            return this.parent.add(block, n2);
        }
        RecoveredBlock recoveredBlock = new RecoveredBlock(block, (RecoveredElement)this, n2);
        if (this.pendingArgument != null) {
            recoveredBlock.a(this.pendingArgument);
            this.pendingArgument = null;
        }
        if (this.parser().statementRecoveryActivated) {
            this.addBlockStatement(recoveredBlock);
        }
        this.a(recoveredBlock);
        if (block.sourceEnd == 0) {
            return recoveredBlock;
        }
        return this;
    }

    @Override
    public RecoveredElement add(LocalDeclaration localDeclaration, int n2) {
        return this.add(localDeclaration, n2, false);
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int n2, boolean bl2) {
        if (this.blockDeclaration.sourceEnd != 0 && localDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            if (bl2) {
                return this;
            }
            return this.parent.add(localDeclaration, n2);
        }
        RecoveredLocalVariable recoveredLocalVariable = new RecoveredLocalVariable(localDeclaration, (RecoveredElement)this, n2);
        if (localDeclaration instanceof Argument) {
            this.pendingArgument = recoveredLocalVariable;
            return this;
        }
        this.a(recoveredLocalVariable);
        if (localDeclaration.declarationSourceEnd == 0) {
            return recoveredLocalVariable;
        }
        return this;
    }

    @Override
    public RecoveredElement add(Statement statement, int n2) {
        return this.add(statement, n2, false);
    }

    public RecoveredElement add(Statement statement, int n2, boolean bl2) {
        if (this.blockDeclaration.sourceEnd != 0 && statement.sourceStart > this.blockDeclaration.sourceEnd) {
            if (bl2) {
                return this;
            }
            return this.parent.add(statement, n2);
        }
        RecoveredStatement recoveredStatement = new RecoveredStatement(statement, this, n2);
        this.a(recoveredStatement);
        if (statement.sourceEnd == 0) {
            return recoveredStatement;
        }
        return this;
    }

    @Override
    public RecoveredElement add(TypeDeclaration typeDeclaration, int n2) {
        return this.add(typeDeclaration, n2, false);
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n2, boolean bl2) {
        if (this.blockDeclaration.sourceEnd != 0 && typeDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            if (bl2) {
                return this;
            }
            return this.parent.add(typeDeclaration, n2);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n2);
        this.a(recoveredType);
        if (typeDeclaration.declarationSourceEnd == 0) {
            return recoveredType;
        }
        return this;
    }

    void a(RecoveredStatement recoveredStatement) {
        if (this.statements == null) {
            this.statements = new RecoveredStatement[5];
            this.statementCount = 0;
        } else if (this.statementCount == this.statements.length) {
            this.statements = new RecoveredStatement[2 * this.statementCount];
            System.arraycopy(this.statements, 0, this.statements, 0, this.statementCount);
        }
        this.statements[this.statementCount++] = recoveredStatement;
    }

    @Override
    public ASTNode parseTree() {
        return this.blockDeclaration;
    }

    @Override
    public String toString(int n2) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n2));
        stringBuffer.append("Recovered block:\n");
        this.blockDeclaration.print(n2 + 1, stringBuffer);
        if (this.statements != null) {
            int n3 = 0;
            while (n3 < this.statementCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.statements[n3].toString(n2 + 1));
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    public Block updatedBlock() {
        RecoveredStatement recoveredStatement;
        if (!this.preserveContent || this.statementCount == 0) {
            return null;
        }
        Statement[] statementArray = new Statement[this.statementCount];
        int n2 = 0;
        RecoveredStatement recoveredStatement2 = this.statements[this.statementCount - 1];
        RecoveredMethod recoveredMethod = this.enclosingMethod();
        RecoveredInitializer recoveredInitializer = this.enclosingInitializer();
        int n3 = 0;
        if (recoveredMethod != null) {
            n3 = recoveredMethod.methodDeclaration.bodyEnd;
            if (recoveredInitializer != null && recoveredMethod.methodDeclaration.sourceStart < recoveredInitializer.fieldDeclaration.sourceStart) {
                n3 = recoveredInitializer.fieldDeclaration.declarationSourceEnd;
            }
        } else {
            n3 = recoveredInitializer != null ? recoveredInitializer.fieldDeclaration.declarationSourceEnd : this.blockDeclaration.sourceEnd - 1;
        }
        if (recoveredStatement2 instanceof RecoveredLocalVariable) {
            recoveredStatement = (RecoveredLocalVariable)recoveredStatement2;
            if (recoveredStatement.localDeclaration.declarationSourceEnd == 0) {
                recoveredStatement.localDeclaration.declarationSourceEnd = n3;
                recoveredStatement.localDeclaration.declarationEnd = n3;
            }
        } else if (recoveredStatement2 instanceof RecoveredBlock) {
            recoveredStatement = (RecoveredBlock)recoveredStatement2;
            if (((RecoveredBlock)recoveredStatement).blockDeclaration.sourceEnd == 0) {
                ((RecoveredBlock)recoveredStatement).blockDeclaration.sourceEnd = n3;
            }
        } else if (!(recoveredStatement2 instanceof RecoveredType) && recoveredStatement2.statement.sourceEnd == 0) {
            recoveredStatement2.statement.sourceEnd = n3;
        }
        int n4 = this.blockDeclaration.sourceStart;
        int n5 = 0;
        while (n5 < this.statementCount) {
            Statement statement = this.statements[n5].updatedStatement();
            if (statement != null) {
                Statement statement2;
                statementArray[n2++] = statement;
                if (statement instanceof LocalDeclaration) {
                    statement2 = (LocalDeclaration)statement;
                    if (statement2.declarationSourceEnd > n4) {
                        n4 = statement2.declarationSourceEnd;
                    }
                } else if (statement instanceof TypeDeclaration) {
                    statement2 = (TypeDeclaration)statement;
                    if (((TypeDeclaration)statement2).declarationSourceEnd > n4) {
                        n4 = ((TypeDeclaration)statement2).declarationSourceEnd;
                    }
                } else if (statement.sourceEnd > n4) {
                    n4 = statement.sourceEnd;
                }
            }
            ++n5;
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 != this.statementCount) {
            this.blockDeclaration.statements = new Statement[n2];
            System.arraycopy(statementArray, 0, this.blockDeclaration.statements, 0, n2);
        } else {
            this.blockDeclaration.statements = statementArray;
        }
        if (this.blockDeclaration.sourceEnd == 0) {
            this.blockDeclaration.sourceEnd = n4 < n3 ? n3 : n4;
        }
        return this.blockDeclaration;
    }

    @Override
    public Statement updatedStatement() {
        return this.updatedBlock();
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int n2, int n3) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(n2, n3);
            RecoveredMethod recoveredMethod = this.enclosingMethod();
            if (recoveredMethod != null && recoveredMethod.methodBody == this) {
                return this.parent.updateOnClosingBrace(n2, n3);
            }
            RecoveredInitializer recoveredInitializer = this.enclosingInitializer();
            if (recoveredInitializer != null && recoveredInitializer.initializerBody == this) {
                return this.parent.updateOnClosingBrace(n2, n3);
            }
            return this.parent;
        }
        return this;
    }

    @Override
    public RecoveredElement updateOnOpeningBrace(int n2, int n3) {
        Block block = new Block(0);
        block.sourceStart = this.parser().scanner.startPosition;
        return this.add(block, 1);
    }

    @Override
    public void updateParseTree() {
        this.updatedBlock();
    }

    public Statement updateStatement() {
        if (this.blockDeclaration.sourceEnd != 0 || this.statementCount == 0) {
            return null;
        }
        Statement[] statementArray = new Statement[this.statementCount];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.statementCount) {
            Statement statement = this.statements[n3].updatedStatement();
            if (statement != null) {
                statementArray[n2++] = statement;
            }
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 != this.statementCount) {
            this.blockDeclaration.statements = new Statement[n2];
            System.arraycopy(statementArray, 0, this.blockDeclaration.statements, 0, n2);
        } else {
            this.blockDeclaration.statements = statementArray;
        }
        return this.blockDeclaration;
    }

    @Override
    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n2) {
        return this.add(fieldDeclaration, n2, false);
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n2, boolean bl2) {
        throw new UnimplementedException("SHOULD NOT BE CALLED");
    }

    @Override
    public ProgramElement updatedASTNode() {
        return this.updateStatement();
    }
}

