/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.lookup;

import org.ccdt.jsdt.core.compiler.CharOperation;
import org.ccdt.jsdt.internal.compiler.lookup.ArrayBinding;
import org.ccdt.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.ccdt.jsdt.internal.compiler.lookup.Binding;
import org.ccdt.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.ccdt.jsdt.internal.compiler.lookup.PackageBinding;
import org.ccdt.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.ccdt.jsdt.internal.compiler.lookup.Scope;
import org.ccdt.jsdt.internal.compiler.lookup.TypeConstants;
import org.ccdt.jsdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public abstract class TypeBinding
extends Binding {
    public int id = Integer.MAX_VALUE;
    public long tagBits = 0L;
    public static final BaseTypeBinding INT = new BaseTypeBinding(10, TypeConstants.INT, new char[]{'I'});
    public static final BaseTypeBinding SHORT = new BaseTypeBinding(4, TypeConstants.SHORT, new char[]{'S'});
    public static final BaseTypeBinding CHAR = new BaseTypeBinding(2, TypeConstants.CHAR, new char[]{'C'});
    public static final BaseTypeBinding LONG = new BaseTypeBinding(7, TypeConstants.LONG, new char[]{'J'});
    public static final BaseTypeBinding FLOAT = new BaseTypeBinding(9, TypeConstants.FLOAT, new char[]{'F'});
    public static final BaseTypeBinding DOUBLE = new BaseTypeBinding(8, TypeConstants.DOUBLE, new char[]{'D'});
    public static final BaseTypeBinding BOOLEAN = new BaseTypeBinding(5, TypeConstants.BOOLEAN, new char[]{'Z'});
    public static final BaseTypeBinding NULL = new BaseTypeBinding(12, TypeConstants.NULL, new char[]{'N'});
    public static final BaseTypeBinding VOID = new BaseTypeBinding(6, TypeConstants.VOID, new char[]{'V'});
    public static final BaseTypeBinding UNDEFINED = new BaseTypeBinding(0, TypeConstants.UNDEFINED, new char[]{'U'});
    public static final BaseTypeBinding ANY = new BaseTypeBinding(13, TypeConstants.ANY, new char[]{'A'});
    public static final BaseTypeBinding UNKNOWN = new BaseTypeBinding(13, TypeConstants.ANY, new char[]{'A'});

    public static final TypeBinding wellKnownType(Scope scope, int n2) {
        switch (n2) {
            case 5: {
                return BOOLEAN;
            }
            case 2: {
                return CHAR;
            }
            case 4: {
                return SHORT;
            }
            case 8: {
                return DOUBLE;
            }
            case 9: {
                return FLOAT;
            }
            case 10: {
                return INT;
            }
            case 7: {
                return LONG;
            }
            case 1: {
                return scope.getJavaLangObject();
            }
            case 11: {
                return scope.getJavaLangString();
            }
        }
        return null;
    }

    public boolean canBeInstantiated() {
        return !this.isBaseType();
    }

    public abstract char[] constantPoolName();

    public String debugName() {
        return new String(this.readableName());
    }

    public int dimensions() {
        return 0;
    }

    public ReferenceBinding enclosingType() {
        return null;
    }

    public ReferenceBinding findSuperTypeErasingTo(int n2, boolean bl2) {
        if (!(this instanceof ReferenceBinding)) {
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this;
        if (referenceBinding.id == n2 || this.id == n2) {
            return referenceBinding;
        }
        ReferenceBinding referenceBinding2 = referenceBinding;
        if (bl2) {
            while ((referenceBinding2 = referenceBinding2.getSuperBinding()) != null) {
                if (referenceBinding2.id != n2 && referenceBinding2.id != n2) continue;
                return referenceBinding2;
            }
            return null;
        }
        return null;
    }

    public TypeBinding findSuperTypeWithSameErasure(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return this;
        }
        if (typeBinding == null) {
            return null;
        }
        switch (this.kind()) {
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)this;
                int n2 = typeBinding.dimensions();
                if (arrayBinding.dimensions != n2) {
                    switch (typeBinding.id) {
                        case 1: {
                            return typeBinding;
                        }
                    }
                    if (n2 < arrayBinding.dimensions && typeBinding.leafComponentType().id == 1) {
                        return typeBinding;
                    }
                    return null;
                }
                if (!(arrayBinding.leafComponentType instanceof ReferenceBinding)) {
                    return null;
                }
                TypeBinding typeBinding2 = arrayBinding.leafComponentType.findSuperTypeWithSameErasure(typeBinding.leafComponentType());
                if (typeBinding2 == null) {
                    return null;
                }
                return arrayBinding.environment().createArrayType(typeBinding2, arrayBinding.dimensions);
            }
            case 4: {
                if (this == typeBinding || this == typeBinding) {
                    return this;
                }
                ReferenceBinding referenceBinding = (ReferenceBinding)this;
                ReferenceBinding referenceBinding2 = null;
                while ((referenceBinding = referenceBinding.getSuperBinding()) != null && referenceBinding != referenceBinding2) {
                    if (referenceBinding == typeBinding || referenceBinding == typeBinding) {
                        return referenceBinding;
                    }
                    if (referenceBinding2 != null) continue;
                    referenceBinding2 = referenceBinding;
                }
                return null;
            }
        }
        return null;
    }

    public TypeBinding genericCast(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return null;
        }
        return typeBinding;
    }

    public abstract PackageBinding getPackage();

    public final boolean isAnonymousType() {
        return (this.tagBits & 0x20L) != 0L;
    }

    public final boolean isObjectLiteralType() {
        return (this.tagBits & 0x100000000000000L) != 0L;
    }

    public final boolean isArrayType() {
        return (this.tagBits & 1L) != 0L;
    }

    public final boolean isBaseType() {
        return (this.tagBits & 2L) != 0L;
    }

    public boolean isBasicType() {
        if ((this.tagBits & 2L) != 0L) {
            return true;
        }
        return this.id <= 14;
    }

    public boolean isClass() {
        return false;
    }

    public abstract boolean isCompatibleWith(TypeBinding var1);

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        return false;
    }

    public final boolean isHierarchyInconsistent() {
        return (this.tagBits & 0x20000L) != 0L;
    }

    public boolean isIntersectingWith(TypeBinding typeBinding) {
        return this == typeBinding;
    }

    public final boolean isLocalType() {
        return (this.tagBits & 0x10L) != 0L;
    }

    public final boolean isMemberType() {
        return (this.tagBits & 8L) != 0L;
    }

    public final boolean isNestedType() {
        return (this.tagBits & 4L) != 0L;
    }

    public final boolean isAnyType() {
        return this.id == 13;
    }

    public final boolean isNumericType() {
        switch (this.id) {
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isProvablyDistinctFrom(TypeBinding typeBinding, int n2) {
        if (this == typeBinding) {
            return false;
        }
        if (n2 > 1) {
            return true;
        }
        return this != typeBinding;
    }

    public boolean isReifiable() {
        TypeBinding typeBinding = this.leafComponentType();
        if (!(typeBinding instanceof ReferenceBinding)) {
            return true;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        do {
            if (referenceBinding.isStatic()) {
                return true;
            }
            if (!referenceBinding.isLocalType()) continue;
            return true;
        } while ((referenceBinding = referenceBinding.enclosingType()) != null);
        return true;
    }

    public boolean isThrowable() {
        return false;
    }

    public boolean isTypeArgumentContainedBy(TypeBinding typeBinding) {
        return this == typeBinding;
    }

    public boolean isUncheckedException(boolean bl2) {
        return false;
    }

    @Override
    public int kind() {
        return 4;
    }

    public TypeBinding leafComponentType() {
        return this;
    }

    public boolean needsUncheckedConversion(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return false;
        }
        if (!((typeBinding = typeBinding.leafComponentType()) instanceof ReferenceBinding)) {
            return false;
        }
        TypeBinding typeBinding2 = this.leafComponentType();
        TypeBinding typeBinding3 = typeBinding2.findSuperTypeWithSameErasure(typeBinding);
        if (!(typeBinding3 instanceof ReferenceBinding)) {
            return false;
        }
        return false;
    }

    public char[] qualifiedPackageName() {
        PackageBinding packageBinding = this.getPackage();
        return packageBinding == null || packageBinding.compoundName == CharOperation.NO_CHAR_CHAR ? CharOperation.NO_CHAR : packageBinding.readableName();
    }

    public abstract char[] qualifiedSourceName();

    public char[] signature() {
        return this.constantPoolName();
    }

    public abstract char[] sourceName();

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
    }

    public boolean isFunctionType() {
        return false;
    }

    public char[] getFileName() {
        return new char[0];
    }

    public TypeBinding reconcileAnonymous(TypeBinding typeBinding) {
        return null;
    }
}

