/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.lookup;

import org.ccdt.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.ccdt.jsdt.internal.compiler.lookup.ArrayBinding;
import org.ccdt.jsdt.internal.compiler.lookup.Binding;
import org.ccdt.jsdt.internal.compiler.lookup.FunctionTypeBinding;
import org.ccdt.jsdt.internal.compiler.lookup.InvocationSite;
import org.ccdt.jsdt.internal.compiler.lookup.PackageBinding;
import org.ccdt.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.ccdt.jsdt.internal.compiler.lookup.Scope;
import org.ccdt.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;
import org.ccdt.jsdt.internal.compiler.lookup.TypeConstants;
import org.ccdt.jsdt.internal.oaametadata.Method;

public class MethodBinding
extends Binding {
    public int modifiers;
    public char[] selector;
    public TypeBinding returnType;
    public TypeBinding[] parameters;
    public ReferenceBinding declaringClass;
    char[] b;
    public long tagBits;
    public FunctionTypeBinding functionTypeBinding;
    public ReferenceBinding allocationType;
    public Method oaaMethod;
    private MethodBinding a;

    protected MethodBinding() {
    }

    public MethodBinding(int n2, char[] cArray, TypeBinding typeBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding) {
        this.modifiers = n2;
        this.selector = cArray;
        this.returnType = typeBinding;
        this.setParameters(typeBindingArray == null || typeBindingArray.length == 0 ? Binding.NO_PARAMETERS : typeBindingArray);
        this.declaringClass = referenceBinding;
        if (this.declaringClass != null && this.declaringClass.isStrictfp() && !this.isAbstract()) {
            this.modifiers |= 0x800;
        }
    }

    public MethodBinding(int n2, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding) {
        this(n2, TypeConstants.INIT, TypeBinding.UNKNOWN, typeBindingArray, referenceBinding);
    }

    public MethodBinding(MethodBinding methodBinding, ReferenceBinding referenceBinding) {
        this.modifiers = methodBinding.modifiers;
        this.selector = methodBinding.selector;
        this.returnType = methodBinding.returnType;
        this.parameters = methodBinding.parameters;
        this.declaringClass = referenceBinding;
        this.a = methodBinding;
    }

    public final boolean areParametersEqual(MethodBinding methodBinding) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        if (this.parameters == typeBindingArray) {
            return true;
        }
        int n2 = this.parameters.length;
        if (n2 != typeBindingArray.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.parameters[n3] != typeBindingArray[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public final boolean areParametersCompatibleWith(TypeBinding[] typeBindingArray) {
        int n2;
        int n3 = this.parameters.length;
        int n4 = n2 = typeBindingArray.length;
        if (this.isVarargs()) {
            TypeBinding typeBinding;
            n4 = n3 - 1;
            if (n3 == n2) {
                typeBinding = this.parameters[n4];
                TypeBinding typeBinding2 = typeBindingArray[n4];
                if (typeBinding != typeBinding2 && !typeBinding2.isCompatibleWith(typeBinding)) {
                    return false;
                }
            } else if (n3 < n2) {
                typeBinding = ((ArrayBinding)this.parameters[n4]).elementsType();
                int n5 = n4;
                while (n5 < n2) {
                    if (typeBinding != typeBindingArray[n5] && !typeBindingArray[n5].isCompatibleWith(typeBinding)) {
                        return false;
                    }
                    ++n5;
                }
            } else if (n4 != n2) {
                return false;
            }
        }
        int n6 = 0;
        while (n6 < n4) {
            if (this.parameters[n6] != typeBindingArray[n6] && !typeBindingArray[n6].isCompatibleWith(this.parameters[n6])) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    @Override
    public final int kind() {
        return 8;
    }

    public final boolean canBeSeenBy(PackageBinding packageBinding) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return packageBinding == this.declaringClass.getPackage();
    }

    public final boolean canBeSeenBy(InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this.declaringClass) {
            return true;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            return invocationSite.isSuperAccess();
        }
        if (this.isPrivate()) {
            ReferenceBinding referenceBinding = sourceTypeBinding;
            ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
            while (referenceBinding2 != null) {
                referenceBinding = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            ReferenceBinding referenceBinding3 = this.declaringClass;
            referenceBinding2 = referenceBinding3.enclosingType();
            while (referenceBinding2 != null) {
                referenceBinding3 = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            return referenceBinding == referenceBinding3;
        }
        return sourceTypeBinding.fPackage == this.declaringClass.fPackage;
    }

    public final boolean canBeSeenBy(TypeBinding typeBinding, InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this.declaringClass && sourceTypeBinding == typeBinding) {
            return true;
        }
        if (sourceTypeBinding == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.declaringClass.fPackage;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding == this.declaringClass) {
                return true;
            }
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding referenceBinding = sourceTypeBinding;
            TypeBinding typeBinding2 = typeBinding;
            ReferenceBinding referenceBinding2 = this.declaringClass;
            int n2 = 0;
            do {
                if (referenceBinding.findSuperTypeWithSameErasure(referenceBinding2) != null) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (typeBinding instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (n2 > 0) {
                            invocationSite.setDepth(n2);
                        }
                        return true;
                    }
                    if (referenceBinding == typeBinding2 || typeBinding2.findSuperTypeWithSameErasure(referenceBinding) != null) {
                        if (n2 > 0) {
                            invocationSite.setDepth(n2);
                        }
                        return true;
                    }
                }
                ++n2;
            } while ((referenceBinding = referenceBinding.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (typeBinding != this.declaringClass) {
                return false;
            }
            if (sourceTypeBinding != this.declaringClass) {
                ReferenceBinding referenceBinding = sourceTypeBinding;
                ReferenceBinding referenceBinding3 = referenceBinding.enclosingType();
                while (referenceBinding3 != null) {
                    referenceBinding = referenceBinding3;
                    referenceBinding3 = referenceBinding3.enclosingType();
                }
                ReferenceBinding referenceBinding4 = this.declaringClass;
                referenceBinding3 = referenceBinding4.enclosingType();
                while (referenceBinding3 != null) {
                    referenceBinding4 = referenceBinding3;
                    referenceBinding3 = referenceBinding3.enclosingType();
                }
                if (referenceBinding != referenceBinding4) {
                    return false;
                }
            }
            return true;
        }
        PackageBinding packageBinding = null;
        if (this.declaringClass != null && sourceTypeBinding.fPackage != (packageBinding = this.declaringClass.fPackage)) {
            return false;
        }
        if (typeBinding instanceof ArrayBinding) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        do {
            if (this.declaringClass == referenceBinding) {
                return true;
            }
            if (referenceBinding == null) {
                return true;
            }
            PackageBinding packageBinding2 = referenceBinding.fPackage;
            if (packageBinding2 == null || packageBinding2 == packageBinding) continue;
            return false;
        } while ((referenceBinding = referenceBinding.getSuperBinding()) != null);
        return false;
    }

    @Override
    public char[] computeUniqueKey(boolean bl2) {
        char[] cArray = this.declaringClass.computeUniqueKey(false);
        int n2 = cArray.length;
        int n3 = this.selector == TypeConstants.INIT || this.selector == null ? 0 : this.selector.length;
        char[] cArray2 = this.signature();
        int n4 = cArray2.length;
        char[] cArray3 = new char[n2 + 1 + n3 + n4];
        int n5 = 0;
        System.arraycopy(cArray, 0, cArray3, n5, n2);
        n5 = n2;
        cArray3[n5++] = 46;
        if (this.selector != null) {
            System.arraycopy(this.selector, 0, cArray3, n5, n3);
        }
        System.arraycopy(cArray2, 0, cArray3, n5 += n3, n4);
        return cArray3;
    }

    public TypeBinding constantPoolDeclaringClass() {
        return this.declaringClass;
    }

    public final char[] constantPoolName() {
        return this.selector;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public Object getDefaultValue() {
        MethodBinding methodBinding = this.original();
        if ((methodBinding.tagBits & 0x8000000000000L) == 0L) {
            methodBinding.tagBits |= 0x8000000000000L;
        }
        return null;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isConstructor() {
        return this.selector == TypeConstants.INIT || (this.tagBits & 0x20000000000000L) != 0L;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDefaultAbstract() {
        return (this.modifiers & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isImplementing() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public final boolean isOverriding() {
        return (this.modifiers & 0x10000000) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public final boolean isVarargs() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public MethodBinding original() {
        return this.a != null ? this.a : this;
    }

    @Override
    public char[] readableName() {
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            stringBuffer.append(this.declaringClass.sourceName());
        } else {
            stringBuffer.append(this.selector);
        }
        stringBuffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int n2 = 0;
            int n3 = this.parameters.length;
            while (n2 < n3) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.parameters[n2].sourceName());
                ++n2;
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString().toCharArray();
    }

    public void setDefaultValue(Object object) {
        MethodBinding methodBinding = this.original();
        methodBinding.tagBits |= 0x8000000000000L;
    }

    @Override
    public char[] shortReadableName() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            stringBuffer.append(this.declaringClass.shortReadableName());
        } else {
            stringBuffer.append(this.selector);
        }
        stringBuffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            n2 = 0;
            int n3 = this.parameters.length;
            while (n2 < n3) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.parameters[n2].shortReadableName());
                ++n2;
            }
        }
        stringBuffer.append(')');
        n2 = stringBuffer.length();
        char[] cArray = new char[n2];
        stringBuffer.getChars(0, n2, cArray, 0);
        return cArray;
    }

    protected final void setSelector(char[] cArray) {
        this.selector = cArray;
        this.b = null;
    }

    public final char[] signature() {
        int n2;
        boolean bl2;
        if (this.b != null) {
            return this.b;
        }
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        stringBuffer.append('(');
        TypeBinding[] typeBindingArray = this.parameters;
        boolean bl3 = this.isConstructor();
        boolean bl4 = bl2 = bl3 && this.declaringClass.isNestedType();
        if (typeBindingArray != Binding.NO_PARAMETERS) {
            n2 = 0;
            while (n2 < typeBindingArray.length) {
                stringBuffer.append(typeBindingArray[n2].signature());
                ++n2;
            }
        }
        if (bl2) {
            n2 = typeBindingArray.length;
            int n3 = this.parameters.length;
            while (n2 < n3) {
                stringBuffer.append(this.parameters[n2].signature());
                ++n2;
            }
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            stringBuffer.append(this.returnType.signature());
        }
        n2 = stringBuffer.length();
        this.b = new char[n2];
        stringBuffer.getChars(0, n2, this.b, 0);
        return this.b;
    }

    public final int sourceEnd() {
        AbstractMethodDeclaration abstractMethodDeclaration = this.sourceMethod();
        if (abstractMethodDeclaration == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceEnd();
            }
            return 0;
        }
        return abstractMethodDeclaration.sourceEnd;
    }

    public AbstractMethodDeclaration sourceMethod() {
        SourceTypeBinding sourceTypeBinding;
        try {
            sourceTypeBinding = (SourceTypeBinding)this.original().declaringClass;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        if (sourceTypeBinding != null) {
            return sourceTypeBinding.sourceMethod(this.original());
        }
        return null;
    }

    public final int sourceStart() {
        AbstractMethodDeclaration abstractMethodDeclaration = this.sourceMethod();
        if (abstractMethodDeclaration == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceStart();
            }
            return 0;
        }
        return abstractMethodDeclaration.sourceStart;
    }

    public String toString() {
        String string = this.returnType != null ? this.returnType.debugName() : "NULL TYPE";
        string = String.valueOf(string) + " ";
        string = String.valueOf(string) + (this.selector != null ? new String(this.selector) : "UNNAMED METHOD");
        string = String.valueOf(string) + "(";
        if (this.parameters != null) {
            if (this.parameters != Binding.NO_PARAMETERS) {
                int n2 = 0;
                int n3 = this.parameters.length;
                while (n2 < n3) {
                    if (n2 > 0) {
                        string = String.valueOf(string) + ", ";
                    }
                    string = String.valueOf(string) + (this.parameters[n2] != null ? this.parameters[n2].debugName() : "NULL TYPE");
                    ++n2;
                }
            }
        } else {
            string = String.valueOf(string) + "NULL PARAMETERS";
        }
        string = String.valueOf(string) + ") ";
        return string;
    }

    public MethodBinding tiebreakMethod() {
        return this;
    }

    public void createFunctionTypeBinding(Scope scope) {
        this.functionTypeBinding = new FunctionTypeBinding(this, scope);
    }

    public MethodBinding createNamedMethodBinding(char[] cArray) {
        MethodBinding methodBinding = new MethodBinding(this.modifiers, cArray, this.returnType, this.parameters, this.declaringClass);
        methodBinding.functionTypeBinding = this.functionTypeBinding;
        methodBinding.tagBits = this.tagBits;
        methodBinding.b = this.b;
        return methodBinding;
    }

    public void updateFrom(MethodBinding methodBinding) {
        this.returnType = methodBinding.returnType;
        this.parameters = methodBinding.parameters;
    }

    public void cleanup() {
        if (this.functionTypeBinding != null) {
            this.functionTypeBinding.cleanup();
        }
    }

    protected void setParameters(TypeBinding[] typeBindingArray) {
        this.parameters = typeBindingArray;
        if (this.a != null) {
            this.a.parameters = typeBindingArray;
        }
    }

    public TypeBinding[] getParameters() {
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        if (this.parameters != null && this.parameters.length > 0) {
            typeBindingArray = this.parameters;
        } else if (this.a.parameters != null && this.a.parameters.length > 0) {
            typeBindingArray = this.a.parameters;
        }
        return typeBindingArray;
    }

    void a() {
        if (this.declaringClass instanceof SourceTypeBinding) {
            SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)this.declaringClass;
            if ((sourceTypeBinding.tagBits & 0x8000L) == 0L) {
                sourceTypeBinding.methods();
            }
        }
    }
}

