/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.ccdt.jsdt.core.compiler.CharOperation;
import org.ccdt.jsdt.core.infer.InferOptions;
import org.ccdt.jsdt.internal.compiler.Compiler;
import org.ccdt.jsdt.internal.compiler.util.Util;

public class CompilerOptions {
    public static final String OPTION_SemanticValidation = "semanticValidation";
    public static final String OPTION_LocalVariableAttribute = "org.ccdt.jsdt.core.compiler.debug.localVariable";
    public static final String OPTION_LineNumberAttribute = "org.ccdt.jsdt.core.compiler.debug.lineNumber";
    public static final String OPTION_SourceFileAttribute = "org.ccdt.jsdt.core.compiler.debug.sourceFile";
    public static final String OPTION_PreserveUnusedLocal = "org.ccdt.jsdt.core.compiler.codegen.unusedLocal";
    public static final String OPTION_DocCommentSupport = "org.ccdt.jsdt.core.compiler.doc.comment.support";
    public static final String OPTION_ReportMethodWithConstructorName = "org.ccdt.jsdt.core.compiler.problem.methodWithConstructorName";
    public static final String OPTION_ReportUndefinedField = "org.ccdt.jsdt.core.compiler.problem.undefinedField";
    public static final String OPTION_ReportDeprecation = "org.ccdt.jsdt.core.compiler.problem.deprecation";
    public static final String OPTION_ReportDeprecationInDeprecatedCode = "org.ccdt.jsdt.core.compiler.problem.deprecationInDeprecatedCode";
    public static final String OPTION_ReportDeprecationWhenOverridingDeprecatedMethod = "org.ccdt.jsdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod";
    public static final String OPTION_ReportHiddenCatchBlock = "org.ccdt.jsdt.core.compiler.problem.hiddenCatchBlock";
    public static final String OPTION_ReportUnusedLocal = "org.ccdt.jsdt.core.compiler.problem.unusedLocal";
    public static final String OPTION_ReportUnusedParameter = "org.ccdt.jsdt.core.compiler.problem.unusedParameter";
    public static final String OPTION_ReportUnusedParameterWhenImplementingAbstract = "org.ccdt.jsdt.core.compiler.problem.unusedParameterWhenImplementingAbstract";
    public static final String OPTION_ReportUnusedParameterWhenOverridingConcrete = "org.ccdt.jsdt.core.compiler.problem.unusedParameterWhenOverridingConcrete";
    public static final String OPTION_ReportUnusedParameterIncludeDocCommentReference = "org.ccdt.jsdt.core.compiler.problem.unusedParameterIncludeDocCommentReference";
    public static final String OPTION_ReportWrongNumberOfArguments = "org.ccdt.jsdt.core.compiler.problem.wrongNumberOfArguments";
    public static final String OPTION_ReportNoEffectAssignment = "org.ccdt.jsdt.core.compiler.problem.noEffectAssignment";
    public static final String OPTION_ReportLocalVariableHiding = "org.ccdt.jsdt.core.compiler.problem.localVariableHiding";
    public static final String OPTION_ReportSpecialParameterHidingField = "org.ccdt.jsdt.core.compiler.problem.specialParameterHidingField";
    public static final String OPTION_ReportFieldHiding = "org.ccdt.jsdt.core.compiler.problem.fieldHiding";
    public static final String OPTION_ReportTypeParameterHiding = "org.ccdt.jsdt.core.compiler.problem.typeParameterHiding";
    public static final String OPTION_ReportPossibleAccidentalBooleanAssignment = "org.ccdt.jsdt.core.compiler.problem.possibleAccidentalBooleanAssignment";
    public static final String OPTION_ReportNonExternalizedStringLiteral = "org.ccdt.jsdt.core.compiler.problem.nonExternalizedStringLiteral";
    public static final String OPTION_ReportUnusedPrivateMember = "org.ccdt.jsdt.core.compiler.problem.unusedPrivateMember";
    public static final String OPTION_ReportAssertIdentifier = "org.ccdt.jsdt.core.compiler.problem.assertIdentifier";
    public static final String OPTION_ReportEnumIdentifier = "org.ccdt.jsdt.core.compiler.problem.enumIdentifier";
    public static final String OPTION_ReportNonStaticAccessToStatic = "org.ccdt.jsdt.core.compiler.problem.staticAccessReceiver";
    public static final String OPTION_ReportIndirectStaticAccess = "org.ccdt.jsdt.core.compiler.problem.indirectStaticAccess";
    public static final String OPTION_ReportEmptyStatement = "org.ccdt.jsdt.core.compiler.problem.emptyStatement";
    public static final String OPTION_ReportUnnecessaryTypeCheck = "org.ccdt.jsdt.core.compiler.problem.unnecessaryTypeCheck";
    public static final String OPTION_ReportUnnecessaryElse = "org.ccdt.jsdt.core.compiler.problem.unnecessaryElse";
    public static final String OPTION_ReportUndocumentedEmptyBlock = "org.ccdt.jsdt.core.compiler.problem.undocumentedEmptyBlock";
    public static final String OPTION_ReportInvalidJavadoc = "org.ccdt.jsdt.core.compiler.problem.invalidJavadoc";
    public static final String OPTION_ReportInvalidJavadocTags = "org.ccdt.jsdt.core.compiler.problem.invalidJavadocTags";
    public static final String OPTION_ReportInvalidJavadocTagsDeprecatedRef = "org.ccdt.jsdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef";
    public static final String OPTION_ReportInvalidJavadocTagsNotVisibleRef = "org.ccdt.jsdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef";
    public static final String OPTION_ReportInvalidJavadocTagsVisibility = "org.ccdt.jsdt.core.compiler.problem.invalidJavadocTagsVisibility";
    public static final String OPTION_ReportMissingJavadocTags = "org.ccdt.jsdt.core.compiler.problem.missingJavadocTags";
    public static final String OPTION_ReportMissingJavadocTagsVisibility = "org.ccdt.jsdt.core.compiler.problem.missingJavadocTagsVisibility";
    public static final String OPTION_ReportMissingJavadocTagsOverriding = "org.ccdt.jsdt.core.compiler.problem.missingJavadocTagsOverriding";
    public static final String OPTION_ReportMissingJavadocComments = "org.ccdt.jsdt.core.compiler.problem.missingJavadocComments";
    public static final String OPTION_ReportMissingJavadocCommentsVisibility = "org.ccdt.jsdt.core.compiler.problem.missingJavadocCommentsVisibility";
    public static final String OPTION_ReportMissingJavadocCommentsOverriding = "org.ccdt.jsdt.core.compiler.problem.missingJavadocCommentsOverriding";
    public static final String OPTION_ReportFinallyBlockNotCompletingNormally = "org.ccdt.jsdt.core.compiler.problem.finallyBlockNotCompletingNormally";
    public static final String OPTION_ReportUnusedDeclaredThrownException = "org.ccdt.jsdt.core.compiler.problem.unusedDeclaredThrownException";
    public static final String OPTION_ReportUnusedDeclaredThrownExceptionWhenOverriding = "org.ccdt.jsdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding";
    public static final String OPTION_ReportUnqualifiedFieldAccess = "org.ccdt.jsdt.core.compiler.problem.unqualifiedFieldAccess";
    public static final String OPTION_ReportUncheckedTypeOperation = "org.ccdt.jsdt.core.compiler.problem.uncheckedTypeOperation";
    public static final String OPTION_ReportRawTypeReference = "org.ccdt.jsdt.core.compiler.problem.rawTypeReference";
    public static final String OPTION_ReportFinalParameterBound = "org.ccdt.jsdt.core.compiler.problem.finalParameterBound";
    public static final String OPTION_Source = "org.ccdt.jsdt.core.compiler.source";
    public static final String OPTION_TargetPlatform = "org.ccdt.jsdt.core.compiler.codegen.targetPlatform";
    public static final String OPTION_Compliance = "org.ccdt.jsdt.core.compiler.compliance";
    public static final String OPTION_Encoding = "org.ccdt.jsdt.core.encoding";
    public static final String OPTION_MaxProblemPerUnit = "org.ccdt.jsdt.core.compiler.maxProblemPerUnit";
    public static final String OPTION_TaskTags = "org.ccdt.jsdt.core.compiler.taskTags";
    public static final String OPTION_TaskPriorities = "org.ccdt.jsdt.core.compiler.taskPriorities";
    public static final String OPTION_TaskCaseSensitive = "org.ccdt.jsdt.core.compiler.taskCaseSensitive";
    public static final String OPTION_InlineJsr = "org.ccdt.jsdt.core.compiler.codegen.inlineJsrBytecode";
    public static final String OPTION_ReportNullReference = "org.ccdt.jsdt.core.compiler.problem.nullReference";
    public static final String OPTION_ReportPotentialNullReference = "org.ccdt.jsdt.core.compiler.problem.potentialNullReference";
    public static final String OPTION_ReportDuplicateLocalVariables = "org.ccdt.jsdt.core.compiler.problem.duplicateLocalVariables";
    public static final String OPTION_ReportRedundantNullCheck = "org.ccdt.jsdt.core.compiler.problem.redundantNullCheck";
    public static final String OPTION_ReportUninitializedLocalVariable = "org.ccdt.jsdt.core.compiler.problem.uninitializedLocalVariable";
    public static final String OPTION_ReportUninitializedGlobalVariable = "org.ccdt.jsdt.core.compiler.problem.uninitializedGlobalVariable";
    public static final String OPTION_ReportForbiddenReference = "org.ccdt.jsdt.core.compiler.problem.forbiddenReference";
    public static final String OPTION_ReportDiscouragedReference = "org.ccdt.jsdt.core.compiler.problem.discouragedReference";
    public static final String OPTION_SuppressWarnings = "org.ccdt.jsdt.core.compiler.problem.suppressWarnings";
    public static final String OPTION_ReportUnusedLabel = "org.ccdt.jsdt.core.compiler.problem.unusedLabel";
    public static final String OPTION_FatalOptionalError = "org.ccdt.jsdt.core.compiler.problem.fatalOptionalError";
    public static final String OPTION_ReportParameterAssignment = "org.ccdt.jsdt.core.compiler.problem.parameterAssignment";
    public static final String OPTION_ReportFallthroughCase = "org.ccdt.jsdt.core.compiler.problem.fallthroughCase";
    public static final String OPTION_ReportOverridingMethodWithoutSuperInvocation = "org.ccdt.jsdt.core.compiler.problem.overridingMethodWithoutSuperInvocation";
    public static final String OPTION_GenerateClassFiles = "org.ccdt.jsdt.core.compiler.generateClassFiles";
    public static final String OPTION_Process_Annotations = "org.ccdt.jsdt.core.compiler.processAnnotations";
    public static final String OPTION_Unresolved_Type = "org.ccdt.jsdt.core.compiler.problem.unresolvedTypeReference";
    public static final String OPTION_Unresolved_Field = "org.ccdt.jsdt.core.compiler.problem.unresolvedFieldReference";
    public static final String OPTION_Unresolved_Method = "org.ccdt.jsdt.core.compiler.problem.unresolvedMethodReference";
    public static final String OPTION_LOOSE_VAR_DECL = "org.ccdt.jsdt.core.compiler.problem.looseVarDecleration";
    public static final String OPTION_OPTIONAL_SEMICOLON = "org.ccdt.jsdt.core.compiler.problem.optionalSemicolon";
    public static final String OPTION_ReportInvalidAnnotation = "org.ccdt.jsdt.core.compiler.problem.invalidAnnotation";
    public static final String OPTION_ReportMissingAnnotation = "org.ccdt.jsdt.core.compiler.problem.missingAnnotation";
    public static final String OPTION_ReportMissingJavadoc = "org.ccdt.jsdt.core.compiler.problem.missingJavadoc";
    public static final String GENERATE = "generate";
    public static final String DO_NOT_GENERATE = "do not generate";
    public static final String PRESERVE = "preserve";
    public static final String OPTIMIZE_OUT = "optimize out";
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_1_2 = "1.2";
    public static final String VERSION_1_3 = "1.3";
    public static final String VERSION_1_4 = "1.4";
    public static final String VERSION_JSR14 = "jsr14";
    public static final String VERSION_1_5 = "1.5";
    public static final String VERSION_1_6 = "1.6";
    public static final String VERSION_1_7 = "1.7";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String PUBLIC = "public";
    public static final String PROTECTED = "protected";
    public static final String DEFAULT = "default";
    public static final String PRIVATE = "private";
    public static final long MethodWithConstructorName = 1L;
    public static final long UndefinedField = 2L;
    public static final long UsingDeprecatedAPI = 4L;
    public static final long MaskedCatchBlock = 8L;
    public static final long UnusedLocalVariable = 16L;
    public static final long UnusedArgument = 32L;
    public static final long AccessEmulation = 128L;
    public static final long WrongNumberOfArguments = 128L;
    public static final long NonExternalizedString = 256L;
    public static final long AssertUsedAsAnIdentifier = 512L;
    public static final long NonStaticAccessToStatic = 2048L;
    public static final long Task = 4096L;
    public static final long NoEffectAssignment = 8192L;
    public static final long UnusedPrivateMember = 32768L;
    public static final long LocalVariableHiding = 65536L;
    public static final long FieldHiding = 131072L;
    public static final long AccidentalBooleanAssign = 262144L;
    public static final long EmptyStatement = 524288L;
    public static final long MissingJavadocComments = 0x100000L;
    public static final long MissingJavadocTags = 0x200000L;
    public static final long UnqualifiedFieldAccess = 0x400000L;
    public static final long UnusedDeclaredThrownException = 0x800000L;
    public static final long FinallyBlockNotCompleting = 0x1000000L;
    public static final long InvalidJavadoc = 0x2000000L;
    public static final long UnnecessaryTypeCheck = 0x4000000L;
    public static final long UndocumentedEmptyBlock = 0x8000000L;
    public static final long IndirectStaticAccess = 0x10000000L;
    public static final long UnnecessaryElse = 0x20000000L;
    public static final long UncheckedTypeOperation = 0x40000000L;
    public static final long FinalParameterBound = 0x80000000L;
    public static final long EnumUsedAsAnIdentifier = 0x200000000L;
    public static final long ForbiddenReference = 0x400000000L;
    public static final long NullReference = 0x1000000000L;
    public static final long TypeHiding = 0x8000000000L;
    public static final long DiscouragedReference = 0x80000000000L;
    public static final long RawTypeReference = 0x200000000000L;
    public static final long UnusedLabel = 0x400000000000L;
    public static final long ParameterAssignment = 0x800000000000L;
    public static final long FallthroughCase = 0x1000000000000L;
    public static final long OverridingMethodWithoutSuperInvocation = 0x2000000000000L;
    public static final long PotentialNullReference = 0x4000000000000L;
    public static final long DuplicateLocalVariables = 0x200000000000000L;
    public static final long RedundantNullCheck = 0x8000000000000L;
    public static final long UnresolvedType = 0x10000000000000L;
    public static final long UnresolvedMethod = 0x20000000000000L;
    public static final long UnresolvedField = 0x40000000000000L;
    public static final long LooseVariableDecl = 0x80000000000000L;
    public static final long OptionalSemicolon = 0x100000000000000L;
    public static final long UninitializedLocalVariable = 0x400000000000000L;
    public static final long UninitializedGlobalVariable = 0x800000000000000L;
    private static Map a;
    public long errorThreshold = 0L;
    public long warningThreshold = 114927972952607L;
    public int produceDebugAttributes = 3;
    public long complianceLevel = 0x300000L;
    public long sourceLevel = 0x2F0000L;
    public long targetJDK = 0x2E0000L;
    public String defaultEncoding = null;
    public boolean verbose = Compiler.DEBUG;
    public boolean produceReferenceInfo = false;
    public boolean preserveAllLocalVariables = false;
    public boolean parseLiteralExpressionsAsConstants = true;
    public int maxProblemsPerUnit = 100;
    public char[][] taskTags = null;
    public char[][] taskPriorites = null;
    public boolean isTaskCaseSensitive = true;
    public boolean reportDeprecationInsideDeprecatedCode = false;
    public boolean reportDeprecationWhenOverridingDeprecatedMethod = false;
    public boolean reportUnusedParameterWhenImplementingAbstract = false;
    public boolean reportUnusedParameterWhenOverridingConcrete = false;
    public boolean reportUnusedParameterIncludeDocCommentReference = true;
    public boolean reportUnusedDeclaredThrownExceptionWhenOverriding = false;
    public boolean reportSpecialParameterHidingField = false;
    public int reportInvalidJavadocTagsVisibility = 0;
    public boolean reportInvalidJavadocTags = false;
    public boolean reportInvalidJavadocTagsDeprecatedRef = false;
    public boolean reportInvalidJavadocTagsNotVisibleRef = false;
    public int reportMissingJavadocTagsVisibility = 0;
    public boolean reportMissingJavadocTagsOverriding = false;
    public int reportMissingJavadocCommentsVisibility = 0;
    public boolean reportMissingJavadocCommentsOverriding = false;
    public boolean inlineJsrBytecode = false;
    public boolean docCommentSupport = false;
    public boolean suppressWarnings = true;
    public boolean treatOptionalErrorAsFatal = true;
    public boolean performMethodsFullRecovery = true;
    public boolean performStatementsRecovery = true;
    public boolean storeAnnotations = false;
    public boolean generateClassFiles = true;
    public boolean processAnnotations = false;
    public InferOptions inferOptions = new InferOptions();
    public boolean enableSemanticValidation = false;
    public static final String[] warningTokens;

    static {
        warningTokens = new String[]{"all", "cast", "deprecation", "fallthrough", "finally", "hiding", "nls", "null", "restriction", "static-access", "super", "synthetic-access", "unchecked", "unqualified-field-access", "unused", "uninitializedLocalVariable", "uninitializedGlobalVariable"};
    }

    public CompilerOptions() {
    }

    public CompilerOptions(Map map) {
        if (map == null) {
            return;
        }
        this.set(map);
    }

    public CompilerOptions(Map map, boolean bl2) {
        this(map);
        this.parseLiteralExpressionsAsConstants = bl2;
    }

    public Map getMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>(30);
        hashMap.put(OPTION_SemanticValidation, this.enableSemanticValidation ? ENABLED : DISABLED);
        hashMap.put(OPTION_LocalVariableAttribute, (this.produceDebugAttributes & 4) != 0 ? GENERATE : DO_NOT_GENERATE);
        hashMap.put(OPTION_LineNumberAttribute, (this.produceDebugAttributes & 2) != 0 ? GENERATE : DO_NOT_GENERATE);
        hashMap.put(OPTION_SourceFileAttribute, (this.produceDebugAttributes & 1) != 0 ? GENERATE : DO_NOT_GENERATE);
        hashMap.put(OPTION_PreserveUnusedLocal, this.preserveAllLocalVariables ? PRESERVE : OPTIMIZE_OUT);
        hashMap.put(OPTION_DocCommentSupport, this.docCommentSupport ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportMethodWithConstructorName, this.getSeverityString(1L));
        hashMap.put(OPTION_ReportUndefinedField, this.getSeverityString(2L));
        hashMap.put(OPTION_ReportDeprecation, this.getSeverityString(4L));
        hashMap.put(OPTION_ReportDeprecationInDeprecatedCode, this.reportDeprecationInsideDeprecatedCode ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportDeprecationWhenOverridingDeprecatedMethod, this.reportDeprecationWhenOverridingDeprecatedMethod ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportHiddenCatchBlock, this.getSeverityString(8L));
        hashMap.put(OPTION_ReportUnusedLocal, this.getSeverityString(16L));
        hashMap.put(OPTION_ReportUnusedParameter, this.getSeverityString(32L));
        hashMap.put(OPTION_ReportWrongNumberOfArguments, this.getSeverityString(128L));
        hashMap.put(OPTION_ReportNoEffectAssignment, this.getSeverityString(8192L));
        hashMap.put(OPTION_ReportNonExternalizedStringLiteral, this.getSeverityString(256L));
        hashMap.put(OPTION_ReportNonStaticAccessToStatic, this.getSeverityString(2048L));
        hashMap.put(OPTION_ReportIndirectStaticAccess, this.getSeverityString(0x10000000L));
        hashMap.put(OPTION_ReportUnusedPrivateMember, this.getSeverityString(32768L));
        hashMap.put(OPTION_ReportLocalVariableHiding, this.getSeverityString(65536L));
        hashMap.put(OPTION_ReportFieldHiding, this.getSeverityString(131072L));
        hashMap.put(OPTION_ReportTypeParameterHiding, this.getSeverityString(0x8000000000L));
        hashMap.put(OPTION_ReportPossibleAccidentalBooleanAssignment, this.getSeverityString(262144L));
        hashMap.put(OPTION_ReportEmptyStatement, this.getSeverityString(524288L));
        hashMap.put(OPTION_ReportAssertIdentifier, this.getSeverityString(512L));
        hashMap.put(OPTION_ReportEnumIdentifier, this.getSeverityString(0x200000000L));
        hashMap.put(OPTION_ReportUndocumentedEmptyBlock, this.getSeverityString(0x8000000L));
        hashMap.put(OPTION_ReportUnnecessaryTypeCheck, this.getSeverityString(0x4000000L));
        hashMap.put(OPTION_ReportUnnecessaryElse, this.getSeverityString(0x20000000L));
        hashMap.put(OPTION_ReportInvalidJavadoc, this.getSeverityString(0x2000000L));
        hashMap.put(OPTION_ReportInvalidJavadocTagsVisibility, this.getVisibilityString(this.reportInvalidJavadocTagsVisibility));
        hashMap.put(OPTION_ReportInvalidJavadocTags, this.reportInvalidJavadocTags ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportInvalidJavadocTagsDeprecatedRef, this.reportInvalidJavadocTagsDeprecatedRef ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportInvalidJavadocTagsNotVisibleRef, this.reportInvalidJavadocTagsNotVisibleRef ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportMissingJavadocTags, this.getSeverityString(0x200000L));
        hashMap.put(OPTION_ReportMissingJavadocTagsVisibility, this.getVisibilityString(this.reportMissingJavadocTagsVisibility));
        hashMap.put(OPTION_ReportMissingJavadocTagsOverriding, this.reportMissingJavadocTagsOverriding ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportMissingJavadocComments, this.getSeverityString(0x100000L));
        hashMap.put(OPTION_ReportMissingJavadocCommentsVisibility, this.getVisibilityString(this.reportMissingJavadocCommentsVisibility));
        hashMap.put(OPTION_ReportMissingJavadocCommentsOverriding, this.reportMissingJavadocCommentsOverriding ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportFinallyBlockNotCompletingNormally, this.getSeverityString(0x1000000L));
        hashMap.put(OPTION_ReportUnusedDeclaredThrownException, this.getSeverityString(0x800000L));
        hashMap.put(OPTION_ReportUnusedDeclaredThrownExceptionWhenOverriding, this.reportUnusedDeclaredThrownExceptionWhenOverriding ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportUnqualifiedFieldAccess, this.getSeverityString(0x400000L));
        hashMap.put(OPTION_ReportUncheckedTypeOperation, this.getSeverityString(0x40000000L));
        hashMap.put(OPTION_ReportRawTypeReference, this.getSeverityString(0x200000000000L));
        hashMap.put(OPTION_ReportFinalParameterBound, this.getSeverityString(0x80000000L));
        hashMap.put(OPTION_ReportForbiddenReference, this.getSeverityString(0x400000000L));
        hashMap.put(OPTION_ReportDiscouragedReference, this.getSeverityString(0x80000000000L));
        hashMap.put(OPTION_ReportUnusedLabel, this.getSeverityString(0x400000000000L));
        hashMap.put(OPTION_Compliance, CompilerOptions.versionFromJdkLevel(this.complianceLevel));
        hashMap.put(OPTION_Source, CompilerOptions.versionFromJdkLevel(this.sourceLevel));
        hashMap.put(OPTION_TargetPlatform, CompilerOptions.versionFromJdkLevel(this.targetJDK));
        hashMap.put(OPTION_FatalOptionalError, this.treatOptionalErrorAsFatal ? ENABLED : DISABLED);
        if (this.defaultEncoding != null) {
            hashMap.put(OPTION_Encoding, this.defaultEncoding);
        }
        hashMap.put(OPTION_TaskTags, this.taskTags == null ? Util.EMPTY_STRING : new String(CharOperation.concatWith(this.taskTags, ',')));
        hashMap.put(OPTION_TaskPriorities, this.taskPriorites == null ? Util.EMPTY_STRING : new String(CharOperation.concatWith(this.taskPriorites, ',')));
        hashMap.put(OPTION_TaskCaseSensitive, this.isTaskCaseSensitive ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportUnusedParameterWhenImplementingAbstract, this.reportUnusedParameterWhenImplementingAbstract ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportUnusedParameterWhenOverridingConcrete, this.reportUnusedParameterWhenOverridingConcrete ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportUnusedParameterIncludeDocCommentReference, this.reportUnusedParameterIncludeDocCommentReference ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportSpecialParameterHidingField, this.reportSpecialParameterHidingField ? ENABLED : DISABLED);
        hashMap.put(OPTION_MaxProblemPerUnit, String.valueOf(this.maxProblemsPerUnit));
        hashMap.put(OPTION_InlineJsr, this.inlineJsrBytecode ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportNullReference, this.getSeverityString(0x1000000000L));
        hashMap.put(OPTION_ReportPotentialNullReference, this.getSeverityString(0x4000000000000L));
        hashMap.put(OPTION_ReportDuplicateLocalVariables, this.getSeverityString(0x200000000000000L));
        hashMap.put(OPTION_ReportRedundantNullCheck, this.getSeverityString(0x8000000000000L));
        hashMap.put(OPTION_ReportUninitializedLocalVariable, this.getSeverityString(0x400000000000000L));
        hashMap.put(OPTION_ReportUninitializedGlobalVariable, this.getSeverityString(0x800000000000000L));
        hashMap.put(OPTION_SuppressWarnings, this.suppressWarnings ? ENABLED : DISABLED);
        hashMap.put(OPTION_ReportParameterAssignment, this.getSeverityString(0x800000000000L));
        hashMap.put(OPTION_ReportFallthroughCase, this.getSeverityString(0x1000000000000L));
        hashMap.put(OPTION_ReportOverridingMethodWithoutSuperInvocation, this.getSeverityString(0x2000000000000L));
        hashMap.put(OPTION_GenerateClassFiles, this.generateClassFiles ? ENABLED : DISABLED);
        hashMap.put(OPTION_Process_Annotations, this.processAnnotations ? ENABLED : DISABLED);
        hashMap.put(OPTION_Unresolved_Type, this.getSeverityString(0x10000000000000L));
        hashMap.put(OPTION_Unresolved_Field, this.getSeverityString(0x40000000000000L));
        hashMap.put(OPTION_Unresolved_Method, this.getSeverityString(0x20000000000000L));
        hashMap.put(OPTION_LOOSE_VAR_DECL, this.getSeverityString(0x80000000000000L));
        hashMap.put(OPTION_OPTIONAL_SEMICOLON, this.getSeverityString(0x100000000000000L));
        Map map = this.inferOptions.getMap();
        hashMap.putAll(map);
        return hashMap;
    }

    public static String optionKeyFromIrritant(long l2) {
        int n2 = (int)l2;
        if ((long)n2 == l2) {
            switch (n2) {
                case 1: {
                    return OPTION_ReportMethodWithConstructorName;
                }
                case 2: {
                    return OPTION_ReportUndefinedField;
                }
                case 4: 
                case 0x2000004: {
                    return OPTION_ReportDeprecation;
                }
                case 8: {
                    return OPTION_ReportHiddenCatchBlock;
                }
                case 16: {
                    return OPTION_ReportUnusedLocal;
                }
                case 32: {
                    return OPTION_ReportUnusedParameter;
                }
                case 128: {
                    return OPTION_ReportWrongNumberOfArguments;
                }
                case 256: {
                    return OPTION_ReportNonExternalizedStringLiteral;
                }
                case 512: {
                    return OPTION_ReportAssertIdentifier;
                }
                case 2048: {
                    return OPTION_ReportNonStaticAccessToStatic;
                }
                case 4096: {
                    return OPTION_TaskTags;
                }
                case 8192: {
                    return OPTION_ReportNoEffectAssignment;
                }
                case 32768: {
                    return OPTION_ReportUnusedPrivateMember;
                }
                case 65536: {
                    return OPTION_ReportLocalVariableHiding;
                }
                case 131072: {
                    return OPTION_ReportFieldHiding;
                }
                case 262144: {
                    return OPTION_ReportPossibleAccidentalBooleanAssignment;
                }
                case 524288: {
                    return OPTION_ReportEmptyStatement;
                }
                case 0x100000: {
                    return OPTION_ReportMissingJavadocComments;
                }
                case 0x200000: {
                    return OPTION_ReportMissingJavadocTags;
                }
                case 0x400000: {
                    return OPTION_ReportUnqualifiedFieldAccess;
                }
                case 0x800000: {
                    return OPTION_ReportUnusedDeclaredThrownExceptionWhenOverriding;
                }
                case 0x1000000: {
                    return OPTION_ReportFinallyBlockNotCompletingNormally;
                }
                case 0x2000000: {
                    return OPTION_ReportInvalidJavadoc;
                }
                case 0x4000000: {
                    return OPTION_ReportUnnecessaryTypeCheck;
                }
                case 0x8000000: {
                    return OPTION_ReportUndocumentedEmptyBlock;
                }
                case 0x10000000: {
                    return OPTION_ReportIndirectStaticAccess;
                }
                case 0x20000000: {
                    return OPTION_ReportUnnecessaryElse;
                }
                case 0x40000000: {
                    return OPTION_ReportUncheckedTypeOperation;
                }
                case -2147483648: {
                    return OPTION_ReportFinalParameterBound;
                }
            }
        } else {
            n2 = (int)(l2 >>> 32);
            switch (n2) {
                case 2: {
                    return OPTION_ReportEnumIdentifier;
                }
                case 4: {
                    return OPTION_ReportForbiddenReference;
                }
                case 16: {
                    return OPTION_ReportNullReference;
                }
                case 262144: {
                    return OPTION_ReportPotentialNullReference;
                }
                case 0x2000000: {
                    return OPTION_ReportDuplicateLocalVariables;
                }
                case 524288: {
                    return OPTION_ReportRedundantNullCheck;
                }
                case 0x4000000: {
                    return OPTION_ReportUninitializedLocalVariable;
                }
                case 0x8000000: {
                    return OPTION_ReportUninitializedGlobalVariable;
                }
                case 128: {
                    return OPTION_ReportTypeParameterHiding;
                }
                case 2048: {
                    return OPTION_ReportDiscouragedReference;
                }
                case 8192: {
                    return OPTION_ReportRawTypeReference;
                }
                case 16384: {
                    return OPTION_ReportUnusedLabel;
                }
                case 32768: {
                    return OPTION_ReportParameterAssignment;
                }
                case 65536: {
                    return OPTION_ReportFallthroughCase;
                }
                case 131072: {
                    return OPTION_ReportOverridingMethodWithoutSuperInvocation;
                }
                case 0x100000: {
                    return OPTION_Unresolved_Type;
                }
                case 0x200000: {
                    return OPTION_Unresolved_Method;
                }
                case 0x400000: {
                    return OPTION_Unresolved_Field;
                }
                case 0x800000: {
                    return OPTION_LOOSE_VAR_DECL;
                }
                case 0x1000000: {
                    return OPTION_OPTIONAL_SEMICOLON;
                }
            }
        }
        return null;
    }

    public static long optionKeyToIrritant(String string) {
        Long l2;
        if (a == null) {
            long l3 = 0L;
            int n2 = 0;
            while (n2 < 64) {
                String string2 = CompilerOptions.optionKeyFromIrritant(l3 <<= 1);
                if (string2 != null) {
                    a.put(string2, new Long(l3));
                }
                ++n2;
            }
        }
        return (l2 = (Long)a.get(string)) == null ? 0L : l2;
    }

    public int getSeverity(long l2) {
        if ((this.errorThreshold & l2) != 0L) {
            return this.treatOptionalErrorAsFatal ? 161 : 33;
        }
        if ((this.warningThreshold & l2) != 0L) {
            return 32;
        }
        return -1;
    }

    public String getSeverityString(long l2) {
        if ((this.warningThreshold & l2) != 0L) {
            return WARNING;
        }
        if ((this.errorThreshold & l2) != 0L) {
            return ERROR;
        }
        return IGNORE;
    }

    public String getVisibilityString(int n2) {
        switch (n2 & 7) {
            case 1: {
                return PUBLIC;
            }
            case 4: {
                return PROTECTED;
            }
            case 2: {
                return PRIVATE;
            }
        }
        return DEFAULT;
    }

    public void set(Map map) {
        long l2;
        Object v2 = map.get(OPTION_SemanticValidation);
        if (v2 != null) {
            if (ENABLED.equals(v2)) {
                this.enableSemanticValidation = true;
            } else if (DISABLED.equals(v2)) {
                this.enableSemanticValidation = false;
            }
        }
        if ((v2 = map.get(OPTION_LocalVariableAttribute)) != null) {
            if (GENERATE.equals(v2)) {
                this.produceDebugAttributes |= 4;
            } else if (DO_NOT_GENERATE.equals(v2)) {
                this.produceDebugAttributes &= 0xFFFFFFFB;
            }
        }
        if ((v2 = map.get(OPTION_LineNumberAttribute)) != null) {
            if (GENERATE.equals(v2)) {
                this.produceDebugAttributes |= 2;
            } else if (DO_NOT_GENERATE.equals(v2)) {
                this.produceDebugAttributes &= 0xFFFFFFFD;
            }
        }
        if ((v2 = map.get(OPTION_SourceFileAttribute)) != null) {
            if (GENERATE.equals(v2)) {
                this.produceDebugAttributes |= 1;
            } else if (DO_NOT_GENERATE.equals(v2)) {
                this.produceDebugAttributes &= 0xFFFFFFFE;
            }
        }
        if ((v2 = map.get(OPTION_PreserveUnusedLocal)) != null) {
            if (PRESERVE.equals(v2)) {
                this.preserveAllLocalVariables = true;
            } else if (OPTIMIZE_OUT.equals(v2)) {
                this.preserveAllLocalVariables = false;
            }
        }
        if ((v2 = map.get(OPTION_ReportDeprecationInDeprecatedCode)) != null) {
            if (ENABLED.equals(v2)) {
                this.reportDeprecationInsideDeprecatedCode = true;
            } else if (DISABLED.equals(v2)) {
                this.reportDeprecationInsideDeprecatedCode = false;
            }
        }
        if ((v2 = map.get(OPTION_ReportDeprecationWhenOverridingDeprecatedMethod)) != null) {
            if (ENABLED.equals(v2)) {
                this.reportDeprecationWhenOverridingDeprecatedMethod = true;
            } else if (DISABLED.equals(v2)) {
                this.reportDeprecationWhenOverridingDeprecatedMethod = false;
            }
        }
        if ((v2 = map.get(OPTION_ReportUnusedDeclaredThrownExceptionWhenOverriding)) != null) {
            if (ENABLED.equals(v2)) {
                this.reportUnusedDeclaredThrownExceptionWhenOverriding = true;
            } else if (DISABLED.equals(v2)) {
                this.reportUnusedDeclaredThrownExceptionWhenOverriding = false;
            }
        }
        if ((v2 = map.get(OPTION_Compliance)) != null && (l2 = CompilerOptions.versionToJdkLevel(v2)) != 0L) {
            this.complianceLevel = l2;
        }
        if ((v2 = map.get(OPTION_Source)) != null && (l2 = CompilerOptions.versionToJdkLevel(v2)) != 0L) {
            this.sourceLevel = l2;
        }
        if ((v2 = map.get(OPTION_TargetPlatform)) != null) {
            l2 = CompilerOptions.versionToJdkLevel(v2);
            if (l2 != 0L) {
                this.targetJDK = l2;
            }
            if (this.targetJDK >= 0x310000L) {
                this.inlineJsrBytecode = true;
            }
        }
        if ((v2 = map.get(OPTION_Encoding)) != null && v2 instanceof String) {
            this.defaultEncoding = null;
            String string = (String)v2;
            if (string.length() > 0) {
                try {
                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), string);
                    this.defaultEncoding = string;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        if ((v2 = map.get(OPTION_ReportUnusedParameterWhenImplementingAbstract)) != null) {
            if (ENABLED.equals(v2)) {
                this.reportUnusedParameterWhenImplementingAbstract = true;
            } else if (DISABLED.equals(v2)) {
                this.reportUnusedParameterWhenImplementingAbstract = false;
            }
        }
        if ((v2 = map.get(OPTION_ReportUnusedParameterWhenOverridingConcrete)) != null) {
            if (ENABLED.equals(v2)) {
                this.reportUnusedParameterWhenOverridingConcrete = true;
            } else if (DISABLED.equals(v2)) {
                this.reportUnusedParameterWhenOverridingConcrete = false;
            }
        }
        if ((v2 = map.get(OPTION_ReportUnusedParameterIncludeDocCommentReference)) != null) {
            if (ENABLED.equals(v2)) {
                this.reportUnusedParameterIncludeDocCommentReference = true;
            } else if (DISABLED.equals(v2)) {
                this.reportUnusedParameterIncludeDocCommentReference = false;
            }
        }
        if ((v2 = map.get(OPTION_ReportSpecialParameterHidingField)) != null) {
            if (ENABLED.equals(v2)) {
                this.reportSpecialParameterHidingField = true;
            } else if (DISABLED.equals(v2)) {
                this.reportSpecialParameterHidingField = false;
            }
        }
        if ((v2 = map.get(OPTION_MaxProblemPerUnit)) != null && v2 instanceof String) {
            String string = (String)v2;
            try {
                int n2 = Integer.parseInt(string);
                if (n2 >= 0) {
                    this.maxProblemsPerUnit = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((v2 = map.get(OPTION_TaskTags)) != null && v2 instanceof String) {
            String string = (String)v2;
            this.taskTags = (char[][])(string.length() == 0 ? null : CharOperation.splitAndTrimOn(',', string.toCharArray()));
        }
        if ((v2 = map.get(OPTION_TaskPriorities)) != null && v2 instanceof String) {
            String string = (String)v2;
            this.taskPriorites = (char[][])(string.length() == 0 ? null : CharOperation.splitAndTrimOn(',', string.toCharArray()));
        }
        if ((v2 = map.get(OPTION_TaskCaseSensitive)) != null) {
            if (ENABLED.equals(v2)) {
                this.isTaskCaseSensitive = true;
            } else if (DISABLED.equals(v2)) {
                this.isTaskCaseSensitive = false;
            }
        }
        if ((v2 = map.get(OPTION_InlineJsr)) != null && this.targetJDK < 0x310000L) {
            if (ENABLED.equals(v2)) {
                this.inlineJsrBytecode = true;
            } else if (DISABLED.equals(v2)) {
                this.inlineJsrBytecode = false;
            }
        }
        if ((v2 = map.get(OPTION_SuppressWarnings)) != null) {
            if (ENABLED.equals(v2)) {
                this.suppressWarnings = true;
            } else if (DISABLED.equals(v2)) {
                this.suppressWarnings = false;
            }
        }
        if ((v2 = map.get(OPTION_FatalOptionalError)) != null) {
            if (ENABLED.equals(v2)) {
                this.treatOptionalErrorAsFatal = true;
            } else if (DISABLED.equals(v2)) {
                this.treatOptionalErrorAsFatal = false;
            }
        }
        if ((v2 = map.get(OPTION_ReportMethodWithConstructorName)) != null) {
            this.a(1L, v2);
        }
        if ((v2 = map.get(OPTION_ReportUndefinedField)) != null) {
            this.a(2L, v2);
        }
        if ((v2 = map.get(OPTION_ReportDeprecation)) != null) {
            this.a(4L, v2);
        }
        if ((v2 = map.get(OPTION_ReportHiddenCatchBlock)) != null) {
            this.a(8L, v2);
        }
        if ((v2 = map.get(OPTION_ReportUnusedLocal)) != null) {
            this.a(16L, v2);
        }
        if ((v2 = map.get(OPTION_ReportUnusedParameter)) != null) {
            this.a(32L, v2);
        }
        if ((v2 = map.get(OPTION_ReportUnusedPrivateMember)) != null) {
            this.a(32768L, v2);
        }
        if ((v2 = map.get(OPTION_ReportUnusedDeclaredThrownException)) != null) {
            this.a(0x800000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportWrongNumberOfArguments)) != null) {
            this.a(128L, v2);
        }
        if ((v2 = map.get(OPTION_ReportLocalVariableHiding)) != null) {
            this.a(65536L, v2);
        }
        if ((v2 = map.get(OPTION_ReportFieldHiding)) != null) {
            this.a(131072L, v2);
        }
        if ((v2 = map.get(OPTION_ReportTypeParameterHiding)) != null) {
            this.a(0x8000000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportPossibleAccidentalBooleanAssignment)) != null) {
            this.a(262144L, v2);
        }
        if ((v2 = map.get(OPTION_ReportEmptyStatement)) != null) {
            this.a(524288L, v2);
        }
        if ((v2 = map.get(OPTION_ReportNonExternalizedStringLiteral)) != null) {
            this.a(256L, v2);
        }
        if ((v2 = map.get(OPTION_ReportAssertIdentifier)) != null) {
            this.a(512L, v2);
        }
        if ((v2 = map.get(OPTION_ReportEnumIdentifier)) != null) {
            this.a(0x200000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportNonStaticAccessToStatic)) != null) {
            this.a(2048L, v2);
        }
        if ((v2 = map.get(OPTION_ReportIndirectStaticAccess)) != null) {
            this.a(0x10000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportUndocumentedEmptyBlock)) != null) {
            this.a(0x8000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportUnnecessaryTypeCheck)) != null) {
            this.a(0x4000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportUnnecessaryElse)) != null) {
            this.a(0x20000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportFinallyBlockNotCompletingNormally)) != null) {
            this.a(0x1000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportUnqualifiedFieldAccess)) != null) {
            this.a(0x400000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportNoEffectAssignment)) != null) {
            this.a(8192L, v2);
        }
        if ((v2 = map.get(OPTION_ReportUncheckedTypeOperation)) != null) {
            this.a(0x40000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportRawTypeReference)) != null) {
            this.a(0x200000000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportFinalParameterBound)) != null) {
            this.a(0x80000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportForbiddenReference)) != null) {
            this.a(0x400000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportDiscouragedReference)) != null) {
            this.a(0x80000000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportNullReference)) != null) {
            this.a(0x1000000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportPotentialNullReference)) != null) {
            this.a(0x4000000000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportDuplicateLocalVariables)) != null) {
            this.a(0x200000000000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportRedundantNullCheck)) != null) {
            this.a(0x8000000000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportUninitializedLocalVariable)) != null) {
            this.a(0x400000000000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportUninitializedGlobalVariable)) != null) {
            this.a(0x800000000000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportUnusedLabel)) != null) {
            this.a(0x400000000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportParameterAssignment)) != null) {
            this.a(0x800000000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportFallthroughCase)) != null) {
            this.a(0x1000000000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportOverridingMethodWithoutSuperInvocation)) != null) {
            this.a(0x2000000000000L, v2);
        }
        if ((v2 = map.get(OPTION_Unresolved_Type)) != null) {
            this.a(0x10000000000000L, v2);
        }
        if ((v2 = map.get(OPTION_Unresolved_Field)) != null) {
            this.a(0x40000000000000L, v2);
        }
        if ((v2 = map.get(OPTION_Unresolved_Method)) != null) {
            this.a(0x20000000000000L, v2);
        }
        if ((v2 = map.get(OPTION_OPTIONAL_SEMICOLON)) != null) {
            this.a(0x100000000000000L, v2);
        }
        if ((v2 = map.get(OPTION_LOOSE_VAR_DECL)) != null) {
            this.a(0x80000000000000L, v2);
        }
        if ((v2 = map.get(OPTION_DocCommentSupport)) != null) {
            if (ENABLED.equals(v2)) {
                this.docCommentSupport = true;
            } else if (DISABLED.equals(v2)) {
                this.docCommentSupport = false;
            }
        }
        if ((v2 = map.get(OPTION_ReportInvalidJavadoc)) != null) {
            this.a(0x2000000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportInvalidJavadocTagsVisibility)) != null) {
            if (PUBLIC.equals(v2)) {
                this.reportInvalidJavadocTagsVisibility = 1;
            } else if (PROTECTED.equals(v2)) {
                this.reportInvalidJavadocTagsVisibility = 4;
            } else if (DEFAULT.equals(v2)) {
                this.reportInvalidJavadocTagsVisibility = 0;
            } else if (PRIVATE.equals(v2)) {
                this.reportInvalidJavadocTagsVisibility = 2;
            }
        }
        if ((v2 = map.get(OPTION_ReportInvalidJavadocTags)) != null) {
            if (ENABLED.equals(v2)) {
                this.reportInvalidJavadocTags = true;
            } else if (DISABLED.equals(v2)) {
                this.reportInvalidJavadocTags = false;
            }
        }
        if ((v2 = map.get(OPTION_ReportInvalidJavadocTagsDeprecatedRef)) != null) {
            if (ENABLED.equals(v2)) {
                this.reportInvalidJavadocTagsDeprecatedRef = true;
            } else if (DISABLED.equals(v2)) {
                this.reportInvalidJavadocTagsDeprecatedRef = false;
            }
        }
        if ((v2 = map.get(OPTION_ReportInvalidJavadocTagsNotVisibleRef)) != null) {
            if (ENABLED.equals(v2)) {
                this.reportInvalidJavadocTagsNotVisibleRef = true;
            } else if (DISABLED.equals(v2)) {
                this.reportInvalidJavadocTagsNotVisibleRef = false;
            }
        }
        if ((v2 = map.get(OPTION_ReportMissingJavadocTags)) != null) {
            this.a(0x200000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportMissingJavadocTagsVisibility)) != null) {
            if (PUBLIC.equals(v2)) {
                this.reportMissingJavadocTagsVisibility = 1;
            } else if (PROTECTED.equals(v2)) {
                this.reportMissingJavadocTagsVisibility = 4;
            } else if (DEFAULT.equals(v2)) {
                this.reportMissingJavadocTagsVisibility = 0;
            } else if (PRIVATE.equals(v2)) {
                this.reportMissingJavadocTagsVisibility = 2;
            }
        }
        if ((v2 = map.get(OPTION_ReportMissingJavadocTagsOverriding)) != null) {
            if (ENABLED.equals(v2)) {
                this.reportMissingJavadocTagsOverriding = true;
            } else if (DISABLED.equals(v2)) {
                this.reportMissingJavadocTagsOverriding = false;
            }
        }
        if ((v2 = map.get(OPTION_ReportMissingJavadocComments)) != null) {
            this.a(0x100000L, v2);
        }
        if ((v2 = map.get(OPTION_ReportMissingJavadocCommentsVisibility)) != null) {
            if (PUBLIC.equals(v2)) {
                this.reportMissingJavadocCommentsVisibility = 1;
            } else if (PROTECTED.equals(v2)) {
                this.reportMissingJavadocCommentsVisibility = 4;
            } else if (DEFAULT.equals(v2)) {
                this.reportMissingJavadocCommentsVisibility = 0;
            } else if (PRIVATE.equals(v2)) {
                this.reportMissingJavadocCommentsVisibility = 2;
            }
        }
        if ((v2 = map.get(OPTION_ReportMissingJavadocCommentsOverriding)) != null) {
            if (ENABLED.equals(v2)) {
                this.reportMissingJavadocCommentsOverriding = true;
            } else if (DISABLED.equals(v2)) {
                this.reportMissingJavadocCommentsOverriding = false;
            }
        }
        if ((v2 = map.get(OPTION_GenerateClassFiles)) != null) {
            if (ENABLED.equals(v2)) {
                this.generateClassFiles = true;
            } else if (DISABLED.equals(v2)) {
                this.generateClassFiles = false;
            }
        }
        if ((v2 = map.get(OPTION_Process_Annotations)) != null) {
            if (ENABLED.equals(v2)) {
                this.processAnnotations = true;
                this.storeAnnotations = true;
                this.docCommentSupport = true;
            } else if (DISABLED.equals(v2)) {
                this.processAnnotations = false;
                this.storeAnnotations = false;
            }
        }
        this.inferOptions.set(map);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CompilerOptions:");
        stringBuffer.append("\n\t- local variables debug attributes: ").append((this.produceDebugAttributes & 4) != 0 ? "ON" : " OFF");
        stringBuffer.append("\n\t- line number debug attributes: ").append((this.produceDebugAttributes & 2) != 0 ? "ON" : " OFF");
        stringBuffer.append("\n\t- source debug attributes: ").append((this.produceDebugAttributes & 1) != 0 ? "ON" : " OFF");
        stringBuffer.append("\n\t- preserve all local variables: ").append(this.preserveAllLocalVariables ? "ON" : " OFF");
        stringBuffer.append("\n\t- method with constructor name: ").append(this.getSeverityString(1L));
        stringBuffer.append("\n\t- undefined field: ").append(this.getSeverityString(2L));
        stringBuffer.append("\n\t- deprecation: ").append(this.getSeverityString(4L));
        stringBuffer.append("\n\t- masked catch block: ").append(this.getSeverityString(8L));
        stringBuffer.append("\n\t- unused local variable: ").append(this.getSeverityString(16L));
        stringBuffer.append("\n\t- unused parameter: ").append(this.getSeverityString(32L));
        stringBuffer.append("\n\t- synthetic access emulation: ").append(this.getSeverityString(128L));
        stringBuffer.append("\n\t- assignment with no effect: ").append(this.getSeverityString(8192L));
        stringBuffer.append("\n\t- non externalized string: ").append(this.getSeverityString(256L));
        stringBuffer.append("\n\t- static access receiver: ").append(this.getSeverityString(2048L));
        stringBuffer.append("\n\t- indirect static access: ").append(this.getSeverityString(0x10000000L));
        stringBuffer.append("\n\t- unused private member: ").append(this.getSeverityString(32768L));
        stringBuffer.append("\n\t- local variable hiding another variable: ").append(this.getSeverityString(65536L));
        stringBuffer.append("\n\t- field hiding another variable: ").append(this.getSeverityString(131072L));
        stringBuffer.append("\n\t- type hiding another type: ").append(this.getSeverityString(0x8000000000L));
        stringBuffer.append("\n\t- possible accidental boolean assignment: ").append(this.getSeverityString(262144L));
        stringBuffer.append("\n\t- superfluous semicolon: ").append(this.getSeverityString(524288L));
        stringBuffer.append("\n\t- uncommented empty block: ").append(this.getSeverityString(0x8000000L));
        stringBuffer.append("\n\t- unnecessary type check: ").append(this.getSeverityString(0x4000000L));
        stringBuffer.append("\n\t- javadoc comment support: ").append(this.docCommentSupport ? "ON" : " OFF");
        stringBuffer.append("\n\t\t+ invalid javadoc: ").append(this.getSeverityString(0x2000000L));
        stringBuffer.append("\n\t\t+ report invalid javadoc tags: ").append(this.reportInvalidJavadocTags ? ENABLED : DISABLED);
        stringBuffer.append("\n\t\t\t* deprecated references: ").append(this.reportInvalidJavadocTagsDeprecatedRef ? ENABLED : DISABLED);
        stringBuffer.append("\n\t\t\t* not visible references: ").append(this.reportInvalidJavadocTagsNotVisibleRef ? ENABLED : DISABLED);
        stringBuffer.append("\n\t\t+ visibility level to report invalid javadoc tags: ").append(this.getVisibilityString(this.reportInvalidJavadocTagsVisibility));
        stringBuffer.append("\n\t\t+ missing javadoc tags: ").append(this.getSeverityString(0x200000L));
        stringBuffer.append("\n\t\t+ visibility level to report missing javadoc tags: ").append(this.getVisibilityString(this.reportMissingJavadocTagsVisibility));
        stringBuffer.append("\n\t\t+ report missing javadoc tags in overriding methods: ").append(this.reportMissingJavadocTagsOverriding ? ENABLED : DISABLED);
        stringBuffer.append("\n\t\t+ missing javadoc comments: ").append(this.getSeverityString(0x100000L));
        stringBuffer.append("\n\t\t+ visibility level to report missing javadoc comments: ").append(this.getVisibilityString(this.reportMissingJavadocCommentsVisibility));
        stringBuffer.append("\n\t\t+ report missing javadoc comments in overriding methods: ").append(this.reportMissingJavadocCommentsOverriding ? ENABLED : DISABLED);
        stringBuffer.append("\n\t- finally block not completing normally: ").append(this.getSeverityString(0x1000000L));
        stringBuffer.append("\n\t- unused declared thrown exception: ").append(this.getSeverityString(0x800000L));
        stringBuffer.append("\n\t- unused declared thrown exception when overriding: ").append(this.reportUnusedDeclaredThrownExceptionWhenOverriding ? ENABLED : DISABLED);
        stringBuffer.append("\n\t- unnecessary else: ").append(this.getSeverityString(0x20000000L));
        stringBuffer.append("\n\t- JDK compliance level: " + CompilerOptions.versionFromJdkLevel(this.complianceLevel));
        stringBuffer.append("\n\t- JDK source level: " + CompilerOptions.versionFromJdkLevel(this.sourceLevel));
        stringBuffer.append("\n\t- JDK target level: " + CompilerOptions.versionFromJdkLevel(this.targetJDK));
        stringBuffer.append("\n\t- verbose : ").append(this.verbose ? "ON" : "OFF");
        stringBuffer.append("\n\t- produce reference info : ").append(this.produceReferenceInfo ? "ON" : "OFF");
        stringBuffer.append("\n\t- parse literal expressions as constants : ").append(this.parseLiteralExpressionsAsConstants ? "ON" : "OFF");
        stringBuffer.append("\n\t- encoding : ").append(this.defaultEncoding == null ? "<default>" : this.defaultEncoding);
        stringBuffer.append("\n\t- task tags: ").append(this.taskTags == null ? Util.EMPTY_STRING : new String(CharOperation.concatWith(this.taskTags, ',')));
        stringBuffer.append("\n\t- task priorities : ").append(this.taskPriorites == null ? Util.EMPTY_STRING : new String(CharOperation.concatWith(this.taskPriorites, ',')));
        stringBuffer.append("\n\t- report deprecation inside deprecated code : ").append(this.reportDeprecationInsideDeprecatedCode ? ENABLED : DISABLED);
        stringBuffer.append("\n\t- report deprecation when overriding deprecated method : ").append(this.reportDeprecationWhenOverridingDeprecatedMethod ? ENABLED : DISABLED);
        stringBuffer.append("\n\t- report unused parameter when implementing abstract method : ").append(this.reportUnusedParameterWhenImplementingAbstract ? ENABLED : DISABLED);
        stringBuffer.append("\n\t- report unused parameter when overriding concrete method : ").append(this.reportUnusedParameterWhenOverridingConcrete ? ENABLED : DISABLED);
        stringBuffer.append("\n\t- report unused parameter include doc comment reference : ").append(this.reportUnusedParameterIncludeDocCommentReference ? ENABLED : DISABLED);
        stringBuffer.append("\n\t- report constructor/setter parameter hiding existing field : ").append(this.reportSpecialParameterHidingField ? ENABLED : DISABLED);
        stringBuffer.append("\n\t- inline JSR bytecode : ").append(this.inlineJsrBytecode ? ENABLED : DISABLED);
        stringBuffer.append("\n\t- unsafe type operation: ").append(this.getSeverityString(0x40000000L));
        stringBuffer.append("\n\t- unsafe raw type: ").append(this.getSeverityString(0x200000000000L));
        stringBuffer.append("\n\t- final bound for type parameter: ").append(this.getSeverityString(0x80000000L));
        stringBuffer.append("\n\t- forbidden reference to type with access restriction: ").append(this.getSeverityString(0x400000000L));
        stringBuffer.append("\n\t- discouraged reference to type with access restriction: ").append(this.getSeverityString(0x80000000000L));
        stringBuffer.append("\n\t- null reference: ").append(this.getSeverityString(0x1000000000L));
        stringBuffer.append("\n\t- potential null reference: ").append(this.getSeverityString(0x4000000000000L));
        stringBuffer.append("\n\t- duplicate local variables: ").append(this.getSeverityString(0x200000000000000L));
        stringBuffer.append("\n\t- redundant null check: ").append(this.getSeverityString(0x8000000000000L));
        stringBuffer.append("\n\t- uninitialized local variable: ").append(this.getSeverityString(0x400000000000000L));
        stringBuffer.append("\n\t- uninitialized global variable: ").append(this.getSeverityString(0x800000000000000L));
        stringBuffer.append("\n\t- suppress warnings: ").append(this.suppressWarnings ? ENABLED : DISABLED);
        stringBuffer.append("\n\t- unused label: ").append(this.getSeverityString(0x400000000000L));
        stringBuffer.append("\n\t- treat optional error as fatal: ").append(this.treatOptionalErrorAsFatal ? ENABLED : DISABLED);
        stringBuffer.append("\n\t- parameter assignment: ").append(this.getSeverityString(0x800000000000L));
        stringBuffer.append("\n\t- generate class files: ").append(this.generateClassFiles ? ENABLED : DISABLED);
        stringBuffer.append("\n\t- process annotations: ").append(this.processAnnotations ? ENABLED : DISABLED);
        return stringBuffer.toString();
    }

    void a(long l2, Object object) {
        if (ERROR.equals(object)) {
            this.errorThreshold |= l2;
            this.warningThreshold &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (WARNING.equals(object)) {
            this.errorThreshold &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            this.warningThreshold |= l2;
        } else if (IGNORE.equals(object)) {
            this.errorThreshold &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            this.warningThreshold &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public static long versionToJdkLevel(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 3 && string.charAt(0) == '1' && string.charAt(1) == '.') {
                switch (string.charAt(2)) {
                    case '1': {
                        return 2949123L;
                    }
                    case '2': {
                        return 0x2E0000L;
                    }
                    case '3': {
                        return 0x2F0000L;
                    }
                    case '4': {
                        return 0x300000L;
                    }
                    case '5': {
                        return 0x310000L;
                    }
                    case '6': {
                        return 0x320000L;
                    }
                    case '7': {
                        return 0x330000L;
                    }
                }
                return 0L;
            }
            if (VERSION_JSR14.equals(object)) {
                return 0x300000L;
            }
        }
        return 0L;
    }

    public static String versionFromJdkLevel(long l2) {
        switch ((int)(l2 >> 16)) {
            case 45: {
                if (l2 != 2949123L) break;
                return VERSION_1_1;
            }
            case 46: {
                if (l2 != 0x2E0000L) break;
                return VERSION_1_2;
            }
            case 47: {
                if (l2 != 0x2F0000L) break;
                return VERSION_1_3;
            }
            case 48: {
                if (l2 != 0x300000L) break;
                return VERSION_1_4;
            }
            case 49: {
                if (l2 != 0x310000L) break;
                return VERSION_1_5;
            }
            case 50: {
                if (l2 != 0x320000L) break;
                return VERSION_1_6;
            }
            case 51: {
                if (l2 != 0x330000L) break;
                return VERSION_1_7;
            }
        }
        return Util.EMPTY_STRING;
    }

    public static String[] warningOptionNames() {
        String[] stringArray = new String[]{OPTION_ReportAssertIdentifier, OPTION_ReportDeprecation, OPTION_ReportDiscouragedReference, OPTION_ReportEmptyStatement, OPTION_ReportEnumIdentifier, OPTION_ReportFallthroughCase, OPTION_ReportFieldHiding, OPTION_ReportFinalParameterBound, OPTION_ReportFinallyBlockNotCompletingNormally, OPTION_ReportForbiddenReference, OPTION_ReportHiddenCatchBlock, OPTION_ReportIndirectStaticAccess, OPTION_ReportInvalidJavadoc, OPTION_ReportLocalVariableHiding, OPTION_ReportMethodWithConstructorName, OPTION_ReportMissingJavadocComments, OPTION_ReportMissingJavadocTags, OPTION_ReportNoEffectAssignment, OPTION_ReportNonExternalizedStringLiteral, OPTION_ReportNonStaticAccessToStatic, OPTION_ReportNullReference, OPTION_ReportPotentialNullReference, OPTION_ReportDuplicateLocalVariables, OPTION_ReportRedundantNullCheck, OPTION_ReportUninitializedLocalVariable, OPTION_ReportUninitializedGlobalVariable, OPTION_ReportUndefinedField, OPTION_ReportParameterAssignment, OPTION_ReportPossibleAccidentalBooleanAssignment, OPTION_ReportWrongNumberOfArguments, OPTION_ReportTypeParameterHiding, OPTION_ReportUncheckedTypeOperation, OPTION_ReportUndocumentedEmptyBlock, OPTION_ReportUnnecessaryElse, OPTION_ReportUnnecessaryTypeCheck, OPTION_ReportUnqualifiedFieldAccess, OPTION_ReportUnusedDeclaredThrownException, OPTION_ReportUnusedLocal, OPTION_ReportUnusedParameter, OPTION_ReportUnusedPrivateMember, OPTION_ReportOverridingMethodWithoutSuperInvocation};
        return stringArray;
    }

    public static String warningTokenFromIrritant(long l2) {
        int n2 = (int)l2;
        if ((long)n2 == l2) {
            switch (n2) {
                case 4: 
                case 0x2000004: {
                    return "deprecation";
                }
                case 0x1000000: {
                    return "finally";
                }
                case 8: 
                case 65536: 
                case 131072: {
                    return "hiding";
                }
                case 256: {
                    return "nls";
                }
                case 0x4000000: {
                    return "cast";
                }
                case 16: 
                case 32: 
                case 32768: 
                case 0x800000: {
                    return "unused";
                }
                case 2048: 
                case 0x10000000: {
                    return "static-access";
                }
                case 128: {
                    return "synthetic-access";
                }
                case 0x400000: {
                    return "unqualified-field-access";
                }
                case 0x40000000: {
                    return "unchecked";
                }
            }
        } else {
            n2 = (int)(l2 >>> 32);
            switch (n2) {
                case 128: {
                    return "hiding";
                }
                case 8192: {
                    return "unchecked";
                }
                case 16384: {
                    return "unused";
                }
                case 4: 
                case 2048: {
                    return "restriction";
                }
                case 16: 
                case 262144: 
                case 524288: {
                    return "null";
                }
                case 65536: {
                    return "fallthrough";
                }
                case 131072: {
                    return "super";
                }
                case 0x4000000: {
                    return "uninitializedLocalVariable";
                }
                case 0x8000000: {
                    return "uninitializedGlobalVariable";
                }
            }
        }
        return null;
    }

    public static long warningTokenToIrritant(String string) {
        if (string == null || string.length() == 0) {
            return 0L;
        }
        switch (string.charAt(0)) {
            case 'a': {
                if (!"all".equals(string)) break;
                return -1L;
            }
            case 'c': {
                if (!"cast".equals(string)) break;
                return 0x4000000L;
            }
            case 'd': {
                if (!"deprecation".equals(string)) break;
                return 4L;
            }
            case 'f': {
                if ("fallthrough".equals(string)) {
                    return 0x1000000000000L;
                }
                if (!"finally".equals(string)) break;
                return 0x1000000L;
            }
            case 'h': {
                if (!"hiding".equals(string)) break;
                return 0x8000030008L;
            }
            case 'n': {
                if ("nls".equals(string)) {
                    return 256L;
                }
                if (!"null".equals(string)) break;
                return 0xC001000000000L;
            }
            case 'r': {
                if (!"restriction".equals(string)) break;
                return 0x80400000000L;
            }
            case 's': {
                if ("static-access".equals(string)) {
                    return 0x10000800L;
                }
                if ("synthetic-access".equals(string)) {
                    return 128L;
                }
                if (!"super".equals(string)) break;
                return 0x2000000000000L;
            }
            case 'u': {
                if ("unused".equals(string)) {
                    return 70368752599088L;
                }
                if ("unchecked".equals(string)) {
                    return 0x200040000000L;
                }
                if ("unqualified-field-access".equals(string)) {
                    return 0x400000L;
                }
                if ("uninitializedLocalVariable".equals(string)) {
                    return 0x400000000000000L;
                }
                if (!"uninitializedGlobalVariable".equals(string)) break;
                return 0x800000000000000L;
            }
        }
        return 0L;
    }
}

