/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.flow;

import org.ccdt.jsdt.internal.compiler.ast.ASTNode;
import org.ccdt.jsdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.ccdt.jsdt.internal.compiler.lookup.Binding;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;

public class InitializationFlowContext
extends ExceptionHandlingFlowContext {
    public int exceptionCount;
    public TypeBinding[] thrownExceptions = new TypeBinding[5];
    public ASTNode[] exceptionThrowers = new ASTNode[5];
    public FlowInfo[] exceptionThrowerFlowInfos = new FlowInfo[5];

    public InitializationFlowContext(FlowContext flowContext, ASTNode aSTNode, BlockScope blockScope) {
        super(flowContext, aSTNode, Binding.NO_EXCEPTIONS, blockScope, FlowInfo.DEAD_END);
    }

    public void checkInitializerExceptions(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        int n2 = 0;
        while (n2 < this.exceptionCount) {
            flowContext.checkExceptionHandlers(this.thrownExceptions[n2], this.exceptionThrowers[n2], this.exceptionThrowerFlowInfos[n2], blockScope);
            ++n2;
        }
    }

    @Override
    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Initialization flow context");
        int n2 = 0;
        while (n2 < this.exceptionCount) {
            stringBuffer.append('[').append(this.thrownExceptions[n2].readableName());
            stringBuffer.append('-').append(this.exceptionThrowerFlowInfos[n2].toString()).append(']');
            ++n2;
        }
        return stringBuffer.toString();
    }

    @Override
    public void recordHandlingException(ReferenceBinding referenceBinding, UnconditionalFlowInfo unconditionalFlowInfo, TypeBinding typeBinding, ASTNode aSTNode, boolean bl2) {
        int n2 = this.thrownExceptions.length;
        if (this.exceptionCount == n2) {
            this.thrownExceptions = new TypeBinding[n2 * 2];
            System.arraycopy(this.thrownExceptions, 0, this.thrownExceptions, 0, n2);
            this.exceptionThrowers = new ASTNode[n2 * 2];
            System.arraycopy(this.exceptionThrowers, 0, this.exceptionThrowers, 0, n2);
            this.exceptionThrowerFlowInfos = new FlowInfo[n2 * 2];
            System.arraycopy(this.exceptionThrowerFlowInfos, 0, this.exceptionThrowerFlowInfos, 0, n2);
        }
        this.thrownExceptions[this.exceptionCount] = typeBinding;
        this.exceptionThrowers[this.exceptionCount] = aSTNode;
        this.exceptionThrowerFlowInfos[this.exceptionCount++] = unconditionalFlowInfo.copy();
    }
}

