/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.flow;

import org.ccdt.jsdt.core.compiler.CharOperation;
import org.ccdt.jsdt.internal.compiler.ast.ASTNode;
import org.ccdt.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.LabeledStatement;
import org.ccdt.jsdt.internal.compiler.ast.Reference;
import org.ccdt.jsdt.internal.compiler.ast.SubRoutineStatement;
import org.ccdt.jsdt.internal.compiler.ast.TryStatement;
import org.ccdt.jsdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.ccdt.jsdt.internal.compiler.flow.NullInfoRegistry;
import org.ccdt.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.ccdt.jsdt.internal.compiler.lookup.Binding;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.ccdt.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.ccdt.jsdt.internal.compiler.lookup.Scope;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;
import org.ccdt.jsdt.internal.compiler.lookup.TypeConstants;
import org.ccdt.jsdt.internal.compiler.lookup.VariableBinding;

public class FlowContext
implements TypeConstants {
    public static final FlowContext NotContinuableContext = new FlowContext(null, null);
    public ASTNode associatedNode;
    public FlowContext parent;
    public NullInfoRegistry initsOnFinally;
    boolean h;
    boolean i;
    public static final int CAN_ONLY_NULL_NON_NULL = 0;
    public static final int CAN_ONLY_NULL = 1;
    public static final int CAN_ONLY_NON_NULL = 2;
    public static final int MAY_NULL = 3;
    public static final int CHECK_MASK = 255;
    public static final int IN_COMPARISON_NULL = 256;
    public static final int IN_COMPARISON_NON_NULL = 512;
    public static final int IN_ASSIGNMENT = 768;
    public static final int IN_INSTANCEOF = 1024;
    public static final int CONTEXT_MASK = -256;

    public FlowContext(FlowContext flowContext, ASTNode aSTNode) {
        this.parent = flowContext;
        this.associatedNode = aSTNode;
        if (flowContext != null) {
            this.h = flowContext.h || flowContext.i;
            this.initsOnFinally = flowContext.initsOnFinally;
        }
    }

    public void checkExceptionHandlers(TypeBinding typeBinding, ASTNode aSTNode, FlowInfo flowInfo, BlockScope blockScope) {
        FlowContext flowContext = this;
        while (flowContext != null) {
            Object object;
            TypeConstants typeConstants;
            SubRoutineStatement subRoutineStatement = flowContext.subroutine();
            if (subRoutineStatement != null && subRoutineStatement.isSubRoutineEscaping()) {
                return;
            }
            if (flowContext instanceof ExceptionHandlingFlowContext) {
                typeConstants = (ExceptionHandlingFlowContext)flowContext;
                object = ((ExceptionHandlingFlowContext)typeConstants).handledExceptions;
                if (((ExceptionHandlingFlowContext)typeConstants).handledExceptions != Binding.NO_EXCEPTIONS) {
                    boolean bl2 = false;
                    int n2 = 0;
                    int n3 = ((ReferenceBinding[])object).length;
                    while (n2 < n3) {
                        ReferenceBinding referenceBinding = object[n2];
                        int n4 = referenceBinding == null ? -1 : Scope.compareTypes(typeBinding, referenceBinding);
                        switch (n4) {
                            case -1: {
                                ((ExceptionHandlingFlowContext)typeConstants).recordHandlingException(referenceBinding, flowInfo.unconditionalInits(), typeBinding, aSTNode, bl2);
                                bl2 = true;
                                break;
                            }
                            case 1: {
                                ((ExceptionHandlingFlowContext)typeConstants).recordHandlingException(referenceBinding, flowInfo.unconditionalInits(), typeBinding, aSTNode, false);
                            }
                        }
                        ++n2;
                    }
                    if (bl2) {
                        return;
                    }
                }
                if (((ExceptionHandlingFlowContext)typeConstants).e) {
                    AbstractMethodDeclaration abstractMethodDeclaration;
                    if (typeBinding.isUncheckedException(false)) {
                        return;
                    }
                    if (!(((ExceptionHandlingFlowContext)typeConstants).associatedNode instanceof AbstractMethodDeclaration) || !(abstractMethodDeclaration = (AbstractMethodDeclaration)((ExceptionHandlingFlowContext)typeConstants).associatedNode).isConstructor() || !abstractMethodDeclaration.getBinding().declaringClass.isAnonymousType()) break;
                    ((ExceptionHandlingFlowContext)typeConstants).mergeUnhandledException(typeBinding);
                    return;
                }
            }
            flowContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (flowContext instanceof InsideSubRoutineFlowContext && (typeConstants = flowContext.associatedNode) instanceof TryStatement) {
                object = (TryStatement)typeConstants;
                flowInfo.addInitializationsFrom(object.subRoutineInits);
            }
            flowContext = flowContext.parent;
        }
    }

    public void checkExceptionHandlers(TypeBinding[] typeBindingArray, ASTNode aSTNode, FlowInfo flowInfo, BlockScope blockScope) {
        Object object;
        int n2;
        if (typeBindingArray == null || (n2 = typeBindingArray.length) == 0) {
            return;
        }
        int n3 = n2;
        TypeBinding[] typeBindingArray2 = typeBindingArray;
        typeBindingArray = new TypeBinding[n2];
        System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n2);
        FlowContext flowContext = this;
        while (flowContext != null) {
            Object object2;
            SubRoutineStatement subRoutineStatement = flowContext.subroutine();
            if (subRoutineStatement != null && subRoutineStatement.isSubRoutineEscaping()) {
                return;
            }
            if (flowContext instanceof ExceptionHandlingFlowContext) {
                Object object3;
                int n4;
                object = (ExceptionHandlingFlowContext)flowContext;
                object2 = ((ExceptionHandlingFlowContext)object).handledExceptions;
                if (((ExceptionHandlingFlowContext)object).handledExceptions != Binding.NO_EXCEPTIONS) {
                    n4 = ((ReferenceBinding[])object2).length;
                    object3 = new boolean[n2];
                    int n5 = 0;
                    while (n5 < n4) {
                        ReferenceBinding referenceBinding = object2[n5];
                        int n6 = 0;
                        while (n6 < n2) {
                            TypeBinding typeBinding = typeBindingArray[n6];
                            if (typeBinding != null) {
                                int n7 = referenceBinding == null ? -1 : Scope.compareTypes(typeBinding, referenceBinding);
                                switch (n7) {
                                    case -1: {
                                        ((ExceptionHandlingFlowContext)object).recordHandlingException(referenceBinding, flowInfo.unconditionalInits(), typeBinding, aSTNode, (boolean)object3[n6]);
                                        if (object3[n6] != false) break;
                                        object3[n6] = true;
                                        --n3;
                                        break;
                                    }
                                    case 1: {
                                        ((ExceptionHandlingFlowContext)object).recordHandlingException(referenceBinding, flowInfo.unconditionalInits(), typeBinding, aSTNode, false);
                                    }
                                }
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                    n5 = 0;
                    while (n5 < n2) {
                        if (object3[n5] != false) {
                            typeBindingArray[n5] = null;
                        }
                        ++n5;
                    }
                }
                if (((ExceptionHandlingFlowContext)object).e) {
                    AbstractMethodDeclaration abstractMethodDeclaration;
                    n4 = 0;
                    while (n4 < n2) {
                        TypeBinding typeBinding = typeBindingArray[n4];
                        object3 = typeBinding;
                        if (typeBinding != null && ((TypeBinding)object3).isUncheckedException(false)) {
                            --n3;
                            typeBindingArray[n4] = null;
                        }
                        ++n4;
                    }
                    if (!(((ExceptionHandlingFlowContext)object).associatedNode instanceof AbstractMethodDeclaration) || !(abstractMethodDeclaration = (AbstractMethodDeclaration)((ExceptionHandlingFlowContext)object).associatedNode).isConstructor() || !abstractMethodDeclaration.getBinding().declaringClass.isAnonymousType()) break;
                    int n8 = 0;
                    while (n8 < n2) {
                        TypeBinding typeBinding = typeBindingArray[n8];
                        if (typeBinding != null) {
                            ((ExceptionHandlingFlowContext)object).mergeUnhandledException(typeBinding);
                        }
                        ++n8;
                    }
                    return;
                }
            }
            if (n3 == 0) {
                return;
            }
            flowContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (flowContext instanceof InsideSubRoutineFlowContext && (object = flowContext.associatedNode) instanceof TryStatement) {
                object2 = (TryStatement)object;
                flowInfo.addInitializationsFrom(object2.subRoutineInits);
            }
            flowContext = flowContext.parent;
        }
        int n9 = 0;
        while (n9 < n2) {
            object = typeBindingArray[n9];
            if (object != null) {
                int n10 = 0;
                while (n10 < n9) {
                    if (typeBindingArray[n10] == object) break;
                    ++n10;
                }
            }
            ++n9;
        }
    }

    public FlowContext getTargetContextForBreakLabel(char[] cArray) {
        FlowContext flowContext = this;
        FlowContext flowContext2 = null;
        while (flowContext != null) {
            char[] cArray2;
            if (flowContext.isNonReturningContext()) {
                flowContext2 = flowContext;
            }
            if ((cArray2 = flowContext.labelName()) != null && CharOperation.equals(cArray2, cArray)) {
                ((LabeledStatement)flowContext.associatedNode).bits |= 0x40;
                if (flowContext2 == null) {
                    return flowContext;
                }
                return flowContext2;
            }
            flowContext = flowContext.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForContinueLabel(char[] cArray) {
        FlowContext flowContext = this;
        FlowContext flowContext2 = null;
        FlowContext flowContext3 = null;
        while (flowContext != null) {
            if (flowContext.isNonReturningContext()) {
                flowContext3 = flowContext;
            } else if (flowContext.isContinuable()) {
                flowContext2 = flowContext;
            }
            char[] cArray2 = flowContext.labelName();
            if (cArray2 != null && CharOperation.equals(cArray2, cArray)) {
                ((LabeledStatement)flowContext.associatedNode).bits |= 0x40;
                if (flowContext2 != null && flowContext.associatedNode.concreteStatement() == flowContext2.associatedNode) {
                    if (flowContext3 == null) {
                        return flowContext2;
                    }
                    return flowContext3;
                }
                return NotContinuableContext;
            }
            flowContext = flowContext.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultBreak() {
        FlowContext flowContext = this;
        FlowContext flowContext2 = null;
        while (flowContext != null) {
            if (flowContext.isNonReturningContext()) {
                flowContext2 = flowContext;
            }
            if (flowContext.isBreakable() && flowContext.labelName() == null) {
                if (flowContext2 == null) {
                    return flowContext;
                }
                return flowContext2;
            }
            flowContext = flowContext.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultContinue() {
        FlowContext flowContext = this;
        FlowContext flowContext2 = null;
        while (flowContext != null) {
            if (flowContext.isNonReturningContext()) {
                flowContext2 = flowContext;
            }
            if (flowContext.isContinuable()) {
                if (flowContext2 == null) {
                    return flowContext;
                }
                return flowContext2;
            }
            flowContext = flowContext.parent;
        }
        return null;
    }

    public String individualToString() {
        return "Flow context";
    }

    public FlowInfo initsOnBreak() {
        return FlowInfo.DEAD_END;
    }

    public UnconditionalFlowInfo initsOnReturn() {
        return FlowInfo.DEAD_END;
    }

    public boolean isBreakable() {
        return false;
    }

    public boolean isContinuable() {
        return false;
    }

    public boolean isNonReturningContext() {
        return false;
    }

    public boolean isSubRoutine() {
        return false;
    }

    public char[] labelName() {
        return null;
    }

    public void recordBreakFrom(FlowInfo flowInfo) {
    }

    public void recordBreakTo(FlowContext flowContext) {
    }

    public void recordContinueFrom(FlowContext flowContext, FlowInfo flowInfo) {
    }

    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        return true;
    }

    protected void recordNullReference(LocalVariableBinding localVariableBinding, Expression expression, int n2) {
    }

    public void recordReturnFrom(UnconditionalFlowInfo unconditionalFlowInfo) {
    }

    public void recordSettingFinal(VariableBinding variableBinding, Reference reference, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            FlowContext flowContext = this;
            while (flowContext != null) {
                if (!flowContext.recordFinalAssignment(variableBinding, reference)) break;
                flowContext = flowContext.parent;
            }
        }
    }

    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, Expression expression, int n2, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0 || flowInfo.isDefinitelyUnknown(localVariableBinding)) {
            return;
        }
        switch (n2) {
            case 256: 
            case 512: {
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    if (n2 == 512) {
                        scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, expression);
                    } else {
                        scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, expression);
                    }
                    return;
                }
                if (flowInfo.cannotBeDefinitelyNullOrNonNull(localVariableBinding)) {
                    return;
                }
            }
            case 257: 
            case 513: 
            case 769: 
            case 1025: {
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    switch (n2 & 0xFFFFFF00) {
                        case 256: {
                            scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                            return;
                        }
                        case 512: {
                            scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                            return;
                        }
                        case 768: {
                            scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                            return;
                        }
                        case 1024: {
                            scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                            return;
                        }
                    }
                    break;
                }
                if (!flowInfo.cannotBeDefinitelyNullOrNonNull(localVariableBinding)) break;
                return;
            }
            case 3: {
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                    return;
                }
                if (!flowInfo.isPotentiallyNull(localVariableBinding)) break;
                scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                return;
            }
        }
        if (this.parent != null) {
            this.parent.recordUsingNullReference(scope, localVariableBinding, expression, n2, flowInfo);
        }
    }

    public SubRoutineStatement subroutine() {
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        FlowContext flowContext = this;
        int n2 = 0;
        while ((flowContext = flowContext.parent) != null) {
            ++n2;
        }
        FlowContext[] flowContextArray = new FlowContext[n2 + 1];
        flowContext = this;
        int n3 = n2;
        while (n3 >= 0) {
            flowContextArray[n3--] = flowContext;
            flowContext = flowContext.parent;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n4) {
                stringBuffer.append('\t');
                ++n5;
            }
            stringBuffer.append(flowContextArray[n4].individualToString()).append('\n');
            ++n4;
        }
        stringBuffer.append('*');
        n4 = 0;
        while (n4 < n2 + 1) {
            stringBuffer.append('\t');
            ++n4;
        }
        stringBuffer.append(this.individualToString()).append('\n');
        return stringBuffer.toString();
    }
}

