/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.env;

import org.ccdt.jsdt.core.compiler.CharOperation;
import org.ccdt.jsdt.internal.compiler.env.AccessRestriction;
import org.ccdt.jsdt.internal.compiler.env.AccessRule;

public class AccessRuleSet {
    private AccessRule[] a;
    public String[] messageTemplates;
    public static final int MESSAGE_TEMPLATES_LENGTH = 4;

    public AccessRuleSet(AccessRule[] accessRuleArray, String[] stringArray) {
        this.a = accessRuleArray;
        this.messageTemplates = stringArray != null && stringArray.length == 4 ? stringArray : new String[]{"{0}", "{0}", "{0} {1}", "{0} {1}"};
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccessRuleSet)) {
            return false;
        }
        AccessRuleSet accessRuleSet = (AccessRuleSet)object;
        if (this.messageTemplates.length != 4 || accessRuleSet.messageTemplates.length != 4) {
            return false;
        }
        int n2 = 0;
        while (n2 < 4) {
            if (!this.messageTemplates[n2].equals(accessRuleSet.messageTemplates[n2])) {
                return false;
            }
            ++n2;
        }
        n2 = this.a.length;
        if (n2 != accessRuleSet.a.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (!this.a[n3].equals(accessRuleSet.a[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public AccessRule[] getAccessRules() {
        return this.a;
    }

    public AccessRestriction getViolatedRestriction(char[] cArray) {
        int n2 = 0;
        int n3 = this.a.length;
        while (n2 < n3) {
            AccessRule accessRule = this.a[n2];
            if (CharOperation.pathMatch(accessRule.pattern, cArray, true, '/')) {
                switch (accessRule.getProblemId()) {
                    case 0x1000118: 
                    case 0x1000133: {
                        return new AccessRestriction(accessRule, this.messageTemplates);
                    }
                }
                return null;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("AccessRuleSet {");
        if (bl2) {
            stringBuffer.append('\n');
        }
        int n2 = 0;
        int n3 = this.a.length;
        while (n2 < n3) {
            if (bl2) {
                stringBuffer.append('\t');
            }
            AccessRule accessRule = this.a[n2];
            stringBuffer.append(accessRule);
            if (bl2) {
                stringBuffer.append('\n');
            } else if (n2 < n3 - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("} [templates:\"");
        n2 = 0;
        while (n2 < this.messageTemplates.length) {
            stringBuffer.append(this.messageTemplates[n2]);
            ++n2;
        }
        stringBuffer.append("\"]");
        return stringBuffer.toString();
    }
}

