/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.ast;

import org.ccdt.jsdt.core.a.ae;
import org.ccdt.jsdt.core.a.cs;
import org.ccdt.jsdt.internal.compiler.ASTVisitor;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.OperatorExpression;
import org.ccdt.jsdt.internal.compiler.ast.SingleNameReference;
import org.ccdt.jsdt.internal.compiler.flow.FlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.impl.BooleanConstant;
import org.ccdt.jsdt.internal.compiler.impl.Constant;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;

public class UnaryExpression
extends OperatorExpression
implements cs {
    public Expression expression;
    public Constant optimizedBooleanConstant;

    public UnaryExpression(Expression expression, int n2) {
        this.expression = expression;
        this.bits |= n2 << 6;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.expression.checkNPE(blockScope, flowContext, flowInfo);
        if ((this.bits & 0xFC0) >> 6 == 11) {
            return this.expression.analyseCode(blockScope, flowContext, flowInfo).asNegatedCondition();
        }
        return this.expression.analyseCode(blockScope, flowContext, flowInfo);
    }

    @Override
    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? (this.constant == null ? Constant.NotAConstant : this.constant) : this.optimizedBooleanConstant;
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int n2, StringBuffer stringBuffer) {
        stringBuffer.append(this.operatorToString()).append(' ');
        return this.expression.printExpression(0, stringBuffer);
    }

    @Override
    public final int getOperator() {
        return (this.bits & 0xFC0) >> 6;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding = null;
        typeBinding = this.getOperator() == 22 && this.expression instanceof SingleNameReference ? TypeBinding.UNKNOWN : this.expression.resolveType(blockScope);
        if (typeBinding == null) {
            this.constant = Constant.NotAConstant;
            return null;
        }
        int n2 = typeBinding.id;
        if (n2 > 15) {
            n2 = 1;
        }
        int n3 = -1;
        int n4 = (this.bits & 0xFC0) >> 6;
        switch (n4) {
            case 11: {
                this.resolvedType = TypeBinding.BOOLEAN;
                break;
            }
            case 12: {
                n3 = 10;
                break;
            }
            case 22: {
                this.resolvedType = blockScope.getJavaLangString();
                break;
            }
            case 21: {
                this.resolvedType = TypeBinding.VOID;
                break;
            }
            default: {
                n3 = 13;
            }
        }
        if (n3 > -1) {
            int n5 = OperatorSignatures[n3][(n2 << 4) + n2];
            this.bits |= n5 & 0xF;
            switch (n5 & 0xF) {
                case 5: {
                    this.resolvedType = TypeBinding.BOOLEAN;
                    break;
                }
                case 2: {
                    this.resolvedType = TypeBinding.CHAR;
                    break;
                }
                case 8: {
                    this.resolvedType = TypeBinding.DOUBLE;
                    break;
                }
                case 9: {
                    this.resolvedType = TypeBinding.FLOAT;
                    break;
                }
                case 10: {
                    this.resolvedType = blockScope.getJavaLangNumber();
                    break;
                }
                case 7: {
                    this.resolvedType = TypeBinding.LONG;
                    break;
                }
                case 13: {
                    this.resolvedType = TypeBinding.UNKNOWN;
                    break;
                }
                default: {
                    this.constant = Constant.NotAConstant;
                    if (n2 != 0) {
                        blockScope.problemReporter().invalidOperator(this, typeBinding);
                    }
                    return null;
                }
            }
        }
        if (this.expression.constant != Constant.NotAConstant) {
            this.constant = Constant.computeConstantOperation(this.expression.constant, n2, n4);
        } else {
            Constant constant;
            this.constant = Constant.NotAConstant;
            if (n4 == 11 && (constant = this.expression.optimizedBooleanConstant()) != Constant.NotAConstant) {
                this.optimizedBooleanConstant = BooleanConstant.fromValue(!constant.booleanValue());
            }
        }
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 110;
    }

    public ae getExpression() {
        return this.expression;
    }
}

