/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.ast;

import org.ccdt.jsdt.core.a.cr;
import org.ccdt.jsdt.core.compiler.CharOperation;
import org.ccdt.jsdt.internal.compiler.ASTVisitor;
import org.ccdt.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.SingleTypeReference;
import org.ccdt.jsdt.internal.compiler.flow.FlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.impl.Constant;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.ClassScope;
import org.ccdt.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.ccdt.jsdt.internal.compiler.lookup.Scope;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;

public abstract class TypeReference
extends Expression
implements cr {
    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public void aboutToResolve(Scope scope) {
    }

    public static final TypeReference baseTypeReference(int n2, int n3) {
        if (n3 == 0) {
            switch (n2) {
                case 6: {
                    return new SingleTypeReference(TypeBinding.VOID.simpleName, 0L);
                }
                case 5: {
                    return new SingleTypeReference(TypeBinding.BOOLEAN.simpleName, 0L);
                }
                case 2: {
                    return new SingleTypeReference(TypeBinding.CHAR.simpleName, 0L);
                }
                case 9: {
                    return new SingleTypeReference(TypeBinding.FLOAT.simpleName, 0L);
                }
                case 8: {
                    return new SingleTypeReference(TypeBinding.DOUBLE.simpleName, 0L);
                }
                case 4: {
                    return new SingleTypeReference(TypeBinding.SHORT.simpleName, 0L);
                }
                case 10: {
                    return new SingleTypeReference(TypeBinding.INT.simpleName, 0L);
                }
            }
            return new SingleTypeReference(TypeBinding.LONG.simpleName, 0L);
        }
        switch (n2) {
            case 6: {
                return new ArrayTypeReference(TypeBinding.VOID.simpleName, n3, 0L);
            }
            case 5: {
                return new ArrayTypeReference(TypeBinding.BOOLEAN.simpleName, n3, 0L);
            }
            case 2: {
                return new ArrayTypeReference(TypeBinding.CHAR.simpleName, n3, 0L);
            }
            case 9: {
                return new ArrayTypeReference(TypeBinding.FLOAT.simpleName, n3, 0L);
            }
            case 8: {
                return new ArrayTypeReference(TypeBinding.DOUBLE.simpleName, n3, 0L);
            }
            case 4: {
                return new ArrayTypeReference(TypeBinding.SHORT.simpleName, n3, 0L);
            }
            case 10: {
                return new ArrayTypeReference(TypeBinding.INT.simpleName, n3, 0L);
            }
        }
        return new ArrayTypeReference(TypeBinding.LONG.simpleName, n3, 0L);
    }

    public abstract TypeReference copyDims(int var1);

    public int dimensions() {
        return 0;
    }

    public abstract char[] getLastToken();

    protected abstract TypeBinding getTypeBinding(Scope var1);

    public abstract char[][] getTypeName();

    public char[] getSimpleTypeName() {
        char[][] cArray = this.getTypeName();
        return cArray[cArray.length - 1];
    }

    public char[] getFullTypeName() {
        char[][] cArray = this.getTypeName();
        return CharOperation.concatWith(cArray, '.');
    }

    @Override
    public boolean isTypeReference() {
        return true;
    }

    public TypeBinding resolveSuperType(ClassScope classScope) {
        if (this.resolveType(classScope) == null) {
            return null;
        }
        return this.resolvedType;
    }

    @Override
    public final TypeBinding resolveType(BlockScope blockScope) {
        return this.resolveType(blockScope, true);
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl2) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        this.resolvedType = this.getTypeBinding(blockScope);
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return null;
        }
        if (!typeBinding.isValidBinding()) {
            this.reportInvalidType(blockScope);
            return null;
        }
        if (this.isTypeUseDeprecated(typeBinding, blockScope)) {
            this.reportDeprecatedType(typeBinding, blockScope);
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    @Override
    public TypeBinding resolveType(ClassScope classScope) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        this.resolvedType = this.getTypeBinding(classScope);
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return null;
        }
        if (!typeBinding.isValidBinding()) {
            this.reportInvalidType(classScope);
            return null;
        }
        if (this.isTypeUseDeprecated(typeBinding, classScope)) {
            this.reportDeprecatedType(typeBinding, classScope);
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    public TypeBinding resolveTypeArgument(BlockScope blockScope, ReferenceBinding referenceBinding, int n2) {
        return this.resolveType(blockScope, true);
    }

    public TypeBinding resolveTypeArgument(ClassScope classScope, ReferenceBinding referenceBinding, int n2) {
        return this.resolveType(classScope);
    }

    protected void reportInvalidType(Scope scope) {
        scope.problemReporter().invalidType(this, this.resolvedType);
    }

    protected void reportDeprecatedType(TypeBinding typeBinding, Scope scope) {
        scope.problemReporter().deprecatedType(typeBinding, this);
    }

    @Override
    public abstract void traverse(ASTVisitor var1, BlockScope var2);

    @Override
    public abstract void traverse(ASTVisitor var1, ClassScope var2);

    @Override
    public int getASTType() {
        return 109;
    }
}

