/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.ast;

import org.ccdt.jsdt.core.a.ch;
import org.ccdt.jsdt.internal.compiler.ASTVisitor;
import org.ccdt.jsdt.internal.compiler.ast.ExtendedStringLiteral;
import org.ccdt.jsdt.internal.compiler.ast.Literal;
import org.ccdt.jsdt.internal.compiler.ast.StringLiteralConcatenation;
import org.ccdt.jsdt.internal.compiler.impl.StringConstant;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;

public class StringLiteral
extends Literal
implements ch {
    char[] c;
    int d;

    public StringLiteral(char[] cArray, int n2, int n3, int n4) {
        this(n2, n3);
        this.c = cArray;
        this.d = n4 - 1;
    }

    public StringLiteral(int n2, int n3) {
        super(n2, n3);
    }

    @Override
    public void computeConstant() {
        this.constant = StringConstant.fromValue(String.valueOf(this.c));
    }

    public ExtendedStringLiteral extendWith(StringLiteral stringLiteral) {
        return new ExtendedStringLiteral(this, stringLiteral);
    }

    public StringLiteralConcatenation extendsWith(StringLiteral stringLiteral) {
        return new StringLiteralConcatenation(this, stringLiteral);
    }

    @Override
    public TypeBinding literalType(BlockScope blockScope) {
        return blockScope.getJavaLangString();
    }

    @Override
    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        stringBuffer.append('\"');
        int n3 = 0;
        while (n3 < this.c.length) {
            switch (this.c[n3]) {
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    stringBuffer.append(this.c[n3]);
                }
            }
            ++n3;
        }
        stringBuffer.append('\"');
        return stringBuffer;
    }

    @Override
    public char[] source() {
        return this.c;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 98;
    }
}

