/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.ast;

import org.ccdt.jsdt.core.a.bw;
import org.ccdt.jsdt.internal.compiler.ASTVisitor;
import org.ccdt.jsdt.internal.compiler.ast.AllocationExpression;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.SingleTypeReference;
import org.ccdt.jsdt.internal.compiler.ast.TypeDeclaration;
import org.ccdt.jsdt.internal.compiler.flow.FlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.impl.Constant;
import org.ccdt.jsdt.internal.compiler.lookup.Binding;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.ccdt.jsdt.internal.compiler.lookup.MethodBinding;
import org.ccdt.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.ccdt.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;
import org.ccdt.jsdt.internal.compiler.lookup.TypeConstants;

public class QualifiedAllocationExpression
extends AllocationExpression
implements bw {
    public Expression enclosingInstance;
    public TypeDeclaration anonymousType;
    public ReferenceBinding superTypeBinding;

    public QualifiedAllocationExpression() {
    }

    public QualifiedAllocationExpression(TypeDeclaration typeDeclaration) {
        this.anonymousType = typeDeclaration;
        typeDeclaration.allocation = this;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.enclosingInstance != null) {
            flowInfo = this.enclosingInstance.analyseCode(blockScope, flowContext, flowInfo);
        }
        if (this.arguments != null) {
            int n2 = 0;
            int n3 = this.arguments.length;
            while (n2 < n3) {
                flowInfo = this.arguments[n2].analyseCode(blockScope, flowContext, flowInfo);
                ++n2;
            }
        }
        if (this.anonymousType != null) {
            flowInfo = this.anonymousType.analyseCode(blockScope, flowContext, flowInfo);
        }
        this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
        return flowInfo;
    }

    @Override
    public Expression enclosingInstance() {
        return this.enclosingInstance;
    }

    @Override
    public boolean isSuperAccess() {
        return this.anonymousType != null;
    }

    @Override
    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        ReferenceBinding referenceBinding;
        if ((flowInfo.tagBits & 1) == 0 && (referenceBinding = this.binding.declaringClass).isNestedType() && blockScope.enclosingSourceType().isLocalType() && referenceBinding.isLocalType()) {
            ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, this.enclosingInstance != null);
        }
    }

    @Override
    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        if (this.enclosingInstance != null) {
            this.enclosingInstance.printExpression(0, stringBuffer).append('.');
        }
        super.printExpression(0, stringBuffer);
        if (this.anonymousType != null) {
            this.anonymousType.print(n2, stringBuffer);
        }
        return stringBuffer;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        int n2;
        if (this.anonymousType == null && this.enclosingInstance == null) {
            return super.resolveType(blockScope);
        }
        this.constant = Constant.NotAConstant;
        TypeBinding typeBinding = null;
        TypeBinding typeBinding2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.enclosingInstance != null) {
            typeBinding = this.enclosingInstance.resolveType(blockScope);
            if (typeBinding == null) {
                bl2 = true;
            } else {
                typeBinding2 = ((SingleTypeReference)this.type).resolveTypeEnclosing(blockScope, (ReferenceBinding)typeBinding);
            }
        } else if (this.type == null) {
            typeBinding2 = blockScope.enclosingSourceType();
        } else {
            typeBinding2 = this.type.resolveType(blockScope, true);
            if (typeBinding2 == null) {
                // empty if block
            }
        }
        if (typeBinding2 == null) {
            bl2 = true;
        }
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            n2 = this.arguments.length;
            typeBindingArray = new TypeBinding[n2];
            int n3 = 0;
            while (n3 < n2) {
                Expression expression = this.arguments[n3];
                typeBindingArray[n3] = expression.resolveType(blockScope);
                if (typeBindingArray[n3] == null) {
                    bl2 = true;
                }
                ++n3;
            }
        }
        if (bl2) {
            if (typeBinding2 instanceof ReferenceBinding) {
                MethodBinding methodBinding;
                n2 = this.arguments == null ? 0 : this.arguments.length;
                TypeBinding[] typeBindingArray2 = new TypeBinding[n2];
                int n4 = n2;
                while (--n4 >= 0) {
                    TypeBinding typeBinding3 = typeBindingArray2[n4] = typeBindingArray[n4] == null ? TypeBinding.NULL : typeBindingArray[n4];
                }
                this.binding = blockScope.findMethod((ReferenceBinding)typeBinding2, TypeConstants.INIT, typeBindingArray2, this);
                if (this.binding != null && !this.binding.isValidBinding() && (methodBinding = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                    this.binding = methodBinding;
                    MethodBinding methodBinding2 = methodBinding.original();
                    if ((methodBinding2.isPrivate() || methodBinding2.declaringClass.isLocalType()) && !blockScope.isDefinedInMethod(methodBinding2)) {
                        methodBinding2.modifiers |= 0x8000000;
                    }
                }
            }
            this.resolvedType = typeBinding2;
            return this.resolvedType;
        }
        if (this.anonymousType == null) {
            ReferenceBinding referenceBinding = typeBinding2;
            this.binding = blockScope.getConstructor(referenceBinding, typeBindingArray, this);
            if (this.binding.isValidBinding()) {
                if (this.isMethodUseDeprecated(this.binding, blockScope, true)) {
                    blockScope.problemReporter().deprecatedMethod(this.binding, this);
                }
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = referenceBinding;
                }
                blockScope.problemReporter().invalidConstructor(this, this.binding);
                this.resolvedType = typeBinding2;
                return this.resolvedType;
            }
            QualifiedAllocationExpression.checkInvocationArguments(blockScope, null, referenceBinding, this.binding, this.arguments, typeBindingArray, bl3, this);
            ReferenceBinding referenceBinding2 = this.binding.declaringClass.enclosingType();
            if (referenceBinding2 != typeBinding) {
                blockScope.compilationUnitScope().recordTypeConversion(referenceBinding2, typeBinding);
            }
            if (typeBinding.isCompatibleWith(referenceBinding2) || blockScope.isBoxingCompatibleWith(typeBinding, referenceBinding2)) {
                this.resolvedType = typeBinding2;
                return this.resolvedType;
            }
            blockScope.problemReporter().typeMismatchError(typeBinding, referenceBinding2, this.enclosingInstance);
            this.resolvedType = typeBinding2;
            return this.resolvedType;
        }
        this.superTypeBinding = typeBinding2;
        blockScope.addAnonymousType(this.anonymousType, (ReferenceBinding)typeBinding2);
        this.anonymousType.resolve(blockScope);
        MethodBinding methodBinding = blockScope.getConstructor(this.superTypeBinding, typeBindingArray, this);
        if (!methodBinding.isValidBinding()) {
            if (methodBinding.declaringClass == null) {
                methodBinding.declaringClass = this.superTypeBinding;
            }
            blockScope.problemReporter().invalidConstructor(this, methodBinding);
            this.resolvedType = this.anonymousType.binding;
            return this.resolvedType;
        }
        if (this.enclosingInstance != null) {
            ReferenceBinding referenceBinding = methodBinding.declaringClass.enclosingType();
            if (referenceBinding == null) {
                this.resolvedType = this.anonymousType.binding;
                return this.resolvedType;
            }
            if (!typeBinding.isCompatibleWith(referenceBinding) && !blockScope.isBoxingCompatibleWith(typeBinding, referenceBinding)) {
                blockScope.problemReporter().typeMismatchError(typeBinding, referenceBinding, this.enclosingInstance);
                this.resolvedType = this.anonymousType.binding;
                return this.resolvedType;
            }
        }
        if (this.arguments != null) {
            QualifiedAllocationExpression.checkInvocationArguments(blockScope, null, this.superTypeBinding, methodBinding, this.arguments, typeBindingArray, bl3, this);
        }
        this.binding = this.anonymousType.createDefaultConstructorWithBinding(methodBinding);
        this.resolvedType = this.anonymousType.binding;
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.enclosingInstance != null) {
                this.enclosingInstance.traverse(aSTVisitor, blockScope);
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                int n2 = this.arguments.length;
                int n3 = 0;
                while (n3 < n2) {
                    this.arguments[n3].traverse(aSTVisitor, blockScope);
                    ++n3;
                }
            }
            if (this.anonymousType != null) {
                this.anonymousType.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 85;
    }
}

