/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.ast;

import org.ccdt.jsdt.core.a.as;
import org.ccdt.jsdt.internal.compiler.ASTVisitor;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.OperatorExpression;
import org.ccdt.jsdt.internal.compiler.ast.TypeReference;
import org.ccdt.jsdt.internal.compiler.flow.FlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.impl.Constant;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;

public class InstanceOfExpression
extends OperatorExpression
implements as {
    public Expression expression;
    public TypeReference type;

    public InstanceOfExpression(Expression expression, TypeReference typeReference) {
        this.expression = expression;
        this.type = typeReference;
        typeReference.bits |= 0x40000000;
        this.bits |= 0x680;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = typeReference.sourceEnd;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        LocalVariableBinding localVariableBinding = this.expression.localVariableBinding();
        if (localVariableBinding != null && (localVariableBinding.type.tagBits & 2L) == 0L) {
            flowContext.recordUsingNullReference(blockScope, localVariableBinding, this.expression, 1, flowInfo);
            flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            FlowInfo flowInfo2 = flowInfo.copy();
            flowInfo2.markAsComparedEqualToNonNull(localVariableBinding);
            return FlowInfo.conditional(flowInfo2, flowInfo.copy());
        }
        return this.expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int n2, StringBuffer stringBuffer) {
        this.expression.printExpression(n2, stringBuffer).append(" instanceof ");
        return this.type.print(0, stringBuffer);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        this.constant = Constant.NotAConstant;
        TypeBinding typeBinding = this.expression.resolveType(blockScope);
        TypeBinding typeBinding2 = this.type.resolveType(blockScope, true);
        if (typeBinding == null || typeBinding2 == null) {
            return null;
        }
        if (typeBinding != TypeBinding.NULL && typeBinding.isBaseType() || !this.checkCastTypesCompatibility(blockScope, typeBinding2, typeBinding, null)) {
            blockScope.problemReporter().notCompatibleTypesError(this, typeBinding, typeBinding2);
        }
        this.resolvedType = TypeBinding.BOOLEAN;
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.expression.traverse(aSTVisitor, blockScope);
            this.type.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 48;
    }
}

