/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.ast;

import org.ccdt.jsdt.core.a.ad;
import org.ccdt.jsdt.internal.compiler.ASTVisitor;
import org.ccdt.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.Statement;
import org.ccdt.jsdt.internal.compiler.ast.TypeReference;
import org.ccdt.jsdt.internal.compiler.flow.FlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.lookup.Binding;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.InvocationSite;
import org.ccdt.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.ccdt.jsdt.internal.compiler.lookup.MethodBinding;
import org.ccdt.jsdt.internal.compiler.lookup.MethodScope;
import org.ccdt.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.ccdt.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;
import org.ccdt.jsdt.internal.compiler.lookup.TypeConstants;
import org.ccdt.jsdt.internal.compiler.lookup.VariableBinding;

public class ExplicitConstructorCall
extends Statement
implements ad,
InvocationSite {
    public Expression[] arguments;
    public Expression qualification;
    public MethodBinding binding;
    protected MethodBinding codegenBinding;
    public int accessMode;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public static final int ImplicitSuper = 1;
    public static final int This = 3;
    public VariableBinding[][] implicitArguments;
    public int typeArgumentsSourceStart;

    public ExplicitConstructorCall(int n2) {
        this.accessMode = n2;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            ((MethodScope)blockScope).isConstructorCall = true;
            if (this.qualification != null) {
                flowInfo = this.qualification.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            }
            if (this.arguments != null) {
                int n2 = 0;
                int n3 = this.arguments.length;
                while (n2 < n3) {
                    flowInfo = this.arguments[n2].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                    ++n2;
                }
            }
            this.a(blockScope, flowInfo);
            this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
            FlowInfo flowInfo2 = flowInfo;
            return flowInfo2;
        }
        finally {
            ((MethodScope)blockScope).isConstructorCall = false;
        }
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isImplicitSuper() {
        return this.accessMode == 1;
    }

    @Override
    public boolean isSuperAccess() {
        return this.accessMode != 3;
    }

    @Override
    public boolean isTypeAccess() {
        return true;
    }

    void a(BlockScope blockScope, FlowInfo flowInfo) {
        ReferenceBinding referenceBinding = this.binding.declaringClass;
        if ((flowInfo.tagBits & 1) == 0 && referenceBinding.isNestedType() && blockScope.enclosingSourceType().isLocalType() && referenceBinding.isLocalType()) {
            ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, this.qualification != null);
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.codegenBinding = this.binding.original();
            if (this.binding.isPrivate() && this.accessMode != 3) {
                ReferenceBinding referenceBinding = this.codegenBinding.declaringClass;
                if ((referenceBinding.tagBits & 0x10L) != 0L && blockScope.compilerOptions().complianceLevel >= 0x300000L) {
                    this.codegenBinding.tagBits |= 0x400L;
                }
            }
        }
    }

    @Override
    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        int n3;
        ExplicitConstructorCall.printIndent(n2, stringBuffer);
        if (this.qualification != null) {
            this.qualification.printExpression(0, stringBuffer).append('.');
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n3 = this.typeArguments.length - 1;
            int n4 = 0;
            while (n4 < n3) {
                this.typeArguments[n4].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n4;
            }
            this.typeArguments[n3].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if (this.accessMode == 3) {
            stringBuffer.append("this(");
        } else {
            stringBuffer.append("super(");
        }
        if (this.arguments != null) {
            n3 = 0;
            while (n3 < this.arguments.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n3].printExpression(0, stringBuffer);
                ++n3;
            }
        }
        return stringBuffer.append(");");
    }

    @Override
    public void resolve(BlockScope blockScope) {
        MethodScope methodScope = blockScope.methodScope();
        try {
            int n2;
            boolean bl2;
            AbstractMethodDeclaration abstractMethodDeclaration = methodScope.referenceMethod();
            if (abstractMethodDeclaration == null || !abstractMethodDeclaration.isConstructor() || ((ConstructorDeclaration)abstractMethodDeclaration).constructorCall != this) {
                int n3;
                int n4;
                if (this.qualification != null) {
                    this.qualification.resolveType(blockScope);
                }
                if (this.typeArguments != null) {
                    n4 = 0;
                    n3 = this.typeArguments.length;
                    while (n4 < n3) {
                        this.typeArguments[n4].resolveType(blockScope, true);
                        ++n4;
                    }
                }
                if (this.arguments != null) {
                    n4 = 0;
                    n3 = this.arguments.length;
                    while (n4 < n3) {
                        this.arguments[n4].resolveType(blockScope);
                        ++n4;
                    }
                }
                return;
            }
            methodScope.isConstructorCall = true;
            ReferenceBinding referenceBinding = blockScope.enclosingReceiverType();
            if (this.accessMode != 3) {
                referenceBinding = referenceBinding.getSuperBinding();
            }
            if (referenceBinding == null) {
                return;
            }
            if (this.qualification != null) {
                ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
                if (referenceBinding2 == null) {
                    this.bits |= 0x2000;
                } else {
                    this.qualification.resolveTypeExpecting(blockScope, referenceBinding2);
                }
            }
            if (this.typeArguments != null) {
                int n5 = this.typeArguments.length;
                bl2 = false;
                this.genericTypeArguments = new TypeBinding[n5];
                n2 = 0;
                while (n2 < n5) {
                    TypeReference typeReference = this.typeArguments[n2];
                    this.genericTypeArguments[n2] = typeReference.resolveType(blockScope, true);
                    if (this.genericTypeArguments[n2] == null) {
                        bl2 = true;
                    }
                    ++n2;
                }
                if (bl2) {
                    return;
                }
            }
            TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
            bl2 = false;
            if (this.arguments != null) {
                n2 = 0;
                int n6 = this.arguments.length;
                typeBindingArray = new TypeBinding[n6];
                int n7 = 0;
                while (n7 < n6) {
                    Expression expression = this.arguments[n7];
                    typeBindingArray[n7] = expression.resolveType(blockScope);
                    if (typeBindingArray[n7] == null) {
                        n2 = 1;
                    }
                    ++n7;
                }
                if (n2 != 0) {
                    MethodBinding methodBinding;
                    TypeBinding[] typeBindingArray2 = new TypeBinding[n6];
                    int n8 = n6;
                    while (--n8 >= 0) {
                        TypeBinding typeBinding = typeBindingArray2[n8] = typeBindingArray[n8] == null ? TypeBinding.NULL : typeBindingArray[n8];
                    }
                    this.binding = blockScope.findMethod(referenceBinding, TypeConstants.INIT, typeBindingArray2, this);
                    if (this.binding != null && !this.binding.isValidBinding() && (methodBinding = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                        this.binding = methodBinding;
                        MethodBinding methodBinding2 = methodBinding.original();
                        if ((methodBinding2.isPrivate() || methodBinding2.declaringClass.isLocalType()) && !blockScope.isDefinedInMethod(methodBinding2)) {
                            methodBinding2.modifiers |= 0x8000000;
                        }
                    }
                    return;
                }
            }
            if ((this.binding = blockScope.getConstructor(referenceBinding, typeBindingArray, this)).isValidBinding()) {
                if (this.isMethodUseDeprecated(this.binding, blockScope, this.accessMode != 1)) {
                    blockScope.problemReporter().deprecatedMethod(this.binding, this);
                }
                ExplicitConstructorCall.checkInvocationArguments(blockScope, null, referenceBinding, this.binding, this.arguments, typeBindingArray, bl2, this);
                if (this.binding.isPrivate() || referenceBinding.isLocalType()) {
                    this.binding.original().modifiers |= 0x8000000;
                }
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = referenceBinding;
                }
                blockScope.problemReporter().invalidConstructor(this, this.binding);
            }
        }
        finally {
            methodScope.isConstructorCall = false;
        }
    }

    @Override
    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    @Override
    public void setDepth(int n2) {
    }

    @Override
    public void setFieldIndex(int n2) {
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n2;
            int n3;
            if (this.qualification != null) {
                this.qualification.traverse(aSTVisitor, blockScope);
            }
            if (this.typeArguments != null) {
                n3 = 0;
                n2 = this.typeArguments.length;
                while (n3 < n2) {
                    this.typeArguments[n3].traverse(aSTVisitor, blockScope);
                    ++n3;
                }
            }
            if (this.arguments != null) {
                n3 = 0;
                n2 = this.arguments.length;
                while (n3 < n2) {
                    this.arguments[n3].traverse(aSTVisitor, blockScope);
                    ++n3;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 32;
    }
}

