/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.ast;

import org.ccdt.jsdt.core.a.t;
import org.ccdt.jsdt.internal.compiler.ASTVisitor;
import org.ccdt.jsdt.internal.compiler.ast.Assignment;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.OperatorExpression;
import org.ccdt.jsdt.internal.compiler.ast.OperatorIds;
import org.ccdt.jsdt.internal.compiler.ast.Reference;
import org.ccdt.jsdt.internal.compiler.flow.FlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.impl.Constant;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;

public class CompoundAssignment
extends Assignment
implements t,
OperatorIds {
    public int operator;
    public int preAssignImplicitConversion;

    public CompoundAssignment(Expression expression, Expression expression2, int n2, int n3) {
        super(expression, expression2, n3);
        expression.bits &= 0xFFFFDFFF;
        expression.bits |= 0x10000;
        this.operator = n2;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.resolvedType.id != 11) {
            this.lhs.checkNPE(blockScope, flowContext, flowInfo);
        }
        return ((Reference)this.lhs).analyseAssignment(blockScope, flowContext, flowInfo, this, true).unconditionalInits();
    }

    @Override
    public int nullStatus(FlowInfo flowInfo) {
        return -1;
    }

    public String operatorToString() {
        switch (this.operator) {
            case 14: {
                return "+=";
            }
            case 13: {
                return "-=";
            }
            case 15: {
                return "*=";
            }
            case 9: {
                return "/=";
            }
            case 2: {
                return "&=";
            }
            case 3: {
                return "|=";
            }
            case 8: {
                return "^=";
            }
            case 16: {
                return "%=";
            }
            case 10: {
                return "<<=";
            }
            case 17: {
                return ">>=";
            }
            case 19: {
                return ">>>=";
            }
        }
        return "unknown operator";
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int n2, StringBuffer stringBuffer) {
        this.lhs.printExpression(n2, stringBuffer).append(' ').append(this.operatorToString()).append(' ');
        return this.expression.printExpression(0, stringBuffer);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        int n2;
        this.constant = Constant.NotAConstant;
        if (!(this.lhs instanceof Reference) || this.lhs.isThis()) {
            blockScope.problemReporter().expressionShouldBeAVariable(this.lhs);
            return null;
        }
        TypeBinding typeBinding = this.lhs.resolveType(blockScope);
        TypeBinding typeBinding2 = this.expression.resolveType(blockScope);
        this.resolvedType = TypeBinding.ANY;
        if (typeBinding == null || typeBinding2 == null) {
            return null;
        }
        LookupEnvironment lookupEnvironment = blockScope.environment();
        TypeBinding typeBinding3 = typeBinding;
        TypeBinding typeBinding4 = typeBinding2;
        boolean bl2 = blockScope.compilerOptions().sourceLevel >= 0x310000L;
        boolean bl3 = false;
        if (bl2) {
            TypeBinding typeBinding5;
            if (!typeBinding3.isBaseType() && typeBinding4.id != 11 && typeBinding4.id != 12 && (typeBinding5 = lookupEnvironment.computeBoxingType(typeBinding3)) != typeBinding3) {
                typeBinding3 = typeBinding5;
                bl3 = true;
            }
            if (!typeBinding4.isBaseType() && typeBinding3.id != 11 && typeBinding3.id != 12) {
                typeBinding4 = lookupEnvironment.computeBoxingType(typeBinding4);
            }
        }
        if (this.restrainUsageToNumericTypes() && !typeBinding3.isNumericType() && !typeBinding3.isAnyType()) {
            blockScope.problemReporter().operatorOnlyValidOnNumericType(this, typeBinding3, typeBinding4);
            return null;
        }
        int n3 = typeBinding3.id;
        int n4 = typeBinding4.id;
        if (n3 > 15 || n4 > 15) {
            if (n3 != 11) {
                blockScope.problemReporter().invalidOperator(this, typeBinding3, typeBinding4);
                return null;
            }
            n4 = 1;
        }
        if ((n2 = OperatorExpression.OperatorSignatures[this.operator][(n3 << 4) + n4]) == 0) {
            blockScope.problemReporter().invalidOperator(this, typeBinding3, typeBinding4);
            return null;
        }
        this.preAssignImplicitConversion = (bl3 ? 512 : 0) | n3 << 4 | n2 & 0xF;
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    public boolean restrainUsageToNumericTypes() {
        return false;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.lhs.traverse(aSTVisitor, blockScope);
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 23;
    }
}

