/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.ast;

import org.ccdt.jsdt.core.a.s;
import org.ccdt.jsdt.internal.compiler.ASTVisitor;
import org.ccdt.jsdt.internal.compiler.ast.BinaryExpression;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.flow.FlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;

public class CombinedBinaryExpression
extends BinaryExpression
implements s {
    public int arity;
    public int arityMax;
    public static final int ARITY_MAX_MAX = 160;
    public static final int ARITY_MAX_MIN = 20;
    public static int defaultArityMaxStartingValue = 20;
    public BinaryExpression[] referencesTable;

    public CombinedBinaryExpression(Expression expression, Expression expression2, int n2, int n3) {
        super(expression, expression2, n2);
        this.arity = n3;
        if (n3 > 1) {
            this.referencesTable = new BinaryExpression[n3];
            this.referencesTable[n3 - 1] = (BinaryExpression)expression;
            int n4 = n3 - 1;
            while (n4 > 0) {
                this.referencesTable[n4 - 1] = (BinaryExpression)this.referencesTable[n4].left;
                --n4;
            }
        } else {
            this.arityMax = defaultArityMaxStartingValue;
        }
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.referencesTable == null) {
            return super.analyseCode(blockScope, flowContext, flowInfo);
        }
        if (this.referencesTable[0] != null && this.referencesTable[0].resolvedType != null) {
            BinaryExpression binaryExpression = this.referencesTable[0];
            if (binaryExpression.resolvedType.id != 11) {
                binaryExpression.left.checkNPE(blockScope, flowContext, flowInfo);
            }
            flowInfo = binaryExpression.left.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            int n2 = 0;
            int n3 = this.arity;
            while (n2 < n3) {
                binaryExpression = this.referencesTable[n2];
                if (binaryExpression.resolvedType.id != 11) {
                    binaryExpression.right.checkNPE(blockScope, flowContext, flowInfo);
                }
                flowInfo = binaryExpression.right.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                ++n2;
            }
        }
        if (this.resolvedType.id != 11) {
            this.right.checkNPE(blockScope, flowContext, flowInfo);
        }
        return this.right.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int n2, StringBuffer stringBuffer) {
        if (this.referencesTable == null) {
            return super.printExpressionNoParenthesis(n2, stringBuffer);
        }
        String string = this.operatorToString();
        int n3 = this.arity - 1;
        while (n3 >= 0) {
            stringBuffer.append('(');
            --n3;
        }
        stringBuffer = this.referencesTable[0].left.printExpression(n2, stringBuffer);
        n3 = 0;
        int n4 = this.arity;
        while (n3 < n4) {
            stringBuffer.append(' ').append(string).append(' ');
            stringBuffer = this.referencesTable[n3].right.printExpression(0, stringBuffer);
            stringBuffer.append(')');
            ++n3;
        }
        stringBuffer.append(' ').append(string).append(' ');
        return this.right.printExpression(0, stringBuffer);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        if (this.referencesTable == null) {
            return super.resolveType(blockScope);
        }
        BinaryExpression binaryExpression = this.referencesTable[0];
        binaryExpression.left.resolveType(blockScope);
        int n2 = 0;
        int n3 = this.arity;
        while (n2 < n3) {
            this.referencesTable[n2].a(blockScope);
            ++n2;
        }
        this.a(blockScope);
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (this.referencesTable == null) {
            super.traverse(aSTVisitor, blockScope);
        } else {
            if (aSTVisitor.visit(this, blockScope)) {
                int n2 = this.arity - 1;
                while (n2 >= 0) {
                    if (!aSTVisitor.visit(this.referencesTable[n2], blockScope)) {
                        aSTVisitor.endVisit(this.referencesTable[n2], blockScope);
                        break;
                    }
                    --n2;
                }
                if (++n2 == 0) {
                    this.referencesTable[0].left.traverse(aSTVisitor, blockScope);
                }
                int n3 = n2;
                int n4 = this.arity;
                while (n3 < n4) {
                    this.referencesTable[n3].right.traverse(aSTVisitor, blockScope);
                    aSTVisitor.endVisit(this.referencesTable[n3], blockScope);
                    ++n3;
                }
                this.right.traverse(aSTVisitor, blockScope);
            }
            aSTVisitor.endVisit(this, blockScope);
        }
    }

    public void tuneArityMax() {
        if (this.arityMax < 160) {
            this.arityMax *= 2;
        }
    }

    @Override
    public int getASTType() {
        return 22;
    }
}

