/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.ast;

import org.ccdt.jsdt.core.a.r;
import org.ccdt.jsdt.internal.compiler.ASTVisitor;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.Statement;
import org.ccdt.jsdt.internal.compiler.ast.SwitchStatement;
import org.ccdt.jsdt.internal.compiler.flow.FlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.impl.Constant;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;

public class CaseStatement
extends Statement
implements r {
    public Expression constantExpression;

    public CaseStatement(Expression expression, int n2, int n3) {
        this.constantExpression = expression;
        this.sourceEnd = n2;
        this.sourceStart = n3;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.constantExpression != null) {
            this.constantExpression.analyseCode(blockScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    @Override
    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        CaseStatement.printIndent(n2, stringBuffer);
        if (this.constantExpression == null) {
            stringBuffer.append("default : ");
        } else {
            stringBuffer.append("case ");
            this.constantExpression.printExpression(0, stringBuffer).append(" : ");
        }
        return stringBuffer.append(';');
    }

    @Override
    public void resolve(BlockScope blockScope) {
    }

    @Override
    public Constant resolveCase(BlockScope blockScope, TypeBinding typeBinding, SwitchStatement switchStatement) {
        blockScope.enclosingCase = this;
        if (this.constantExpression == null) {
            if (switchStatement.defaultCase != null) {
                blockScope.problemReporter().duplicateDefaultCase(this);
            }
            switchStatement.defaultCase = this;
            return Constant.NotAConstant;
        }
        switchStatement.cases[switchStatement.caseCount++] = this;
        TypeBinding typeBinding2 = this.constantExpression.resolveType(blockScope);
        if (typeBinding2 == null || typeBinding == null) {
            return Constant.NotAConstant;
        }
        if (this.constantExpression.isConstantValueOfTypeAssignableToType(typeBinding2, typeBinding) || typeBinding2.isCompatibleWith(typeBinding)) {
            return this.constantExpression.constant;
        }
        if (blockScope.isBoxingCompatibleWith(typeBinding2, typeBinding) || typeBinding2.isBaseType() && blockScope.compilerOptions().sourceLevel >= 0x310000L && !typeBinding.isBaseType() && this.constantExpression.isConstantValueOfTypeAssignableToType(typeBinding2, blockScope.environment().computeBoxingType(typeBinding))) {
            return this.constantExpression.constant;
        }
        blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, this.constantExpression);
        return Constant.NotAConstant;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.constantExpression != null) {
            this.constantExpression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 19;
    }
}

