/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.ast;

import org.ccdt.jsdt.core.a.cg;
import org.ccdt.jsdt.core.a.o;
import org.ccdt.jsdt.internal.compiler.ASTVisitor;
import org.ccdt.jsdt.internal.compiler.ast.Statement;
import org.ccdt.jsdt.internal.compiler.flow.FlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;

public class Block
extends Statement
implements o {
    public Statement[] statements;
    public int explicitDeclarations;
    public BlockScope scope;

    public Block(int n2) {
        this.explicitDeclarations = n2;
    }

    public cg[] getStatements() {
        return this.statements;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.statements == null) {
            return flowInfo;
        }
        boolean bl2 = false;
        int n2 = 0;
        int n3 = this.statements.length;
        while (n2 < n3) {
            Statement statement = this.statements[n2];
            if (!statement.complainIfUnreachable(flowInfo, this.scope, bl2)) {
                flowInfo = statement.analyseCode(this.scope, flowContext, flowInfo);
            } else {
                bl2 = true;
            }
            ++n2;
        }
        return flowInfo;
    }

    @Override
    public boolean isEmptyBlock() {
        return this.statements == null;
    }

    public StringBuffer printBody(int n2, StringBuffer stringBuffer) {
        if (this.statements == null) {
            return stringBuffer;
        }
        int n3 = 0;
        while (n3 < this.statements.length) {
            this.statements[n3].printStatement(n2 + 1, stringBuffer);
            stringBuffer.append('\n');
            ++n3;
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        Block.printIndent(n2, stringBuffer);
        stringBuffer.append("{\n");
        this.printBody(n2, stringBuffer);
        return Block.printIndent(n2, stringBuffer).append('}');
    }

    @Override
    public void resolve(BlockScope blockScope) {
        if ((this.bits & 8) != 0) {
            blockScope.problemReporter().undocumentedEmptyBlock(this.sourceStart, this.sourceEnd);
        }
        if (this.statements != null) {
            this.scope = blockScope;
            int n2 = 0;
            int n3 = this.statements.length;
            while (n2 < n3) {
                this.statements[n2].resolve(this.scope);
                ++n2;
            }
        }
    }

    public void resolveUsing(BlockScope blockScope) {
        if ((this.bits & 8) != 0) {
            blockScope.problemReporter().undocumentedEmptyBlock(this.sourceStart, this.sourceEnd);
        }
        this.scope = blockScope;
        if (this.statements != null) {
            int n2 = 0;
            int n3 = this.statements.length;
            while (n2 < n3) {
                this.statements[n2].resolve(this.scope);
                ++n2;
            }
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        BlockScope blockScope2;
        BlockScope blockScope3 = blockScope2 = this.scope != null ? this.scope : blockScope;
        if (aSTVisitor.visit(this, blockScope) && this.statements != null) {
            int n2 = 0;
            int n3 = this.statements.length;
            while (n2 < n3) {
                this.statements[n2].traverse(aSTVisitor, blockScope2);
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 16;
    }
}

