/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.ast;

import org.ccdt.jsdt.core.a.k;
import org.ccdt.jsdt.core.compiler.CharOperation;
import org.ccdt.jsdt.internal.compiler.ASTVisitor;
import org.ccdt.jsdt.internal.compiler.ast.Assignment;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.Reference;
import org.ccdt.jsdt.internal.compiler.ast.StringLiteral;
import org.ccdt.jsdt.internal.compiler.flow.FlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.impl.Constant;
import org.ccdt.jsdt.internal.compiler.lookup.ArrayBinding;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.FieldBinding;
import org.ccdt.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;

public class ArrayReference
extends Reference
implements k {
    public Expression receiver;
    public Expression position;

    public ArrayReference(Expression expression, Expression expression2) {
        this.receiver = expression;
        this.position = expression2;
        this.sourceStart = expression.sourceStart;
    }

    @Override
    public FlowInfo analyseAssignment(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean bl2) {
        if (assignment.expression == null) {
            return this.analyseCode(blockScope, flowContext, flowInfo);
        }
        return assignment.expression.analyseCode(blockScope, flowContext, this.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits());
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.receiver.checkNPE(blockScope, flowContext, flowInfo);
        flowInfo = this.receiver.analyseCode(blockScope, flowContext, flowInfo);
        return this.position.analyseCode(blockScope, flowContext, flowInfo);
    }

    @Override
    public int nullStatus(FlowInfo flowInfo) {
        return 0;
    }

    @Override
    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        this.receiver.printExpression(0, stringBuffer).append('[');
        return this.position.printExpression(0, stringBuffer).append(']');
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        this.constant = Constant.NotAConstant;
        TypeBinding typeBinding = this.receiver.resolveType(blockScope);
        if (typeBinding != null) {
            if (typeBinding.isArrayType()) {
                TypeBinding typeBinding2;
                this.resolvedType = typeBinding2 = ((ArrayBinding)typeBinding).elementsType();
            } else if (typeBinding instanceof SourceTypeBinding) {
                this.resolvedType = TypeBinding.UNKNOWN;
                if (this.position instanceof StringLiteral) {
                    FieldBinding[] fieldBindingArray = ((SourceTypeBinding)typeBinding).fields();
                    char[] cArray = ((StringLiteral)this.position).c;
                    int n2 = 0;
                    while (n2 < fieldBindingArray.length) {
                        if (CharOperation.equals(cArray, fieldBindingArray[n2].name)) {
                            this.resolvedType = fieldBindingArray[n2].type;
                            break;
                        }
                        ++n2;
                    }
                }
            } else {
                this.resolvedType = TypeBinding.UNKNOWN;
            }
        } else {
            this.resolvedType = TypeBinding.UNKNOWN;
        }
        this.position.resolveTypeExpecting(blockScope, new TypeBinding[]{blockScope.getJavaLangNumber(), blockScope.getJavaLangString(), TypeBinding.ANY});
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.receiver.traverse(aSTVisitor, blockScope);
            this.position.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 11;
    }
}

