/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.ast;

import org.ccdt.jsdt.core.a.h;
import org.ccdt.jsdt.internal.compiler.ASTVisitor;
import org.ccdt.jsdt.internal.compiler.ast.ArrayInitializer;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.TypeReference;
import org.ccdt.jsdt.internal.compiler.flow.FlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.impl.Constant;
import org.ccdt.jsdt.internal.compiler.lookup.ArrayBinding;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;

public class ArrayAllocationExpression
extends Expression
implements h {
    public TypeReference type;
    public Expression[] dimensions;
    public ArrayInitializer initializer;

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        int n2 = 0;
        int n3 = this.dimensions.length;
        while (n2 < n3) {
            Expression expression = this.dimensions[n2];
            if (expression != null) {
                flowInfo = expression.analyseCode(blockScope, flowContext, flowInfo);
            }
            ++n2;
        }
        if (this.initializer != null) {
            return this.initializer.analyseCode(blockScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    @Override
    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        stringBuffer.append("new ");
        this.type.print(0, stringBuffer);
        int n3 = 0;
        while (n3 < this.dimensions.length) {
            if (this.dimensions[n3] == null) {
                stringBuffer.append("[]");
            } else {
                stringBuffer.append('[');
                this.dimensions[n3].printExpression(0, stringBuffer);
                stringBuffer.append(']');
            }
            ++n3;
        }
        if (this.initializer != null) {
            this.initializer.printExpression(0, stringBuffer);
        }
        return stringBuffer;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding = this.type.resolveType(blockScope, true);
        this.constant = Constant.NotAConstant;
        int n2 = -1;
        int n3 = this.dimensions.length;
        while (--n3 >= 0) {
            if (this.dimensions[n3] != null) {
                if (n2 >= 0) continue;
                n2 = n3;
                continue;
            }
            if (n2 > 0) break;
        }
        n3 = 0;
        while (n3 <= n2) {
            Expression expression = this.dimensions[n3];
            if (expression != null) {
                expression.resolveTypeExpecting(blockScope, TypeBinding.INT);
            }
            ++n3;
        }
        if (typeBinding != null) {
            this.resolvedType = blockScope.createArrayType(typeBinding, this.dimensions.length);
            if (this.initializer != null && this.initializer.resolveTypeExpecting(blockScope, this.resolvedType) != null) {
                this.initializer.binding = (ArrayBinding)this.resolvedType;
            }
        }
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n2 = this.dimensions.length;
            this.type.traverse(aSTVisitor, blockScope);
            int n3 = 0;
            while (n3 < n2) {
                if (this.dimensions[n3] != null) {
                    this.dimensions[n3].traverse(aSTVisitor, blockScope);
                }
                ++n3;
            }
            if (this.initializer != null) {
                this.initializer.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 8;
    }
}

