/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.compiler.ast;

import org.ccdt.jsdt.core.a.ae;
import org.ccdt.jsdt.core.a.f;
import org.ccdt.jsdt.internal.compiler.ASTVisitor;
import org.ccdt.jsdt.internal.compiler.ast.ASTNode;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.TypeReference;
import org.ccdt.jsdt.internal.compiler.flow.FlowContext;
import org.ccdt.jsdt.internal.compiler.flow.FlowInfo;
import org.ccdt.jsdt.internal.compiler.impl.Constant;
import org.ccdt.jsdt.internal.compiler.lookup.Binding;
import org.ccdt.jsdt.internal.compiler.lookup.BlockScope;
import org.ccdt.jsdt.internal.compiler.lookup.InvocationSite;
import org.ccdt.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.ccdt.jsdt.internal.compiler.lookup.MethodBinding;
import org.ccdt.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.ccdt.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.ccdt.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;
import org.ccdt.jsdt.internal.compiler.lookup.TypeConstants;

public class AllocationExpression
extends Expression
implements f,
InvocationSite {
    public TypeReference type;
    public Expression[] arguments;
    public MethodBinding binding;
    protected MethodBinding codegenBinding;
    public Expression member;
    public boolean isShort;

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.member != null) {
            flowInfo = this.member.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
        }
        if (this.arguments != null) {
            int n2 = 0;
            int n3 = this.arguments.length;
            while (n2 < n3) {
                flowInfo = this.arguments[n2].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                ++n2;
            }
        }
        return flowInfo;
    }

    public Expression enclosingInstance() {
        return null;
    }

    @Override
    public boolean isSuperAccess() {
        return false;
    }

    @Override
    public boolean isTypeAccess() {
        return true;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        ReferenceBinding referenceBinding = this.binding.declaringClass;
        if (referenceBinding.isNestedType() && blockScope.enclosingSourceType().isLocalType() && referenceBinding.isLocalType()) {
            ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, false);
        }
    }

    @Override
    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        stringBuffer.append("new ");
        this.member.print(n2, stringBuffer);
        if (this.type != null) {
            this.type.printExpression(0, stringBuffer);
        }
        if (!this.isShort) {
            stringBuffer.append('(');
            if (this.arguments != null) {
                int n3 = 0;
                while (n3 < this.arguments.length) {
                    if (n3 > 0) {
                        stringBuffer.append(", ");
                    }
                    this.arguments[n3].printExpression(0, stringBuffer);
                    ++n3;
                }
            }
            stringBuffer.append(')');
        }
        return stringBuffer;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        this.constant = Constant.NotAConstant;
        if (this.member != null) {
            this.resolvedType = this.member.resolveForAllocation(blockScope, this);
            if (this.resolvedType != null && !this.resolvedType.isValidBinding()) {
                blockScope.problemReporter().invalidType(this, this.resolvedType);
            }
        } else {
            this.resolvedType = this.type == null ? blockScope.enclosingReceiverType() : this.type.resolveType(blockScope, true);
        }
        boolean bl2 = false;
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            int n2 = this.arguments.length;
            typeBindingArray = new TypeBinding[n2];
            int n3 = 0;
            while (n3 < n2) {
                Expression expression = this.arguments[n3];
                typeBindingArray[n3] = expression.resolveType(blockScope);
                if (typeBindingArray[n3] == null) {
                    typeBindingArray[n3] = TypeBinding.UNKNOWN;
                }
                ++n3;
            }
        }
        if (this.resolvedType == null || this.resolvedType.isAnyType() || this.resolvedType instanceof ProblemReferenceBinding) {
            this.binding = new ProblemMethodBinding(TypeConstants.INIT, Binding.NO_PARAMETERS, 1);
            this.resolvedType = TypeBinding.UNKNOWN;
            return this.resolvedType;
        }
        if (!this.resolvedType.isValidBinding()) {
            return null;
        }
        if (this.resolvedType instanceof ReferenceBinding) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
            this.binding = blockScope.getConstructor(referenceBinding, typeBindingArray, this);
            if (!this.binding.isValidBinding()) {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = referenceBinding;
                }
                blockScope.problemReporter().invalidConstructor(this, this.binding);
                return this.resolvedType;
            }
            if (typeBindingArray.length != this.binding.parameters.length) {
                blockScope.problemReporter().wrongNumberOfArguments(this, this.binding);
            }
            if (this.isMethodUseDeprecated(this.binding, blockScope, true)) {
                blockScope.problemReporter().deprecatedMethod(this.binding, this);
            }
            AllocationExpression.checkInvocationArguments(blockScope, null, referenceBinding, this.binding, this.arguments, typeBindingArray, bl2, this);
        }
        return this.resolvedType;
    }

    @Override
    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    @Override
    public void setDepth(int n2) {
    }

    @Override
    public void setFieldIndex(int n2) {
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.member != null) {
                this.member.traverse(aSTVisitor, blockScope);
            } else if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                int n2 = 0;
                int n3 = this.arguments.length;
                while (n2 < n3) {
                    this.arguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 3;
    }

    @Override
    public ae getMember() {
        return this.member;
    }

    @Override
    public TypeBinding resolveForAllocation(BlockScope blockScope, ASTNode aSTNode) {
        return this.resolveType(blockScope);
    }
}

