/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.core.infer;

import java.util.ArrayList;
import java.util.Iterator;
import org.ccdt.jsdt.core.infer.DefaultInferrenceProvider;
import org.ccdt.jsdt.core.infer.IInferEngine;
import org.ccdt.jsdt.core.infer.IInferenceFile;
import org.ccdt.jsdt.core.infer.InferrenceProvider;
import org.ccdt.jsdt.core.infer.InferrenceSupportExtension;
import org.ccdt.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.ccdt.jsdt.internal.core.Logger;
import org.ccdt.jsdt.internal.core.util.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class InferrenceManager {
    private static final boolean a = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.ccdt.core/debug/inferEngine"));
    public static final String EXTENSION_POINT = "inferrenceSupport";
    protected static final String TAG_INFERENCE_PROVIDER = "inferenceProvider";
    protected static final String ATTR_INFERENGINE_CLASS = "class";
    private static InferrenceManager b = null;
    private InferrenceSupportExtension[] c;

    public static InferrenceManager getInstance() {
        if (b == null) {
            b = new InferrenceManager();
        }
        return b;
    }

    public InferrenceProvider[] getInferenceProviders() {
        if (this.c == null) {
            this.loadInferenceExtensions();
        }
        ArrayList<InferrenceProvider> arrayList = new ArrayList<InferrenceProvider>();
        arrayList.add(new DefaultInferrenceProvider());
        int n2 = 0;
        while (n2 < this.c.length) {
            if (this.c[n2].inferProvider != null) {
                arrayList.add(this.c[n2].inferProvider);
            }
            ++n2;
        }
        return arrayList.toArray(new InferrenceProvider[arrayList.size()]);
    }

    public InferrenceProvider[] getInferenceProviders(IInferenceFile iInferenceFile) {
        ArrayList<InferrenceProvider> arrayList = new ArrayList<InferrenceProvider>();
        InferrenceProvider[] inferrenceProviderArray = this.getInferenceProviders();
        if (inferrenceProviderArray.length == 1) {
            return new InferrenceProvider[]{inferrenceProviderArray[0]};
        }
        if (inferrenceProviderArray.length > 1) {
            arrayList.add(inferrenceProviderArray[0]);
        }
        int n2 = 1;
        while (n2 < inferrenceProviderArray.length) {
            if (inferrenceProviderArray[n2].getID().equals(iInferenceFile.getInferenceID())) {
                arrayList.clear();
                arrayList.add(inferrenceProviderArray[0]);
                arrayList.add(inferrenceProviderArray[n2]);
                break;
            }
            int n3 = 2;
            try {
                n3 = inferrenceProviderArray[n2].applysTo(iInferenceFile);
            }
            catch (Exception exception) {
                Util.log(exception, "exception in inference provider " + inferrenceProviderArray[n2].getID());
            }
            switch (n3) {
                case 3: {
                    arrayList.add(inferrenceProviderArray[n2]);
                    break;
                }
                case 1: {
                    arrayList.clear();
                    arrayList.add(inferrenceProviderArray[n2]);
                    return arrayList.toArray(new InferrenceProvider[arrayList.size()]);
                }
            }
            ++n2;
        }
        if (a) {
            String string = "";
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                string = String.valueOf(string) + ((InferrenceProvider)iterator.next()).getID().toString() + ", ";
            }
            Logger.log(201, "Proposed Inference Providers: " + string);
        }
        return arrayList.toArray(new InferrenceProvider[arrayList.size()]);
    }

    public IInferEngine[] getInferenceEngines(CompilationUnitDeclaration compilationUnitDeclaration) {
        ArrayList<IInferEngine> arrayList = new ArrayList<IInferEngine>();
        InferrenceProvider[] inferrenceProviderArray = this.getInferenceProviders(compilationUnitDeclaration);
        int n2 = 0;
        while (n2 < inferrenceProviderArray.length) {
            arrayList.add(inferrenceProviderArray[n2].getInferEngine());
            ++n2;
        }
        return arrayList.toArray(new IInferEngine[arrayList.size()]);
    }

    protected void loadInferenceExtensions() {
        IExtensionPoint iExtensionPoint;
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        ArrayList<InferrenceSupportExtension> arrayList = new ArrayList<InferrenceSupportExtension>();
        if (iExtensionRegistry != null && (iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.ccdt.jsdt.core", EXTENSION_POINT)) != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n2 = 0;
            while (n2 < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n2].getConfigurationElements();
                int n3 = 0;
                while (n3 < iConfigurationElementArray.length) {
                    try {
                        InferrenceProvider inferrenceProvider = null;
                        if (iConfigurationElementArray[n3].getName().equals(TAG_INFERENCE_PROVIDER)) {
                            inferrenceProvider = (InferrenceProvider)iConfigurationElementArray[n3].createExecutableExtension(ATTR_INFERENGINE_CLASS);
                        }
                        InferrenceSupportExtension inferrenceSupportExtension = new InferrenceSupportExtension();
                        inferrenceSupportExtension.inferProvider = inferrenceProvider;
                        arrayList.add(inferrenceSupportExtension);
                    }
                    catch (CoreException coreException) {
                        Util.log(coreException, "Error in loading inference extension");
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        this.c = arrayList.toArray(new InferrenceSupportExtension[arrayList.size()]);
    }
}

