/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.core.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.ccdt.jsdt.internal.compiler.parser.ScannerHelper;
import org.ccdt.jsdt.internal.compiler.util.Util;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.ReplaceEdit;

public final class IndentManipulation {
    private IndentManipulation() {
    }

    public static boolean isIndentChar(char c2) {
        return ScannerHelper.isWhitespace(c2) && !IndentManipulation.isLineDelimiterChar(c2);
    }

    public static boolean isLineDelimiterChar(char c2) {
        return c2 == '\n' || c2 == '\r';
    }

    public static int measureIndentUnits(CharSequence charSequence, int n2, int n3) {
        if (n3 <= 0 || n2 < 0 || charSequence == null) {
            throw new IllegalArgumentException();
        }
        int n4 = IndentManipulation.measureIndentInSpaces(charSequence, n2);
        return n4 / n3;
    }

    public static int measureIndentInSpaces(CharSequence charSequence, int n2) {
        if (n2 < 0 || charSequence == null) {
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        int n4 = charSequence.length();
        int n5 = 0;
        while (n5 < n4) {
            char c2 = charSequence.charAt(n5);
            if (c2 == '\t') {
                int n6 = n3 % n2;
                n3 += n2 - n6;
            } else if (IndentManipulation.isIndentChar(c2)) {
                ++n3;
            } else {
                return n3;
            }
            ++n5;
        }
        return n3;
    }

    public static String extractIndentString(String string, int n2, int n3) {
        if (n2 < 0 || n3 <= 0 || string == null) {
            throw new IllegalArgumentException();
        }
        int n4 = string.length();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n4) {
            char c2 = string.charAt(n8);
            if (c2 == '\t') {
                int n9 = n6 % n2;
                n6 += n2 - n9;
                ++n7;
            } else {
                if (!IndentManipulation.isIndentChar(c2)) break;
                ++n6;
                ++n7;
            }
            if (n6 >= n3) {
                n5 += n7;
                n7 = 0;
                n6 %= n3;
            }
            ++n8;
        }
        if (n5 == 0) {
            return Util.EMPTY_STRING;
        }
        if (n5 == n4) {
            return string;
        }
        return string.substring(0, n5);
    }

    public static String trimIndent(String string, int n2, int n3, int n4) {
        if (n3 < 0 || n4 <= 0 || string == null) {
            throw new IllegalArgumentException();
        }
        if (n2 <= 0) {
            return string;
        }
        int n5 = n2 * n4;
        int n6 = 0;
        int n7 = 0;
        int n8 = string.length();
        String string2 = null;
        int n9 = 0;
        while (n9 < n8) {
            char c2 = string.charAt(n9);
            if (c2 == '\t') {
                int n10 = n7 % n3;
                n7 += n3 - n10;
            } else if (IndentManipulation.isIndentChar(c2)) {
                ++n7;
            } else {
                n6 = n9;
                break;
            }
            if (n7 == n5) {
                n6 = n9 + 1;
                break;
            }
            if (n7 > n5) {
                n6 = n9 + 1;
                char[] cArray = new char[n7 - n5];
                Arrays.fill(cArray, ' ');
                string2 = new String(cArray);
                break;
            }
            ++n9;
        }
        String string3 = n6 == n8 ? Util.EMPTY_STRING : string.substring(n6);
        if (string2 == null) {
            return string3;
        }
        return String.valueOf(string2) + string3;
    }

    public static String changeIndent(String string, int n2, int n3, int n4, String string2, String string3) {
        if (n3 < 0 || n4 <= 0 || string == null || n2 < 0 || string2 == null || string3 == null) {
            throw new IllegalArgumentException();
        }
        try {
            DefaultLineTracker defaultLineTracker = new DefaultLineTracker();
            defaultLineTracker.set(string);
            int n5 = defaultLineTracker.getNumberOfLines();
            if (n5 == 1) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n6 = 0;
            while (n6 < n5) {
                IRegion iRegion = defaultLineTracker.getLineInformation(n6);
                int n7 = iRegion.getOffset();
                int n8 = n7 + iRegion.getLength();
                String string4 = string.substring(n7, n8);
                if (n6 == 0) {
                    stringBuffer.append(string4);
                } else {
                    stringBuffer.append(string3);
                    stringBuffer.append(string2);
                    stringBuffer.append(IndentManipulation.trimIndent(string4, n2, n3, n4));
                }
                ++n6;
            }
            return stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {
            return string;
        }
    }

    public static ReplaceEdit[] getChangeIndentEdits(String string, int n2, int n3, int n4, String string2) {
        if (n3 < 0 || n4 <= 0 || string == null || n2 < 0 || string2 == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<ReplaceEdit> arrayList = new ArrayList<ReplaceEdit>();
        try {
            DefaultLineTracker defaultLineTracker = new DefaultLineTracker();
            defaultLineTracker.set(string);
            int n5 = defaultLineTracker.getNumberOfLines();
            if (n5 == 1) {
                return arrayList.toArray(new ReplaceEdit[arrayList.size()]);
            }
            int n6 = 1;
            while (n6 < n5) {
                IRegion iRegion = defaultLineTracker.getLineInformation(n6);
                int n7 = iRegion.getOffset();
                String string3 = string.substring(n7, n7 + iRegion.getLength());
                int n8 = IndentManipulation.a(string3, n2, n3, n4);
                if (n8 >= 0) {
                    arrayList.add(new ReplaceEdit(n7, n8, string2));
                } else {
                    n8 = IndentManipulation.measureIndentUnits(string3, n3, n4);
                    arrayList.add(new ReplaceEdit(n7, n8, ""));
                }
                ++n6;
            }
        }
        catch (BadLocationException badLocationException) {}
        return arrayList.toArray(new ReplaceEdit[arrayList.size()]);
    }

    private static int a(CharSequence charSequence, int n2, int n3, int n4) {
        int n5 = n2 * n4;
        int n6 = charSequence.length();
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n6 && n8 < n5) {
            char c2 = charSequence.charAt(n9);
            if (c2 == '\t') {
                int n10 = n8 % n3;
                n8 += n3 - n10;
            } else {
                if (!IndentManipulation.isIndentChar(c2)) break;
                ++n8;
            }
            n7 = n9++;
        }
        if (n8 < n5) {
            return -1;
        }
        return n7 + 1;
    }

    public static int getTabWidth(Map map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        return IndentManipulation.a(map, "org.ccdt.jsdt.core.formatter.tabulation.size", 4);
    }

    public static int getIndentWidth(Map map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        int n2 = IndentManipulation.getTabWidth(map);
        boolean bl2 = "mixed".equals(map.get("org.ccdt.jsdt.core.formatter.tabulation.char"));
        if (bl2) {
            return IndentManipulation.a(map, "org.ccdt.jsdt.core.formatter.indentation.size", n2);
        }
        return n2;
    }

    private static int a(Map map, String string, int n2) {
        try {
            return Integer.parseInt((String)map.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }
}

