/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.AdaptableFileTreeIterator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerTreeIterator
extends WorkingTreeIterator {
    private final IContainer node;

    private static String computePrefix(Repository repository, IContainer base) {
        File workTree = repository.getWorkTree();
        IPath location = base.getLocation();
        if (location == null) {
            throw new IllegalArgumentException("Location of container not found: " + base);
        }
        Path workTreePath = new Path(workTree.getAbsolutePath());
        IPath relativePath = location.makeRelativeTo((IPath)workTreePath);
        return relativePath.toString();
    }

    public ContainerTreeIterator(Repository repository, IContainer base) {
        super(ContainerTreeIterator.computePrefix(repository, base), (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY));
        this.node = base;
        this.init(this.entries(false));
        this.initRootIterator(repository);
    }

    public ContainerTreeIterator(Repository repository, IWorkspaceRoot root) {
        super("", (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY));
        this.node = root;
        this.init(this.entries(false));
        this.initRootIterator(repository);
    }

    public ContainerTreeIterator(WorkingTreeIterator p, IContainer base) {
        this(p, base, false);
    }

    private ContainerTreeIterator(WorkingTreeIterator p, IContainer base, boolean hasInheritedResourceFilters) {
        super(p);
        this.node = base;
        this.init(this.entries(hasInheritedResourceFilters));
    }

    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        if (FileMode.TREE.equals(this.mode)) {
            if (this.current() instanceof ResourceEntry) {
                ResourceEntry resourceEntry = (ResourceEntry)this.current();
                return new ContainerTreeIterator(this, (IContainer)resourceEntry.rsrc, resourceEntry.hasInheritedResourceFilters);
            }
            if (this.current() instanceof FileTreeIterator.FileEntry) {
                FileTreeIterator.FileEntry fileEntry = (FileTreeIterator.FileEntry)this.current();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                return new AdaptableFileTreeIterator(this, fileEntry.getFile(), root);
            }
            throw new IllegalStateException("Unknown entry type: " + this.current());
        }
        throw new IncorrectObjectTypeException(ObjectId.zeroId(), "tree");
    }

    public ResourceEntry getResourceEntry() {
        return (ResourceEntry)this.current();
    }

    private WorkingTreeIterator.Entry[] entries(boolean hasInheritedResourceFilters) {
        IResource[] resources;
        try {
            resources = this.node.members(8);
        }
        catch (CoreException coreException) {
            return EOF;
        }
        ArrayList<WorkingTreeIterator.Entry> entries = new ArrayList<WorkingTreeIterator.Entry>(resources.length);
        boolean inheritableResourceFilter = this.addFilteredEntriesIfFiltersActive(hasInheritedResourceFilters, resources, entries);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (!resource.isLinked()) {
                entries.add(new ResourceEntry(resource, inheritableResourceFilter));
            }
            ++n2;
        }
        return entries.toArray(new WorkingTreeIterator.Entry[entries.size()]);
    }

    private boolean addFilteredEntriesIfFiltersActive(boolean hasInheritedResourceFilters, IResource[] memberResources, List<WorkingTreeIterator.Entry> entries) {
        IResourceFilterDescription[] filters;
        boolean inheritableResourceFilter = hasInheritedResourceFilters;
        try {
            filters = this.node.getFilters();
        }
        catch (CoreException coreException) {
            filters = new IResourceFilterDescription[]{};
        }
        if (filters.length != 0 || hasInheritedResourceFilters) {
            int n;
            if (!inheritableResourceFilter) {
                IResourceFilterDescription[] iResourceFilterDescriptionArray = filters;
                n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean inheritable;
                    IResourceFilterDescription filter = iResourceFilterDescriptionArray[n2];
                    boolean bl = inheritable = (filter.getType() & 0x10) != 0;
                    if (inheritable) {
                        inheritableResourceFilter = true;
                    }
                    ++n2;
                }
            }
            HashSet<File> resourceEntries = new HashSet<File>();
            IResource[] iResourceArray = memberResources;
            int n3 = memberResources.length;
            n = 0;
            while (n < n3) {
                IPath location;
                IResource resource = iResourceArray[n];
                if (!resource.isLinked() && (location = resource.getLocation()) != null) {
                    resourceEntries.add(location.toFile());
                }
                ++n;
            }
            this.addFilteredEntries(resourceEntries, entries);
        }
        return inheritableResourceFilter;
    }

    private void addFilteredEntries(Set<File> existingResourceEntries, List<WorkingTreeIterator.Entry> addToEntries) {
        IPath containerLocation = this.node.getLocation();
        if (containerLocation == null) {
            return;
        }
        File folder = containerLocation.toFile();
        File[] children = folder.listFiles();
        if (children == null) {
            return;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (!existingResourceEntries.contains(child)) {
                Path childLocation = new Path(child.getAbsolutePath());
                IWorkspaceRoot root = this.node.getWorkspace().getRoot();
                IContainer container = root.getContainerForLocation((IPath)childLocation);
                if (container != null && container.isAccessible()) {
                    addToEntries.add(new ResourceEntry((IResource)container, false));
                } else {
                    addToEntries.add((WorkingTreeIterator.Entry)new FileTreeIterator.FileEntry(child, FS.DETECTED));
                }
            }
            ++n2;
        }
    }

    private static File asFile(IResource resource) {
        IPath location = resource.getLocation();
        return location != null ? location.toFile() : null;
    }

    protected byte[] idSubmodule(WorkingTreeIterator.Entry e) {
        File nodeFile = ContainerTreeIterator.asFile((IResource)this.node);
        if (nodeFile != null) {
            return this.idSubmodule(nodeFile, e);
        }
        return super.idSubmodule(e);
    }

    public static class ResourceEntry
    extends WorkingTreeIterator.Entry {
        final IResource rsrc;
        final boolean hasInheritedResourceFilters;
        private final FileMode mode;
        private long length = -1L;

        ResourceEntry(IResource f, boolean hasInheritedResourceFilters) {
            this.rsrc = f;
            this.hasInheritedResourceFilters = hasInheritedResourceFilters;
            switch (f.getType()) {
                case 1: {
                    File file = this.asFile();
                    if (FS.DETECTED.supportsExecute() && file != null && FS.DETECTED.canExecute(file)) {
                        this.mode = FileMode.EXECUTABLE_FILE;
                        break;
                    }
                    this.mode = FileMode.REGULAR_FILE;
                    break;
                }
                case 2: 
                case 4: {
                    IContainer c = (IContainer)f;
                    if (c.findMember(".git") != null) {
                        this.mode = FileMode.GITLINK;
                        break;
                    }
                    this.mode = FileMode.TREE;
                    break;
                }
                default: {
                    this.mode = FileMode.MISSING;
                }
            }
        }

        public FileMode getMode() {
            return this.mode;
        }

        public String getName() {
            if (this.rsrc.getType() == 4) {
                return this.rsrc.getLocation().lastSegment();
            }
            return this.rsrc.getName();
        }

        public long getLength() {
            if (this.length < 0L) {
                File file;
                this.length = this.rsrc instanceof IFile ? ((file = this.asFile()) != null ? file.length() : 0L) : 0L;
            }
            return this.length;
        }

        public long getLastModified() {
            return this.rsrc.getLocalTimeStamp();
        }

        public InputStream openInputStream() throws IOException {
            if (this.rsrc.getType() == 1) {
                try {
                    return ((IFile)this.rsrc).getContents(true);
                }
                catch (CoreException err) {
                    IOException ioe = new IOException(err.getMessage());
                    ioe.initCause(err);
                    throw ioe;
                }
            }
            throw new IOException("Not a regular file: " + this.rsrc);
        }

        public IResource getResource() {
            return this.rsrc;
        }

        private File asFile() {
            return ContainerTreeIterator.asFile(this.rsrc);
        }
    }
}

