/*
 * Decompiled with CFR 0.152.
 */
package com.tetrade.eclipse.plugins.easyshell.preferences;

import com.tetrade.eclipse.plugins.easyshell.EasyShellPlugin;
import com.tetrade.eclipse.plugins.easyshell.preferences.EasyShellPreferencePage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * Exception performing whole class analysis ignored.
 */
public class EasyShellPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_TARGET = "targetPreference";
    public static final String P_TARGET_RUN = "targetRunPreference";
    public static final String P_TARGET_EXPLORE = "targetExplorePreference";
    public static final String P_TARGET_COPYPATH = "targetCopyPathPreference";
    public static final String P_LIST = "listPreference";
    public static final String P_LIST_STR = "IdStr";
    public static final String P_QUOTES_LIST_STR = "QuotesStr";
    public static final String P_DEBUG_LIST_STR = "DebugStr";
    public static final String P_TOKENIZER_LIST_STR = "TokenizerStr";
    private Combo targetCombo = null;
    private StringFieldEditor targetOpenEditor = null;
    private StringFieldEditor targetRunEditor = null;
    private StringFieldEditor targetExploreEditor = null;
    private StringFieldEditor targetCopyPathEditor = null;
    private Combo quotesCombo = null;
    private Combo debugCombo = null;
    private Combo TokenizerCombo = null;

    public EasyShellPreferencePage() {
        this.setPreferenceStore(EasyShellPlugin.getDefault().getPreferenceStore());
        this.setDescription("Set up a shell command window.");
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        EasyShellCommand cmd = this.getProperCommand();
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault("targetPreference", cmd.getOpenCmd());
        store.setDefault("targetRunPreference", cmd.getRunCmd());
        store.setDefault("targetExplorePreference", cmd.getExploreCmd());
        store.setDefault("targetCopyPathPreference", cmd.getCopyPathCmd());
        store.setDefault("listPreference", cmd.getId() - 1);
        store.setDefault("IdStr", cmd.name());
        store.setDefault("QuotesStr", EasyShellQuotes.quotesNo.name());
        store.setDefault("DebugStr", EasyShellDebug.debugNo.name());
        store.setDefault("TokenizerStr", EasyShellTokenizer.EasyShellTokenizerYes.name());
    }

    protected Control createContents(Composite parent) {
        Composite mainColumn = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout(1, false);
        mainColumn.setFont(parent.getFont());
        mainColumn.setLayout((Layout)mainLayout);
        Composite targetColumn = new Composite(mainColumn, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        targetColumn.setFont(parent.getFont());
        targetColumn.setLayout((Layout)layout);
        Label label = new Label(targetColumn, 0);
        label.setText("Presets");
        this.targetCombo = new Combo(targetColumn, 12);
        int i = 0;
        while (i < EasyShellCommand.values().length) {
            this.targetCombo.add(EasyShellCommand.getFromId((int)i).getLabel());
            ++i;
        }
        this.targetCombo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        String targetTooltip = "Please enable string tokenizer to pass parameters automatically to command line (prefered solution - quotes not needed).\nOR/AND use double quotes or two single quotes if you want enclose expanded arguments.";
        this.targetOpenEditor = new StringFieldEditor("targetPreference", "&Shell Open command:", targetColumn);
        this.targetOpenEditor.getLabelControl(targetColumn).setToolTipText(targetTooltip);
        this.targetRunEditor = new StringFieldEditor("targetRunPreference", "&Shell Run command:", targetColumn);
        this.targetRunEditor.getLabelControl(targetColumn).setToolTipText(targetTooltip);
        this.targetExploreEditor = new StringFieldEditor("targetExplorePreference", "&Explore command:", targetColumn);
        this.targetExploreEditor.getLabelControl(targetColumn).setToolTipText(targetTooltip);
        this.targetCopyPathEditor = new StringFieldEditor("targetCopyPathPreference", "Copy Path string:", targetColumn);
        this.targetCopyPathEditor.getLabelControl(targetColumn).setToolTipText(targetTooltip);
        Label tokenizer = new Label(targetColumn, 0);
        tokenizer.setText("Enable string tokenizer");
        tokenizer.setToolTipText("Constructs a string tokenizer for the specified string. The tokenizer uses the default delimiter set,\nwhich is \" \\t\\n\\r\\f\": the space character, the tab character, the newline character,\nthe carriage-return character, and the form-feed character.\nATTENTION: please use it carefully with Add quotes!");
        this.TokenizerCombo = new Combo(targetColumn, 12);
        int i2 = 0;
        while (i2 < EasyShellTokenizer.values().length) {
            this.TokenizerCombo.add(EasyShellTokenizer.getFromId((int)i2).getMode());
            ++i2;
        }
        Label quotes = new Label(targetColumn, 0);
        quotes.setText("Add quotes to {1}, {2}, {3}*");
        quotes.setToolTipText("Quotes will be added to given parameters.\nATTENTION: please use it carefully with enabled string tokenizer!");
        this.quotesCombo = new Combo(targetColumn, 12);
        int i3 = 0;
        while (i3 < EasyShellQuotes.values().length) {
            this.quotesCombo.add(EasyShellQuotes.getFromId((int)i3).getMode());
            ++i3;
        }
        Label debug = new Label(targetColumn, 0);
        debug.setText("Enable debug output");
        debug.setToolTipText("Debug messages will be printed to error console.");
        this.debugCombo = new Combo(targetColumn, 12);
        int i4 = 0;
        while (i4 < EasyShellDebug.values().length) {
            this.debugCombo.add(EasyShellDebug.getFromId((int)i4).getMode());
            ++i4;
        }
        label = new Label(mainColumn, 0);
        label.setText("Argument {0} is the drive letter on Win32");
        label = new Label(mainColumn, 0);
        label.setText("Argument {1} is the parent path*");
        label = new Label(mainColumn, 0);
        label.setText("Argument {2} is the full path*");
        label = new Label(mainColumn, 0);
        label.setText("Argument {3} is the file name*");
        label = new Label(mainColumn, 0);
        label.setText("Argument {4} is the project name");
        label = new Label(mainColumn, 0);
        label.setText("Argument {5} is the line separator");
        this.loadStore();
        return mainColumn;
    }

    private boolean loadStore() {
        IPreferenceStore store = this.getPreferenceStore();
        this.targetCombo.select(store.getInt("listPreference") + 1);
        String IdStr = store.getString("IdStr");
        if (IdStr != null && IdStr.length() > 0) {
            this.targetCombo.select(EasyShellCommand.valueOf((String)IdStr).getId());
        }
        EasyShellPlugin.getDefault().sysout(true, "Open Value      : >" + store.getString("targetPreference") + "<");
        EasyShellPlugin.getDefault().sysout(true, "Open Default    : >" + store.getDefaultString("targetPreference") + "<");
        this.targetOpenEditor.setStringValue(store.getString("targetPreference"));
        EasyShellPlugin.getDefault().sysout(true, "Run Value       : >" + store.getString("targetRunPreference") + "<");
        EasyShellPlugin.getDefault().sysout(true, "Run Default     : >" + store.getDefaultString("targetRunPreference") + "<");
        this.targetRunEditor.setStringValue(store.getString("targetRunPreference"));
        EasyShellPlugin.getDefault().sysout(true, "Explore Value   : >" + store.getString("targetExplorePreference") + "<");
        EasyShellPlugin.getDefault().sysout(true, "Explore Default : >" + store.getDefaultString("targetExplorePreference") + "<");
        this.targetExploreEditor.setStringValue(store.getString("targetExplorePreference"));
        EasyShellPlugin.getDefault().sysout(true, "Copypath Value  : >" + store.getString("targetCopyPathPreference") + "<");
        EasyShellPlugin.getDefault().sysout(true, "Copypath Default: >" + store.getDefaultString("targetCopyPathPreference") + "<");
        this.targetCopyPathEditor.setStringValue(store.getString("targetCopyPathPreference"));
        this.quotesCombo.select(EasyShellQuotes.quotesNo.getId());
        String QuotesStr = store.getString("QuotesStr");
        if (QuotesStr != null && QuotesStr.length() > 0) {
            this.quotesCombo.select(EasyShellQuotes.valueOf((String)QuotesStr).getId());
        }
        this.debugCombo.select(EasyShellDebug.debugNo.getId());
        String DebugStr = store.getString("DebugStr");
        if (DebugStr != null && DebugStr.length() > 0) {
            this.debugCombo.select(EasyShellDebug.valueOf((String)DebugStr).getId());
        }
        this.TokenizerCombo.select(EasyShellTokenizer.EasyShellTokenizerYes.getId());
        String TokenizerStr = store.getString("TokenizerStr");
        if (TokenizerStr != null && TokenizerStr.length() > 0) {
            this.TokenizerCombo.select(EasyShellTokenizer.valueOf((String)TokenizerStr).getId());
        }
        return true;
    }

    private boolean saveStore() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("targetPreference", this.targetOpenEditor.getStringValue());
        store.setValue("targetRunPreference", this.targetRunEditor.getStringValue());
        store.setValue("targetExplorePreference", this.targetExploreEditor.getStringValue());
        store.setValue("targetCopyPathPreference", this.targetCopyPathEditor.getStringValue());
        store.setValue("listPreference", this.targetCombo.getSelectionIndex() - 1);
        store.setValue("IdStr", EasyShellCommand.getFromId((int)this.targetCombo.getSelectionIndex()).name());
        store.setValue("QuotesStr", EasyShellQuotes.getFromId((int)this.quotesCombo.getSelectionIndex()).name());
        store.setValue("DebugStr", EasyShellDebug.getFromId((int)this.debugCombo.getSelectionIndex()).name());
        store.setValue("TokenizerStr", EasyShellTokenizer.getFromId((int)this.TokenizerCombo.getSelectionIndex()).name());
        return true;
    }

    private void refreshTarget() {
        int index = this.targetCombo.getSelectionIndex();
        EasyShellCommand cmd = EasyShellCommand.getFromId((int)index);
        this.targetOpenEditor.setStringValue(cmd.getOpenCmd());
        this.targetRunEditor.setStringValue(cmd.getRunCmd());
        this.targetExploreEditor.setStringValue(cmd.getExploreCmd());
        this.targetCopyPathEditor.setStringValue(cmd.getCopyPathCmd());
    }

    private void setToDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setToDefault("targetPreference");
        store.setToDefault("targetRunPreference");
        store.setToDefault("targetExplorePreference");
        store.setToDefault("targetCopyPathPreference");
        store.setToDefault("listPreference");
        store.setToDefault("IdStr");
        store.setToDefault("QuotesStr");
        store.setToDefault("DebugStr");
        store.setToDefault("TokenizerStr");
    }

    public boolean performOk() {
        return this.saveStore();
    }

    public void performDefaults() {
        this.initializeDefaults();
        this.setToDefaults();
        this.loadStore();
    }

    public void init(IWorkbench workbench) {
    }

    private EasyShellCommand getProperCommand() {
        EasyShellCommand cmd = EasyShellCommand.cmdUnknown;
        String osname = System.getProperty("os.name", "").toLowerCase();
        if (osname.indexOf("windows") != -1) {
            cmd = EasyShellCommand.cmdWinDOS;
        } else if (osname.indexOf("mac os x") != -1) {
            cmd = EasyShellCommand.cmdTerminalFinder;
        } else if (osname.indexOf("unix") != -1 || osname.indexOf("irix") != -1 || osname.indexOf("freebsd") != -1 || osname.indexOf("hp-ux") != -1 || osname.indexOf("aix") != -1 || osname.indexOf("sunos") != -1 || osname.indexOf("linux") != -1) {
            LinuxDesktop desktop = this.detectDesktopNew();
            if (desktop == LinuxDesktop.desktopKde) {
                cmd = EasyShellCommand.cmdKonsoleKDEDolphin;
            } else if (desktop == LinuxDesktop.desktopGnome) {
                cmd = EasyShellCommand.cmdKonsoleGnome;
            } else if (desktop == LinuxDesktop.desktopCde) {
                cmd = EasyShellCommand.cmdXtermDtfile;
            }
        }
        return cmd;
    }

    private LinuxDesktop detectDesktop() {
        LinuxDesktop resultCode = LinuxDesktop.desktopUnknown;
        try {
            String[] cmd = new String[]{"env"};
            Process proc = Runtime.getRuntime().exec(cmd);
            BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = in.readLine()) != null && resultCode == LinuxDesktop.desktopUnknown) {
                if (line.indexOf("KDE") != -1) {
                    resultCode = LinuxDesktop.desktopKde;
                    continue;
                }
                if (line.toLowerCase().indexOf("gnome") == -1) continue;
                resultCode = LinuxDesktop.desktopGnome;
            }
            BufferedReader err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            line = null;
            while ((line = err.readLine()) != null) {
                EasyShellPlugin.getDefault().sysout(true, "detectDesktop stderr >" + line + "<");
            }
            int result = proc.waitFor();
            if (result != 0) {
                EasyShellPlugin.getDefault().sysout(true, "detectDesktop return code: " + result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resultCode == LinuxDesktop.desktopUnknown) {
            resultCode = LinuxDesktop.desktopCde;
        }
        return resultCode;
    }

    private LinuxDesktop detectDesktopNew() {
        LinuxDesktop resultCode = LinuxDesktop.desktopUnknown;
        if (this.isKDE()) {
            resultCode = LinuxDesktop.desktopKde;
        } else if (this.isGnome()) {
            resultCode = LinuxDesktop.desktopGnome;
        } else if (this.isCde()) {
            resultCode = LinuxDesktop.desktopCde;
        }
        return resultCode;
    }

    private boolean isKDE() {
        boolean kde = false;
        String[] cmd = new String[]{"echo", "$KDE_FULL_SESSION"};
        kde = this.isExpectedCommandOutput(cmd, "true", true);
        if (!kde) {
            cmd[1] = "$DESKTOP_SESSION";
            kde = this.isExpectedCommandOutput(cmd, "kde", true);
        }
        return kde;
    }

    private boolean isGnome() {
        boolean gnome = false;
        String[] cmd = new String[]{"echo", "$GNOME_DESKTOP_SESSION_ID"};
        gnome = this.isExpectedCommandOutput(cmd, "*", true);
        if (!gnome) {
            cmd[1] = "$DESKTOP_SESSION";
            gnome = this.isExpectedCommandOutput(cmd, "gnome", true);
        }
        return gnome;
    }

    private boolean isCde() {
        return false;
    }

    private boolean isExpectedCommandOutput(String[] command, String expectedOutput, boolean toLowerCase) {
        boolean found = false;
        try {
            Process proc = Runtime.getRuntime().exec(command);
            BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = in.readLine()) != null && !found) {
                if (expectedOutput.indexOf("*") != -1) {
                    if (line.isEmpty()) {
                        found = false;
                        break;
                    }
                    found = true;
                    continue;
                }
                if (toLowerCase) {
                    line = line.toLowerCase();
                }
                if (line.indexOf(expectedOutput) == -1) continue;
                found = true;
            }
            BufferedReader err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            line = null;
            while ((line = err.readLine()) != null) {
                EasyShellPlugin.getDefault().sysout(true, "detectDesktop stderr >" + line + "<");
            }
            int result = proc.waitFor();
            if (result != 0) {
                EasyShellPlugin.getDefault().sysout(true, "detectDesktop return code: " + result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return found;
    }

    static /* synthetic */ void access$0(EasyShellPreferencePage easyShellPreferencePage) {
        easyShellPreferencePage.refreshTarget();
    }
}

