/*
 * Decompiled with CFR 0.152.
 */
package com.tetrade.eclipse.plugins.easyshell.actions;

import com.tetrade.eclipse.plugins.easyshell.EasyShellPlugin;
import com.tetrade.eclipse.plugins.easyshell.Resource;
import com.tetrade.eclipse.plugins.easyshell.ResourceUtils;
import com.tetrade.eclipse.plugins.easyshell.preferences.EasyShellPreferencePage;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class EasyShellAction
implements IObjectActionDelegate {
    private Resource[] resource = null;
    private IStructuredSelection currentSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (!this.isEnabled()) {
            MessageDialog.openInformation((Shell)new Shell(), (String)"Easy Shell", (String)"Wrong Selection");
            EasyShellPlugin.log((Object)"Wrong Selection");
            return;
        }
        String ActionIDStr = action.getId();
        EasyShellPlugin.getDefault().sysout(true, "Action ID: >" + ActionIDStr + "<");
        String[] EasyShellActionStr = new String[]{"com.tetrade.eclipse.plugins.easyshell.command.shellOpen", "com.tetrade.eclipse.plugins.easyshell.command.shellRun", "com.tetrade.eclipse.plugins.easyshell.command.shellExplore", "com.tetrade.eclipse.plugins.easyshell.command.copyPath"};
        int ActionIDNum = -1;
        int i = 0;
        while (i < EasyShellActionStr.length) {
            if (ActionIDStr.equals(EasyShellActionStr[i])) {
                ActionIDNum = i;
                break;
            }
            ++i;
        }
        if (ActionIDNum == -1) {
            MessageDialog.openInformation((Shell)new Shell(), (String)"Easy Shell", (String)"Wrong Action ID");
            EasyShellPlugin.log((Object)"Wrong Action ID");
            return;
        }
        String cmdAll = null;
        if (ActionIDNum == 3) {
            cmdAll = new String();
        }
        int i2 = 0;
        while (i2 < this.resource.length) {
            block19: {
                if (this.resource[i2] != null) {
                    String drive = null;
                    String full_path = null;
                    String parent_path = null;
                    String file_name = null;
                    full_path = this.resource[i2].getFile().toString();
                    if (this.resource[i2].getFile().isDirectory()) {
                        parent_path = this.resource[i2].getFile().getPath();
                        file_name = "dir";
                    } else {
                        parent_path = this.resource[i2].getFile().getParent();
                        file_name = this.resource[i2].getFile().getName();
                    }
                    if (full_path != null) {
                        EasyShellPlugin.getDefault().sysout(true, "full_path  : >" + full_path + "<");
                        EasyShellPlugin.getDefault().sysout(true, "parent_path: >" + parent_path + "<");
                        EasyShellPlugin.getDefault().sysout(true, "file_name  : >" + file_name + "<");
                        if (full_path.indexOf(":") != -1) {
                            drive = full_path.substring(0, full_path.indexOf(":"));
                        }
                        try {
                            String cmd;
                            String target = EasyShellPlugin.getDefault().getTarget(ActionIDNum);
                            EasyShellPreferencePage.EasyShellQuotes quotes = EasyShellPlugin.getDefault().getQuotes();
                            Object[] args = new String[6];
                            args[0] = drive;
                            args[1] = this.autoQuotes(parent_path, quotes);
                            args[2] = this.autoQuotes(full_path, quotes);
                            args[3] = this.autoQuotes(file_name, quotes);
                            args[4] = this.resource[i2].getProjectName();
                            if (args[4] == null) {
                                args[4] = "EasyShell";
                            }
                            args[5] = System.getProperty("line.separator");
                            if (ActionIDNum == 3) {
                                cmd = this.fixQuotes(MessageFormat.format(target, args), quotes);
                                EasyShellPlugin.getDefault().sysout(true, "--- clp: >");
                                cmdAll = String.valueOf(cmdAll) + cmd;
                                EasyShellPlugin.getDefault().sysout(true, cmd);
                                EasyShellPlugin.getDefault().sysout(true, "--- clp: <");
                                break block19;
                            }
                            if (EasyShellPlugin.getDefault().isTokenizer()) {
                                StringTokenizer st = new StringTokenizer(target);
                                String[] cmds = new String[st.countTokens()];
                                int c = 0;
                                EasyShellPlugin.getDefault().sysout(true, "--- cmd: >");
                                while (st.hasMoreElements()) {
                                    cmds[c] = this.fixQuotes(MessageFormat.format(st.nextToken(), args), quotes);
                                    EasyShellPlugin.getDefault().sysout(true, cmds[c]);
                                    ++c;
                                }
                                EasyShellPlugin.getDefault().sysout(true, "--- cmd: <");
                                Runtime.getRuntime().exec(cmds);
                                break block19;
                            }
                            cmd = this.fixQuotes(MessageFormat.format(target, args), quotes);
                            EasyShellPlugin.getDefault().sysout(true, "--- cmd: >");
                            Runtime.getRuntime().exec(cmd);
                            EasyShellPlugin.getDefault().sysout(true, cmd);
                            EasyShellPlugin.getDefault().sysout(true, "--- cmd: <");
                        }
                        catch (Exception e) {
                            EasyShellPlugin.log((Throwable)e);
                        }
                    } else {
                        MessageDialog.openInformation((Shell)new Shell(), (String)"Easy Shell", (String)"Unable to open shell");
                        EasyShellPlugin.log((Object)"Unable to open shell");
                        return;
                    }
                }
            }
            ++i2;
        }
        if (ActionIDNum == 3 && cmdAll != null && cmdAll.length() != 0) {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            TextTransfer textTransfer = TextTransfer.getInstance();
            Transfer[] transfers = new Transfer[]{textTransfer};
            Object[] data = new Object[]{cmdAll};
            clipboard.setContents(data, transfers);
            clipboard.dispose();
        }
    }

    private String autoQuotes(String str, EasyShellPreferencePage.EasyShellQuotes quotes) {
        String ret = quotes == EasyShellPreferencePage.EasyShellQuotes.quotesSingle ? "'" + str + "'" : (quotes == EasyShellPreferencePage.EasyShellQuotes.quotesDouble ? "\"" + str + "\"" : (quotes == EasyShellPreferencePage.EasyShellQuotes.quotesAuto && str.indexOf("\"") == -1 && str.indexOf(" ") != -1 ? "\"" + str + "\"" : str));
        return ret;
    }

    private String fixQuotes(String str, EasyShellPreferencePage.EasyShellQuotes quotes) {
        String ret = str;
        return ret;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    public boolean isEnabled() {
        Object[] selectedObjects;
        boolean enabled = false;
        if (this.currentSelection != null && (selectedObjects = this.currentSelection.toArray()).length >= 1) {
            this.resource = new Resource[selectedObjects.length];
            int i = 0;
            while (i < selectedObjects.length) {
                this.resource[i] = ResourceUtils.getResource((Object)selectedObjects[i]);
                if (this.resource[i] != null) {
                    enabled = true;
                }
                ++i;
            }
        }
        return enabled;
    }
}

