/*
 * Decompiled with CFR 0.152.
 */
package com.tetrade.eclipse.plugins.easyshell;

import com.tetrade.eclipse.plugins.easyshell.preferences.EasyShellPreferencePage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * Exception performing whole class analysis ignored.
 */
public class EasyShellPlugin
extends AbstractUIPlugin {
    private static EasyShellPlugin plugin;
    private ResourceBundle resourceBundle;

    public EasyShellPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.easyexplore.EasyExplorePluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static EasyShellPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = EasyShellPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void log(Object msg) {
        ILog log = EasyShellPlugin.getDefault().getLog();
        Status status = new Status(4, EasyShellPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, msg + "\n", null);
        log.log((IStatus)status);
    }

    public static void log(Throwable ex) {
        ILog log = EasyShellPlugin.getDefault().getLog();
        StringWriter stringWriter = new StringWriter();
        ex.printStackTrace(new PrintWriter(stringWriter));
        String msg = stringWriter.getBuffer().toString();
        Status status = new Status(4, EasyShellPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, msg, null);
        log.log((IStatus)status);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        EasyShellPreferencePage pref = new EasyShellPreferencePage();
        store = pref.getPreferenceStore();
        super.initializeDefaultPreferences(store);
    }

    public String getTarget(int num) {
        if (num == 0) {
            return this.getPreferenceStore().getString("targetPreference");
        }
        if (num == 1) {
            return this.getPreferenceStore().getString("targetRunPreference");
        }
        if (num == 2) {
            return this.getPreferenceStore().getString("targetExplorePreference");
        }
        if (num == 3) {
            return this.getPreferenceStore().getString("targetCopyPathPreference");
        }
        return null;
    }

    public EasyShellPreferencePage.EasyShellQuotes getQuotes() {
        return EasyShellPreferencePage.EasyShellQuotes.valueOf((String)this.getPreferenceStore().getString("QuotesStr"));
    }

    public boolean isDebug() {
        String dbgStr = this.getPreferenceStore().getString("DebugStr");
        if (dbgStr != null && dbgStr.length() != 0) {
            return EasyShellPreferencePage.EasyShellDebug.valueOf((String)dbgStr) == EasyShellPreferencePage.EasyShellDebug.debugYes;
        }
        return false;
    }

    public boolean isTokenizer() {
        String tokenizerStr = this.getPreferenceStore().getString("TokenizerStr");
        if (tokenizerStr != null && tokenizerStr.length() != 0) {
            return EasyShellPreferencePage.EasyShellTokenizer.valueOf((String)tokenizerStr) == EasyShellPreferencePage.EasyShellTokenizer.EasyShellTokenizerYes;
        }
        return false;
    }

    public void sysout(boolean dbg, String str) {
        if (!dbg || dbg && this.isDebug()) {
            System.out.println("[EasyShell] " + str);
        }
    }
}

