/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.core.ICodeAssist;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.commands.IDbgpExtendedCommands;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.ScriptDebugModelPresentation;
import org.eclipse.dltk.internal.debug.core.model.ScriptValue;
import org.eclipse.dltk.internal.debug.core.model.ScriptVariable;
import org.eclipse.dltk.internal.debug.ui.ExpressionInformationControlCreator;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.hover.IScriptEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public abstract class ScriptDebugHover
implements IScriptEditorTextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private IEditorPart editor;

    public void setEditor(IEditorPart editor) {
        this.editor = editor;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return ScriptWordFinder.findWord((IDocument)textViewer.getDocument(), (int)offset);
    }

    protected IScriptStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            return (IScriptStackFrame)adaptable.getAdapter(IScriptStackFrame.class);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IScriptStackFrame frame = this.getFrame();
        if (frame == null || this.editor == null) {
            return null;
        }
        IEditorInput input = this.editor.getEditorInput();
        ISourceModule element = DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input);
        if (!(element instanceof ICodeAssist)) {
            return null;
        }
        ICodeAssist codeAssist = (ICodeAssist)element;
        IModelElement[] resolve = null;
        try {
            resolve = codeAssist.codeSelect(hoverRegion.getOffset(), hoverRegion.getLength());
            IDbgpSession session = frame.getScriptThread().getDbgpSession();
            IDbgpExtendedCommands extended = session.getExtendedCommands();
            int i = 0;
            while (i < resolve.length) {
                IModelElement scriptElement = resolve[i];
                if (scriptElement instanceof IField) {
                    IField field = (IField)scriptElement;
                    String snippet = this.getFieldProperty(field);
                    try {
                        IDbgpProperty property = extended.evaluate(snippet);
                        return this.getResultText(snippet, ScriptValue.createValue((IScriptStackFrame)frame, (IDbgpProperty)property));
                    }
                    catch (DebugException debugException) {}
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        IScriptStackFrame frame = this.getFrame();
        if (frame == null || this.editor == null) {
            return null;
        }
        IEditorInput input = this.editor.getEditorInput();
        ISourceModule element = DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input);
        if (!(element instanceof ICodeAssist)) {
            return null;
        }
        ICodeAssist codeAssist = (ICodeAssist)element;
        IModelElement[] resolve = null;
        try {
            resolve = codeAssist.codeSelect(hoverRegion.getOffset(), hoverRegion.getLength());
            IDbgpSession session = frame.getScriptThread().getDbgpSession();
            IDbgpExtendedCommands extended = session.getExtendedCommands();
            String selection = this.getTextSelection(hoverRegion);
            if (selection != null && !"".equals(selection)) {
                IDbgpProperty property = extended.evaluate(selection);
                return new ScriptVariable(frame, selection, property);
            }
            int i = 0;
            while (i < resolve.length) {
                IModelElement scriptElement = resolve[i];
                if (scriptElement instanceof IField) {
                    IField field = (IField)scriptElement;
                    String snippet = this.getFieldProperty(field);
                    IDbgpProperty property = extended.evaluate(snippet);
                    return new ScriptVariable(frame, snippet, property);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected String getFieldProperty(IField field) {
        String snippet = field.getElementName();
        return snippet;
    }

    protected String getTextSelection(IRegion hoverRegion) {
        if (this.editor instanceof AbstractTextEditor) {
            final AbstractTextEditor textEditor = (AbstractTextEditor)this.editor;
            final ArrayList selectionList = new ArrayList(1);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ISelection selection = textEditor.getSelectionProvider().getSelection();
                    selectionList.add(selection);
                }
            });
            if (selectionList.size() == 1 && selectionList.get(0) instanceof TextSelection) {
                TextSelection textSelection = (TextSelection)selectionList.get(0);
                if (textSelection.getStartLine() != textSelection.getEndLine()) {
                    return null;
                }
                if (hoverRegion.getOffset() < textSelection.getOffset() || hoverRegion.getOffset() > textSelection.getOffset() + textSelection.getLength()) {
                    return null;
                }
                return textSelection.getText();
            }
        }
        return null;
    }

    protected String getResultText(String snippet, IScriptValue value) throws DebugException {
        String str = this.getModelPresentation().getText(value);
        return this.prepareHtml(String.valueOf(snippet) + " = " + str);
    }

    protected String getVariableText(IVariable variable) throws DebugException {
        return this.prepareHtml(this.getModelPresentation().getText(variable));
    }

    protected String prepareHtml(String text) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<p><pre>");
        buffer.append(ScriptDebugHover.replaceHTMLChars(text));
        buffer.append("</pre></p>");
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    private static String replaceHTMLChars(String variableText) {
        StringBuffer buffer = new StringBuffer(variableText.length());
        char[] characters = variableText.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            switch (character) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(character);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static boolean getBooleanPreferenceValue(String id, String preference) {
        String compositeKey = String.valueOf(id) + "." + preference;
        IPreferenceStore store = DLTKDebugUIPlugin.getDefault().getPreferenceStore();
        boolean value = false;
        value = store.contains(compositeKey) ? store.getBoolean(compositeKey) : store.getBoolean(preference);
        return value;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new ExpressionInformationControlCreator();
    }

    protected abstract ScriptDebugModelPresentation getModelPresentation();
}

