/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core.manipulation;

import java.util.regex.Pattern;
import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.IJavaScriptProject;
import org.ccdt.jsdt.core.IPackageFragmentRoot;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;

public class JavaElementPropertyTester
extends PropertyTester {
    public static final String NAME = "name";
    public static final String IS_IN_JAVA_PROJECT = "isInJavaProject";
    public static final String IS_IN_JAVA_PROJECT_WITH_NATURE = "isInJavaProjectWithNature";
    public static final String IS_ON_CLASSPATH = "isOnClasspath";
    public static final String HAS_TYPE_ON_CLASSPATH = "hasTypeOnClasspath";
    public static final String IN_SOURCE_FOLDER = "inSourceFolder";
    public static final String IN_ARCHIVE = "inArchive";
    public static final String IN_EXTERNAL_ARCHIVE = "inExternalArchive";
    public static final String PROJECT_OPTION = "projectOption";

    public boolean test(Object object, String string, Object[] objectArray, Object object2) {
        IJavaScriptProject iJavaScriptProject;
        if (!(object instanceof IJavaScriptElement)) {
            return false;
        }
        IJavaScriptElement iJavaScriptElement = (IJavaScriptElement)object;
        if (string.equals(NAME)) {
            return Pattern.matches(this.toString(object2), iJavaScriptElement.getElementName());
        }
        if (string.equals(IS_IN_JAVA_PROJECT)) {
            IJavaScriptProject iJavaScriptProject2 = iJavaScriptElement.getJavaScriptProject();
            return iJavaScriptProject2 != null && iJavaScriptProject2.exists() && iJavaScriptProject2.getProject().isOpen();
        }
        if (string.equals(IS_IN_JAVA_PROJECT_WITH_NATURE)) {
            IJavaScriptProject iJavaScriptProject3 = iJavaScriptElement.getJavaScriptProject();
            if (iJavaScriptProject3 != null && iJavaScriptProject3.exists() && iJavaScriptProject3.getProject().isOpen() && object2 != null) {
                try {
                    return iJavaScriptProject3.getProject().hasNature(this.toString(object2));
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            return false;
        }
        if (string.equals(IS_ON_CLASSPATH)) {
            IJavaScriptProject iJavaScriptProject4 = iJavaScriptElement.getJavaScriptProject();
            if (iJavaScriptProject4 != null && iJavaScriptProject4.exists()) {
                return iJavaScriptProject4.isOnIncludepath(iJavaScriptElement);
            }
            return false;
        }
        if (string.equals(IN_SOURCE_FOLDER)) {
            IJavaScriptElement iJavaScriptElement2 = iJavaScriptElement.getAncestor(3);
            if (iJavaScriptElement2 != null) {
                try {
                    return ((IPackageFragmentRoot)iJavaScriptElement2).getKind() == 1;
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            return false;
        }
        if (string.equals(IN_ARCHIVE)) {
            IJavaScriptElement iJavaScriptElement3 = iJavaScriptElement.getAncestor(3);
            if (iJavaScriptElement3 != null) {
                return ((IPackageFragmentRoot)iJavaScriptElement3).isArchive();
            }
            return false;
        }
        if (string.equals(IN_EXTERNAL_ARCHIVE)) {
            IJavaScriptElement iJavaScriptElement4 = iJavaScriptElement.getAncestor(3);
            if (iJavaScriptElement4 != null) {
                return ((IPackageFragmentRoot)iJavaScriptElement4).isExternal();
            }
            return false;
        }
        if (string.equals(PROJECT_OPTION)) {
            IJavaScriptProject iJavaScriptProject5 = iJavaScriptElement.getJavaScriptProject();
            if (iJavaScriptProject5 != null) {
                if (objectArray.length == 2) {
                    String string2 = iJavaScriptProject5.getOption(this.toString(objectArray[0]), true);
                    return string2 != null && string2.equals(objectArray[1]);
                }
                if (objectArray.length == 1) {
                    return iJavaScriptProject5.getOption(this.toString(objectArray[0]), false) != null;
                }
            }
            return false;
        }
        if (string.equals(HAS_TYPE_ON_CLASSPATH) && (iJavaScriptProject = iJavaScriptElement.getJavaScriptProject()) != null && iJavaScriptProject.exists()) {
            try {
                return iJavaScriptProject.findType(this.toString(object2)) != null;
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return false;
            }
        }
        return false;
    }

    private String toString(Object object) {
        return object == null ? "" : object.toString();
    }
}

