/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.core.refactoring.descriptors;

import org.ccdt.jsdt.core.refactoring.descriptors.JavaScriptRefactoringDescriptor;
import org.ccdt.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RenameResourceDescriptor
extends JavaScriptRefactoringDescriptor {
    private String fName = null;
    private IResource fResource = null;

    public RenameResourceDescriptor() {
        super("org.ccdt.jsdt.ui.rename.resource");
    }

    @Override
    protected void populateArgumentMap() {
        super.populateArgumentMap();
        this.fArguments.put("input", RenameResourceDescriptor.resourceToHandle(this.getProject(), this.fResource));
        this.fArguments.put("name", this.fName);
    }

    public void setNewName(String string) {
        Assert.isNotNull((Object)string);
        Assert.isLegal((!"".equals(string) ? 1 : 0) != 0, (String)"Name must not be empty");
        this.fName = string;
    }

    @Override
    public void setProject(String string) {
        super.setProject(string);
    }

    public void setResource(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        this.fResource = iResource;
    }

    @Override
    public RefactoringStatus validateDescriptor() {
        RefactoringStatus refactoringStatus = super.validateDescriptor();
        if (this.fResource == null) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_no_resource));
        }
        if (this.fName == null || "".equals(this.fName)) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_no_new_name));
        }
        if (this.fResource instanceof IProject && this.getProject() != null) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_project_constraint));
        }
        return refactoringStatus;
    }
}

