/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.editors;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.tigris.subversion.subclipse.graph.cache.Branch;
import org.tigris.subversion.subclipse.graph.cache.Graph;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.cache.Path;
import org.tigris.subversion.subclipse.graph.editors.BranchEditPart;
import org.tigris.subversion.subclipse.graph.editors.GraphEditPart;
import org.tigris.subversion.subclipse.graph.editors.PathEditPart;
import org.tigris.subversion.subclipse.graph.editors.RevisionEditPart;

public class GraphEditPartFactory
implements EditPartFactory {
    private GraphicalViewer viewer;

    public GraphEditPartFactory(GraphicalViewer viewer) {
        this.viewer = viewer;
    }

    public EditPart createEditPart(EditPart context, Object model) {
        AbstractGraphicalEditPart editPart = null;
        if (model instanceof String) {
            final String s = (String)model;
            return new AbstractGraphicalEditPart(){

                protected IFigure createFigure() {
                    return new Label(s);
                }

                protected void createEditPolicies() {
                }
            };
        }
        if (model instanceof Graph) {
            editPart = new GraphEditPart(this.viewer);
        } else if (model instanceof Branch) {
            editPart = new BranchEditPart();
        } else if (model instanceof Path) {
            editPart = new PathEditPart();
        } else if (model instanceof Node) {
            editPart = new RevisionEditPart();
        }
        if (editPart == null) {
            throw new RuntimeException("cannot create EditPart for " + model.getClass().getName() + " class");
        }
        editPart.setModel(model);
        return editPart;
    }
}

