/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ccdt.debug.core.jsdi.ScriptReference;
import org.ccdt.debug.core.model.IScriptResolver;
import org.ccdt.debug.internal.core.launching.SourceLookup;
import org.ccdt.debug.internal.core.model.ScriptResolverExtension;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;

public final class ScriptResolutionManager {
    static IScriptResolver[] aX = new IScriptResolver[0];
    ListenerList aY = null;

    public boolean matches(ScriptReference scriptReference, IPath iPath) {
        IScriptResolver[] iScriptResolverArray = this.getResolvers();
        int n = 0;
        while (n < iScriptResolverArray.length) {
            if (iScriptResolverArray[n].matches(scriptReference, iPath)) {
                return true;
            }
            ++n;
        }
        return this.a(scriptReference, iPath);
    }

    boolean a(ScriptReference scriptReference, IPath iPath) {
        URI uRI;
        IPath iPath2;
        if (this.b(scriptReference, iPath)) {
            return true;
        }
        URI uRI2 = scriptReference.sourceURI();
        if (URIUtil.isFileURI((URI)uRI2)) {
            iPath2 = ResourcesPlugin.getWorkspace().getRoot();
            uRI = iPath2.getRawLocationURI();
            uRI2 = uRI.relativize(uRI2);
        }
        if ((iPath2 = iPath).segmentCount() > 0) {
            iPath2 = iPath2.removeFirstSegments(1).makeAbsolute();
        }
        if ((uRI = SourceLookup.getSourcePath(uRI2)) != null) {
            uRI = uRI.makeAbsolute();
        }
        return iPath2.equals((Object)uRI);
    }

    boolean b(ScriptReference scriptReference, IPath iPath) {
        IPath iPath2 = iPath.makeAbsolute();
        Path path = new Path(scriptReference.sourceURI().getPath());
        if (SourceLookup.TOP_LEVEL_PATH.equals((Object)iPath2) && SourceLookup.TOP_LEVEL_PATH.equals((Object)path)) {
            return true;
        }
        path = path.makeAbsolute();
        int n = 0;
        int n2 = path.segmentCount() - 1;
        int n3 = iPath2.segmentCount() - 1;
        while (n3 > -1) {
            if (n2 < 0) break;
            if (iPath2.segment(n3).equals(path.segment(n2))) {
                ++n;
                --n2;
            }
            --n3;
        }
        return n > 1;
    }

    public IFile getFile(ScriptReference scriptReference) {
        IScriptResolver[] iScriptResolverArray = this.getResolvers();
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        IFile iFile = null;
        int n = 0;
        while (n < iScriptResolverArray.length) {
            iFile = iScriptResolverArray[n].getFile(scriptReference);
            if (iFile != null) {
                if (arrayList.contains(iFile)) {
                    return iFile;
                }
                arrayList.add(iFile);
            }
            ++n;
        }
        iFile = null;
        IPath iPath = SourceLookup.getSourcePath(scriptReference.sourceURI());
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath.makeAbsolute());
        if (iResource != null && iResource.getType() == 1) {
            iFile = (IFile)iResource;
        }
        if (arrayList.size() > 0) {
            if (arrayList.contains(iFile)) {
                return iFile;
            }
            return (IFile)arrayList.get(0);
        }
        return iFile;
    }

    public IScriptResolver[] getResolvers() {
        this.z();
        if (this.aY.size() < 1) {
            return aX;
        }
        List<Object> list = Arrays.asList(this.aY.getListeners());
        return list.toArray(new IScriptResolver[list.size()]);
    }

    void z() {
        if (this.aY == null) {
            this.aY = new ListenerList();
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.ccdt.debug.core", "scriptResolvers");
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                this.aY.add((Object)new ScriptResolverExtension(iConfigurationElementArray[n]));
                ++n;
            }
        }
    }

    public void dispose() {
        if (this.aY != null) {
            this.aY.clear();
            this.aY = null;
        }
    }
}

