/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ccdt.debug.core.jsdi.ArrayReference;
import org.ccdt.debug.core.jsdi.BooleanValue;
import org.ccdt.debug.core.jsdi.FunctionReference;
import org.ccdt.debug.core.jsdi.NullValue;
import org.ccdt.debug.core.jsdi.NumberValue;
import org.ccdt.debug.core.jsdi.ObjectReference;
import org.ccdt.debug.core.jsdi.Property;
import org.ccdt.debug.core.jsdi.StringValue;
import org.ccdt.debug.core.jsdi.UndefinedValue;
import org.ccdt.debug.core.jsdi.Value;
import org.ccdt.debug.core.model.IJavaScriptValue;
import org.ccdt.debug.core.model.JavaScriptDebugModel;
import org.ccdt.debug.internal.core.JavaScriptDebugPlugin;
import org.ccdt.debug.internal.core.model.JavaScriptDebugElement;
import org.ccdt.debug.internal.core.model.JavaScriptDebugTarget;
import org.ccdt.debug.internal.core.model.JavaScriptPrimitiveValue;
import org.ccdt.debug.internal.core.model.JavaScriptProperty;
import org.ccdt.debug.internal.core.model.JavaScriptValue$1;
import org.ccdt.debug.internal.core.model.JavaScriptValue$2;
import org.ccdt.debug.internal.core.model.JavaScriptValue$3;
import org.ccdt.debug.internal.core.model.ModelMessages;
import org.ccdt.jsdt.core.ToolFactory;
import org.ccdt.jsdt.core.formatter.CodeFormatter;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEdit;

public class JavaScriptValue
extends JavaScriptDebugElement
implements IJavaScriptValue {
    public static final IVariable[] NO_VARIABLES = new IVariable[0];
    public static final String PROTO = "[proto]";
    public static final String CONSTRUCTOR = "constructor";
    public static final String THIS = "this";
    private Value aP;
    private List aQ;

    public JavaScriptValue(JavaScriptDebugTarget javaScriptDebugTarget, Value value) {
        super(javaScriptDebugTarget);
        this.aP = value;
    }

    protected Value getUnderlyingValue() {
        return this.aP;
    }

    @Override
    public String getDetailString() {
        if (this.aP instanceof ArrayReference) {
            ArrayReference arrayReference = (ArrayReference)this.aP;
            List list = arrayReference.getValues();
            Iterator iterator = list.iterator();
            if (!iterator.hasNext()) {
                return "[]";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            while (true) {
                Value value = (Value)iterator.next();
                stringBuffer.append(JavaScriptValue.a(value));
                if (!iterator.hasNext()) {
                    return stringBuffer.append(']').toString();
                }
                stringBuffer.append(", ");
            }
        }
        if (this.aP instanceof JavaScriptPrimitiveValue) {
            JavaScriptPrimitiveValue javaScriptPrimitiveValue = (JavaScriptPrimitiveValue)((Object)this.aP);
            return javaScriptPrimitiveValue.stringValue();
        }
        if (this.aP instanceof FunctionReference) {
            CodeFormatter codeFormatter;
            TextEdit textEdit;
            FunctionReference functionReference = (FunctionReference)this.aP;
            String string = functionReference.functionBody();
            if (string != null && (textEdit = (codeFormatter = ToolFactory.createCodeFormatter(null)).format(8, string, 0, string.length(), 0, null)) != null) {
                Document document = new Document(string);
                try {
                    textEdit.apply((IDocument)document);
                    return document.get();
                }
                catch (Exception exception) {
                    JavaScriptDebugPlugin.log(exception);
                }
            }
            return functionReference.valueString();
        }
        if (this.aP != null) {
            return this.aP.valueString();
        }
        return "undefined";
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.aP != null) {
            if (this.aP instanceof ObjectReference) {
                if (this.aP instanceof NullValue) {
                    return "null";
                }
                if (this.aP instanceof ArrayReference) {
                    return "array";
                }
                if (this.aP instanceof FunctionReference) {
                    return "function";
                }
                return "object";
            }
            if (this.aP instanceof BooleanValue) {
                return "boolean";
            }
            if (this.aP instanceof UndefinedValue) {
                return "undefined";
            }
            if (this.aP instanceof NumberValue) {
                return "number";
            }
            if (this.aP instanceof StringValue) {
                return "string";
            }
        }
        return "unknown";
    }

    public String getValueString() throws DebugException {
        return JavaScriptValue.a(this.aP);
    }

    private static String a(Value value) {
        Object object;
        if (value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value;
            StringBuffer stringBuffer = new StringBuffer();
            String string = objectReference.id();
            if (string == null) {
                stringBuffer.append(value.valueString());
            } else {
                stringBuffer.append(NLS.bind((String)ModelMessages.JavaScriptValue_object_value_label, (Object[])new String[]{value.valueString(), string}));
            }
            return stringBuffer.toString();
        }
        if (value instanceof NumberValue && !(object = (NumberValue)value).isNaN()) {
            return JavaScriptDebugModel.numberToString(object.value());
        }
        if (value instanceof StringValue) {
            object = new StringBuffer();
            ((StringBuffer)object).append('\"');
            ((StringBuffer)object).append(value.valueString().replaceAll("\"", "\\\\\""));
            ((StringBuffer)object).append('\"');
            return ((StringBuffer)object).toString();
        }
        return value.valueString();
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        if (!this.hasVariables()) {
            return NO_VARIABLES;
        }
        if (this.aQ == null) {
            Property property2;
            ObjectReference objectReference = (ObjectReference)this.aP;
            List list = objectReference.properties();
            this.aQ = new ArrayList(list.size() + 1);
            for (Property property2 : list) {
                JavaScriptProperty javaScriptProperty = new JavaScriptProperty(this, property2);
                this.aQ.add(javaScriptProperty);
            }
            Collections.sort(this.aQ, new JavaScriptValue$1(this));
            JavaScriptValue$2 javaScriptValue$2 = new JavaScriptValue$2(this, objectReference);
            this.aQ.add(0, new JavaScriptProperty(this, javaScriptValue$2));
            property2 = new JavaScriptValue$3(this, objectReference);
            this.aQ.add(1, new JavaScriptProperty(this, property2));
        }
        return this.aQ.toArray(new IVariable[this.aQ.size()]);
    }

    public boolean hasVariables() throws DebugException {
        if (this.aP instanceof ObjectReference) {
            return !(this.aP instanceof NullValue);
        }
        return false;
    }

    public boolean isAllocated() throws DebugException {
        return this.aQ != null;
    }

    @Override
    public boolean isNull() {
        return this.aP instanceof NullValue;
    }

    public static IJavaScriptValue createValue(JavaScriptDebugTarget javaScriptDebugTarget, Value value) {
        if (value instanceof BooleanValue || value instanceof NullValue || value instanceof NumberValue) {
            return new JavaScriptPrimitiveValue(javaScriptDebugTarget, value);
        }
        return new JavaScriptValue(javaScriptDebugTarget, value);
    }
}

