/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.ccdt.debug.core.jsdi.Location;
import org.ccdt.debug.core.jsdi.ScriptReference;
import org.ccdt.debug.core.jsdi.StackFrame;
import org.ccdt.debug.core.jsdi.Variable;
import org.ccdt.debug.core.model.IJavaScriptStackFrame;
import org.ccdt.debug.core.model.IJavaScriptValue;
import org.ccdt.debug.internal.core.model.JavaScriptDebugElement;
import org.ccdt.debug.internal.core.model.JavaScriptThread;
import org.ccdt.debug.internal.core.model.JavaScriptVariable;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public final class JavaScriptStackFrame
extends JavaScriptDebugElement
implements IJavaScriptStackFrame {
    private JavaScriptThread az;
    private StackFrame aA = null;
    private ArrayList aB;
    private IVariable aC = null;

    public JavaScriptStackFrame(JavaScriptThread javaScriptThread, StackFrame stackFrame) {
        super(javaScriptThread.getJavaScriptDebugTarget());
        this.az = javaScriptThread;
        this.aA = stackFrame;
    }

    StackFrame p() {
        return this.aA;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getLineNumber() throws DebugException {
        return this.aA.location() != null ? this.aA.location().lineNumber() : -1;
    }

    public String getName() throws DebugException {
        return this.aA.location().functionName();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public IThread getThread() {
        return this.az;
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        if (this.aB == null) {
            List list = this.aA.variables();
            this.aB = new ArrayList(list.size() + 1);
            for (Variable variable : list) {
                JavaScriptVariable javaScriptVariable = new JavaScriptVariable(this, variable);
                this.aB.add(javaScriptVariable);
            }
            this.aC = new JavaScriptVariable(this, this.aA.thisObject());
            this.aB.add(0, this.aC);
        }
        return this.aB.toArray(new IVariable[this.aB.size()]);
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return this.aA.variables().size() > 0;
    }

    public boolean canStepInto() {
        return this.az.canStepInto();
    }

    public boolean canStepOver() {
        return this.az.canStepOver();
    }

    public boolean canStepReturn() {
        return this.az.canStepReturn();
    }

    public boolean isStepping() {
        return this.az.isStepping();
    }

    public void stepInto() throws DebugException {
        this.az.stepInto();
    }

    public void stepOver() throws DebugException {
        this.az.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.az.stepReturn();
    }

    public boolean canResume() {
        return this.az.canResume();
    }

    public boolean canSuspend() {
        return this.az.canSuspend();
    }

    public boolean isSuspended() {
        return this.az.isSuspended();
    }

    public void resume() throws DebugException {
        this.az.resume();
    }

    public void suspend() throws DebugException {
        this.az.suspend();
    }

    public boolean canTerminate() {
        return this.az.canTerminate();
    }

    public boolean isTerminated() {
        return this.az.isTerminated();
    }

    public void terminate() throws DebugException {
        if (this.az.canTerminate()) {
            this.az.terminate();
        } else {
            this.getJavaScriptDebugTarget().terminate();
        }
    }

    @Override
    public IJavaScriptValue evaluate(String string) {
        return this.az.evaluate(string);
    }

    @Override
    public String getSourceName() {
        ScriptReference scriptReference;
        Location location = this.p().location();
        if (location != null && (scriptReference = location.scriptReference()) != null) {
            String string = URIUtil.lastSegment((URI)scriptReference.sourceURI());
            if (string == null) {
                return scriptReference.sourceURI().toString();
            }
            return string;
        }
        return null;
    }

    @Override
    public String getSourcePath() {
        ScriptReference scriptReference;
        Location location = this.p().location();
        if (location != null && (scriptReference = location.scriptReference()) != null) {
            return scriptReference.sourceURI().toString();
        }
        return null;
    }

    @Override
    public String getSource() {
        ScriptReference scriptReference;
        Location location = this.p().location();
        if (location != null && (scriptReference = location.scriptReference()) != null) {
            return scriptReference.source();
        }
        return null;
    }

    @Override
    public Object getAdapter(Class clazz) {
        if (IJavaScriptStackFrame.class == clazz) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    @Override
    public IVariable getThisObject() {
        return this.aC;
    }

    @Override
    public boolean canEvalInExpressionsView() {
        return this.aA.canEvalInExpressionsView();
    }

    public IVariable findLocalVariable(String string) {
        try {
            IVariable[] iVariableArray = this.getVariables();
            int n = 0;
            while (n < iVariableArray.length) {
                JavaScriptVariable javaScriptVariable = (JavaScriptVariable)iVariableArray[n];
                JavaScriptVariable javaScriptVariable2 = javaScriptVariable.getChildIVariable(string);
                if (javaScriptVariable2 != null) {
                    return javaScriptVariable2;
                }
                ++n;
            }
        }
        catch (DebugException debugException) {}
        return null;
    }
}

