/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.core.launching;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.ccdt.debug.core.model.IJavaScriptStackFrame;
import org.ccdt.debug.core.model.IScript;
import org.ccdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.URIUtil;

public final class SourceLookup {
    public static final QualifiedName SCRIPT_URL = new QualifiedName("org.ccdt.jsdt.core", "scriptURL");
    public static final IPath TOP_LEVEL_PATH = new Path("/");

    public static String getSourceName(Object object) {
        String string = null;
        if (object instanceof IJavaScriptStackFrame) {
            string = ((IJavaScriptStackFrame)object).getSourceName();
        }
        if (object instanceof IScript) {
            string = URIUtil.lastSegment((URI)((IScript)object).sourceURI());
        }
        if (string != null) {
            if (new Path(string).getFileExtension() == null) {
                StringBuffer stringBuffer = new StringBuffer(string.length() + 3);
                stringBuffer.append(string).append('.').append("js");
                return stringBuffer.toString();
            }
            return string;
        }
        return null;
    }

    public static String getSource(Object object) {
        if (object instanceof IJavaScriptStackFrame) {
            IJavaScriptStackFrame iJavaScriptStackFrame = (IJavaScriptStackFrame)object;
            return iJavaScriptStackFrame.getSource();
        }
        if (object instanceof IScript) {
            IScript iScript = (IScript)object;
            return iScript.source();
        }
        return null;
    }

    public static URI getSourceURI(Object object) {
        Object object2;
        if (object instanceof IJavaScriptStackFrame) {
            object2 = (IJavaScriptStackFrame)object;
            try {
                return new URI(object2.getSourcePath());
            }
            catch (URISyntaxException uRISyntaxException) {
                try {
                    return URIUtil.fromString((String)object2.getSourcePath());
                }
                catch (URISyntaxException uRISyntaxException2) {
                    JavaScriptDebugPlugin.log(uRISyntaxException2);
                }
            }
        }
        if (object instanceof IScript) {
            object2 = (IScript)object;
            return object2.sourceURI();
        }
        return null;
    }

    public static IPath getSourcePath(URI uRI) {
        String string = uRI.getPath();
        if (string == null) {
            return null;
        }
        if (string.trim().equals("/")) {
            string = "index.htm";
        }
        String string2 = uRI.getHost();
        Path path = null;
        if (string2 != null) {
            path = new Path(string2);
        }
        if (path == null) {
            return SourceLookup.a(string);
        }
        path = path.append(string);
        return SourceLookup.a((IPath)path);
    }

    static IFile a(IFile iFile, String string) throws CoreException {
        if (iFile.isAccessible()) {
            iFile.setContents((InputStream)new ByteArrayInputStream(string.getBytes()), 1, null);
        } else {
            iFile.create((InputStream)new ByteArrayInputStream(string.getBytes()), true, null);
        }
        return iFile;
    }

    static IPath a(IPath iPath) {
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>(iPath.segmentCount());
        int n = 0;
        while (n < iPath.segments().length) {
            string = iPath.segment(n);
            if (n > 0) {
                if (string.length() > 15) {
                    string = String.valueOf(string.substring(0, 1)) + string.charAt(string.length() - 1);
                }
                if (n < iPath.segments().length - 1) {
                    string = string.replaceAll("\\.js", "\\_js");
                    if ((string = string.replaceAll("\\.html", "\\_html")).endsWith(".")) {
                        string = String.valueOf(string.substring(0, string.length() - 1)) + '_';
                    }
                }
            }
            arrayList.add(string);
            ++n;
        }
        Path path = new Path((String)arrayList.get(0));
        int n2 = 1;
        while (n2 < arrayList.size()) {
            path = path.append((String)arrayList.get(n2));
            ++n2;
        }
        String string2 = path.getFileExtension();
        if (string2 == null && !"js".equals(string2)) {
            path = path.addFileExtension("js");
        }
        return path;
    }

    static IPath a(String string) {
        String string2 = string;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            String string3 = iProjectArray[n].getName();
            int n2 = string.indexOf("/" + string3 + "/");
            if (n2 != -1) {
                string2 = string.substring(n2, string.length());
                break;
            }
            ++n;
        }
        Path path = new Path(string2);
        return path;
    }
}

