/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.core.breakpoints;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.ccdt.debug.core.breakpoints.IJavaScriptLoadBreakpoint;
import org.ccdt.debug.core.jsdi.ScriptReference;
import org.ccdt.debug.core.jsdi.VirtualMachine;
import org.ccdt.debug.core.jsdi.event.Event;
import org.ccdt.debug.core.jsdi.event.EventSet;
import org.ccdt.debug.core.jsdi.event.ScriptLoadEvent;
import org.ccdt.debug.core.jsdi.request.EventRequest;
import org.ccdt.debug.core.jsdi.request.ScriptLoadRequest;
import org.ccdt.debug.internal.core.JavaScriptDebugPlugin;
import org.ccdt.debug.internal.core.JavaScriptPreferencesManager;
import org.ccdt.debug.internal.core.breakpoints.JavaScriptLineBreakpoint;
import org.ccdt.debug.internal.core.breakpoints.JavaScriptLoadBreakpoint$1;
import org.ccdt.debug.internal.core.model.JavaScriptDebugTarget;
import org.ccdt.debug.internal.core.model.JavaScriptThread;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;

public class JavaScriptLoadBreakpoint
extends JavaScriptLineBreakpoint
implements IJavaScriptLoadBreakpoint {
    public static final String GLOBAL_SUSPEND = "org.ccdt.debug.core.global_suspend";

    public JavaScriptLoadBreakpoint() {
    }

    public JavaScriptLoadBreakpoint(IResource iResource, int n, int n2, Map map, boolean bl) throws DebugException {
        JavaScriptLoadBreakpoint$1 javaScriptLoadBreakpoint$1 = new JavaScriptLoadBreakpoint$1(this, iResource, map, n, n2, bl);
        this.run(this.getMarkerRule((IResource)ResourcesPlugin.getWorkspace().getRoot()), javaScriptLoadBreakpoint$1);
    }

    @Override
    public boolean handleEvent(Event event, JavaScriptDebugTarget javaScriptDebugTarget, boolean bl, EventSet eventSet) {
        if (event instanceof ScriptLoadEvent) {
            ScriptLoadEvent scriptLoadEvent = (ScriptLoadEvent)event;
            ScriptReference scriptReference = scriptLoadEvent.script();
            JavaScriptThread javaScriptThread = javaScriptDebugTarget.findThread(scriptLoadEvent.thread());
            if (javaScriptThread != null) {
                if (this.e()) {
                    if (!this.a(javaScriptDebugTarget.getVM())) {
                        return true;
                    }
                    JavaScriptPreferencesManager.setGlobalSuspendOn(scriptReference.sourceURI().toString());
                    javaScriptThread.addBreakpoint(this);
                    return false;
                }
                if (this.a(scriptReference, javaScriptThread, bl)) {
                    javaScriptThread.addBreakpoint(this);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean a(ScriptReference scriptReference, JavaScriptThread javaScriptThread, boolean bl) {
        try {
            if (JavaScriptDebugPlugin.getResolutionManager().matches(scriptReference, (IPath)new Path(this.getScriptPath()))) {
                int n = javaScriptThread.suspendForScriptLoad(this, scriptReference, bl);
                return (n & 1) > 0 || n == 0;
            }
        }
        catch (CoreException coreException) {
            JavaScriptDebugPlugin.log(coreException);
        }
        return false;
    }

    boolean a(VirtualMachine virtualMachine) {
        boolean bl = true;
        try {
            Method method = virtualMachine.getClass().getMethod("supportsSuspendOnScriptLoads", new Class[0]);
            Boolean bl2 = (Boolean)method.invoke((Object)virtualMachine, null);
            bl = bl2;
        }
        catch (Exception exception) {
            bl = true;
        }
        return bl;
    }

    private boolean e() {
        try {
            return this.ensureMarker().getAttribute(GLOBAL_SUSPEND, false);
        }
        catch (CoreException coreException) {
            JavaScriptDebugPlugin.log(coreException);
            return false;
        }
    }

    @Override
    protected void registerRequest(JavaScriptDebugTarget javaScriptDebugTarget, EventRequest eventRequest) {
        ArrayList arrayList = this.getRequests(javaScriptDebugTarget);
        if (arrayList == null || arrayList.isEmpty()) {
            this.addRequestForTarget(javaScriptDebugTarget, eventRequest);
            try {
                if (this.isRegistered()) {
                    this.incrementInstallCount();
                }
            }
            catch (CoreException coreException) {
                JavaScriptDebugPlugin.log(coreException);
            }
        }
    }

    @Override
    protected void deregisterRequest(JavaScriptDebugTarget javaScriptDebugTarget, EventRequest eventRequest) {
        javaScriptDebugTarget.removeJSDIEventListener(this, eventRequest);
        try {
            this.decrementInstallCount();
        }
        catch (CoreException coreException) {
            JavaScriptDebugPlugin.log(coreException);
        }
    }

    @Override
    public void eventSetComplete(Event event, JavaScriptDebugTarget javaScriptDebugTarget, boolean bl, EventSet eventSet) {
        JavaScriptThread javaScriptThread;
        if (event instanceof ScriptLoadEvent && (javaScriptThread = javaScriptDebugTarget.findThread(((ScriptLoadEvent)event).thread())) != null) {
            ScriptLoadEvent scriptLoadEvent = (ScriptLoadEvent)event;
            javaScriptThread.suspendForScriptLoadComplete(this, scriptLoadEvent.script(), bl, eventSet);
        }
    }

    @Override
    protected boolean createRequest(JavaScriptDebugTarget javaScriptDebugTarget, ScriptReference scriptReference) throws CoreException {
        ScriptLoadRequest scriptLoadRequest = javaScriptDebugTarget.getEventRequestManager().createScriptLoadRequest();
        this.registerRequest(javaScriptDebugTarget, scriptLoadRequest);
        scriptLoadRequest.setEnabled(this.isEnabled());
        return false;
    }

    static /* synthetic */ IMarker a(JavaScriptLoadBreakpoint javaScriptLoadBreakpoint) throws DebugException {
        return javaScriptLoadBreakpoint.ensureMarker();
    }
}

