/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.ccdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.ccdt.debug.core.jsdi.Location;
import org.ccdt.debug.core.jsdi.ScriptReference;
import org.ccdt.debug.core.jsdi.request.BreakpointRequest;
import org.ccdt.debug.internal.core.breakpoints.JavaScriptBreakpoint;
import org.ccdt.debug.internal.core.breakpoints.JavaScriptLineBreakpoint$1;
import org.ccdt.debug.internal.core.model.JavaScriptDebugTarget;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;

public class JavaScriptLineBreakpoint
extends JavaScriptBreakpoint
implements IJavaScriptLineBreakpoint {
    public static final String CONDITION = "org.ccdt.debug.core.condition";
    public static final String CONDITION_ENABLED = "org.ccdt.debug.core.condition_enabled";
    public static final String CONDITION_SUSPEND_ON_TRUE = "org.ccdt.debug.core.condition_suspend_on_true";

    public JavaScriptLineBreakpoint() {
    }

    public JavaScriptLineBreakpoint(IResource iResource, int n, int n2, int n3, Map map, boolean bl) throws DebugException {
        JavaScriptLineBreakpoint$1 javaScriptLineBreakpoint$1 = new JavaScriptLineBreakpoint$1(this, iResource, map, n, n2, n3, bl);
        this.run(this.getMarkerRule(iResource), javaScriptLineBreakpoint$1);
    }

    @Override
    protected boolean createRequest(JavaScriptDebugTarget javaScriptDebugTarget, ScriptReference scriptReference) throws CoreException {
        Location location = scriptReference.lineLocation(this.getLineNumber());
        if (location == null) {
            this.decrementInstallCount();
            return false;
        }
        BreakpointRequest breakpointRequest = javaScriptDebugTarget.getEventRequestManager().createBreakpointRequest(location);
        this.registerRequest(javaScriptDebugTarget, breakpointRequest);
        this.configureRequest(breakpointRequest);
        breakpointRequest.setEnabled(this.isEnabled());
        return true;
    }

    @Override
    protected void configureRequest(BreakpointRequest breakpointRequest) throws CoreException {
        super.configureRequest(breakpointRequest);
        breakpointRequest.addConditionFilter(this.getCondition());
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    @Override
    public boolean isConditionEnabled() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION_ENABLED, false);
    }

    @Override
    public boolean isConditionSuspendOnTrue() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION_SUSPEND_ON_TRUE, true);
    }

    @Override
    public void setConditionSuspendOnTrue(boolean bl) throws CoreException {
        if (bl != this.isConditionSuspendOnTrue()) {
            this.setAttribute(CONDITION_SUSPEND_ON_TRUE, bl);
            this.handleBreakpointChange();
        }
    }

    @Override
    public void setCondition(String string) throws CoreException {
        if (string != null && string.length() == 0) {
            this.setAttribute(CONDITION, null);
        } else {
            this.setAttribute(CONDITION, string);
        }
        this.handleBreakpointChange();
    }

    @Override
    public String getCondition() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION, null);
    }

    @Override
    public void setConditionEnabled(boolean bl) throws CoreException {
        if (this.isConditionEnabled() != bl) {
            this.setAttribute(CONDITION_ENABLED, bl);
            this.handleBreakpointChange();
        }
    }

    static /* synthetic */ IMarker a(JavaScriptLineBreakpoint javaScriptLineBreakpoint) throws DebugException {
        return javaScriptLineBreakpoint.ensureMarker();
    }
}

