/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.ccdt.debug.core.jsdi.ScriptReference;
import org.ccdt.debug.core.jsdi.event.Event;
import org.ccdt.debug.core.jsdi.event.EventSet;
import org.ccdt.debug.core.jsdi.event.ExceptionEvent;
import org.ccdt.debug.core.jsdi.request.EventRequest;
import org.ccdt.debug.core.jsdi.request.ExceptionRequest;
import org.ccdt.debug.internal.core.JavaScriptDebugPlugin;
import org.ccdt.debug.internal.core.breakpoints.JavaScriptBreakpoint;
import org.ccdt.debug.internal.core.breakpoints.JavaScriptExceptionBreakpoint$1;
import org.ccdt.debug.internal.core.model.JavaScriptDebugTarget;
import org.ccdt.debug.internal.core.model.JavaScriptThread;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;

public class JavaScriptExceptionBreakpoint
extends JavaScriptBreakpoint {
    public static final String MESSAGE = "org.ccdt.debug.core.exception_message";
    private ExceptionRequest w = null;

    public JavaScriptExceptionBreakpoint() {
    }

    public JavaScriptExceptionBreakpoint(Map map) throws DebugException {
        JavaScriptExceptionBreakpoint$1 javaScriptExceptionBreakpoint$1 = new JavaScriptExceptionBreakpoint$1(this, map);
        this.run(this.getMarkerRule((IResource)ResourcesPlugin.getWorkspace().getRoot()), javaScriptExceptionBreakpoint$1);
    }

    @Override
    public String getModelIdentifier() {
        return "org.ccdt.debug.model";
    }

    @Override
    public void addToTarget(JavaScriptDebugTarget javaScriptDebugTarget) throws CoreException {
        if (javaScriptDebugTarget.isTerminated() || this.shouldSkipBreakpoint()) {
            return;
        }
        if (this.w == null) {
            this.w = javaScriptDebugTarget.getVM().eventRequestManager().createExceptionRequest();
            this.w.setEnabled(true);
            this.addRequestForTarget(javaScriptDebugTarget, this.w);
        }
    }

    @Override
    protected void deregisterRequest(JavaScriptDebugTarget javaScriptDebugTarget, EventRequest eventRequest) {
        javaScriptDebugTarget.removeJSDIEventListener(this, eventRequest);
        this.w = null;
    }

    @Override
    protected boolean createRequest(JavaScriptDebugTarget javaScriptDebugTarget, ScriptReference scriptReference) throws CoreException {
        return true;
    }

    @Override
    public boolean handleEvent(Event event, JavaScriptDebugTarget javaScriptDebugTarget, boolean bl, EventSet eventSet) {
        if (event instanceof ExceptionEvent) {
            try {
                ExceptionEvent exceptionEvent = (ExceptionEvent)event;
                this.setAttribute(MESSAGE, exceptionEvent.message());
                JavaScriptThread javaScriptThread = javaScriptDebugTarget.findThread(exceptionEvent.thread());
                if (javaScriptThread != null) {
                    javaScriptThread.addBreakpoint(this);
                    return false;
                }
            }
            catch (CoreException coreException) {
                JavaScriptDebugPlugin.log(coreException);
            }
        }
        return true;
    }

    @Override
    public void eventSetComplete(Event event, JavaScriptDebugTarget javaScriptDebugTarget, boolean bl, EventSet eventSet) {
        JavaScriptThread javaScriptThread;
        if (event instanceof ExceptionEvent && (javaScriptThread = javaScriptDebugTarget.findThread(((ExceptionEvent)event).thread())) != null) {
            javaScriptThread.suspendForException(this);
        }
    }

    static /* synthetic */ IMarker b(JavaScriptExceptionBreakpoint javaScriptExceptionBreakpoint) throws DebugException {
        return javaScriptExceptionBreakpoint.ensureMarker();
    }
}

